/*
 * Decompiled with CFR 0.152.
 */
package jpass;

import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.metal.DefaultMetalTheme;
import javax.swing.plaf.metal.MetalLookAndFeel;
import jpass.ui.JPassFrame;
import jpass.util.Configuration;

public class JPass {
    private static final String METAL_LOOK_AND_FEEL = "javax.swing.plaf.metal.MetalLookAndFeel";

    public static void main(final String[] args) {
        try {
            String lookAndFeel = Configuration.getInstance().is("system.look.and.feel.enabled", false) != false ? UIManager.getSystemLookAndFeelClassName() : METAL_LOOK_AND_FEEL;
            if (METAL_LOOK_AND_FEEL.equals(lookAndFeel)) {
                MetalLookAndFeel.setCurrentTheme(new DefaultMetalTheme(){
                    private final ColorUIResource primary1 = new ColorUIResource(5072769);
                    private final ColorUIResource primary2 = new ColorUIResource(8033968);
                    private final ColorUIResource primary3 = new ColorUIResource(13161698);
                    private final ColorUIResource secondary1 = new ColorUIResource(0);
                    private final ColorUIResource secondary2 = new ColorUIResource(0xAAAAAA);
                    private final ColorUIResource secondary3 = new ColorUIResource(0xDFDFDF);

                    @Override
                    protected ColorUIResource getPrimary1() {
                        return this.primary1;
                    }

                    @Override
                    protected ColorUIResource getPrimary2() {
                        return this.primary2;
                    }

                    @Override
                    protected ColorUIResource getPrimary3() {
                        return this.primary3;
                    }

                    @Override
                    protected ColorUIResource getSecondary1() {
                        return this.secondary1;
                    }

                    @Override
                    protected ColorUIResource getSecondary2() {
                        return this.secondary2;
                    }

                    @Override
                    protected ColorUIResource getSecondary3() {
                        return this.secondary3;
                    }
                });
                UIManager.put("swing.boldMetal", Boolean.FALSE);
            }
            UIManager.setLookAndFeel(lookAndFeel);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JPassFrame.getInstance(args.length > 0 ? args[0] : null);
            }
        });
    }
}

