/*
 * Decompiled with CFR 0.152.
 */
package jpass.crypt;

import java.io.IOException;
import java.io.OutputStream;
import jpass.crypt.Aes256;
import jpass.crypt.DecryptException;

public class Cbc {
    private static final int BLOCK_SIZE = 16;
    private Aes256 _cipher;
    private byte[] _current;
    private byte[] _buffer = null;
    private byte[] _tmp;
    private byte[] _outBuffer = null;
    private boolean _outBufferUsed = false;
    private byte[] _overflow;
    private int _overflowUsed;
    private OutputStream _output;

    public Cbc(byte[] iv, byte[] key, OutputStream output) {
        this._cipher = new Aes256(key);
        this._current = new byte[16];
        System.arraycopy(iv, 0, this._current, 0, 16);
        this._tmp = new byte[16];
        this._buffer = new byte[16];
        this._outBuffer = new byte[16];
        this._outBufferUsed = false;
        this._overflow = new byte[16];
        this._overflowUsed = 0;
        this._output = output;
    }

    private void encryptBlock(byte[] inBuffer, byte[] outBuffer) {
        for (int i = 0; i < 16; ++i) {
            int n = i;
            this._current[n] = (byte)(this._current[n] ^ inBuffer[i]);
        }
        this._cipher.encrypt(this._current, 0, this._current, 0);
        System.arraycopy(this._current, 0, outBuffer, 0, 16);
    }

    private void decryptBlock(byte[] inBuffer, byte[] outBuffer) {
        System.arraycopy(inBuffer, 0, this._buffer, 0, 16);
        this._cipher.decrypt(this._buffer, 0, this._tmp, 0);
        for (int i = 0; i < 16; ++i) {
            int n = i;
            this._tmp[n] = (byte)(this._tmp[n] ^ this._current[i]);
            this._current[i] = this._buffer[i];
            this._outBuffer[i] = this._tmp[i];
        }
    }

    public void encrypt(byte[] data) throws IOException {
        if (data != null) {
            this.encrypt(data, data.length);
        }
    }

    public void decrypt(byte[] data) throws IOException {
        if (data != null) {
            this.decrypt(data, data.length);
        }
    }

    public void encrypt(byte[] data, int length) throws IOException {
        if (data == null || length <= 0) {
            return;
        }
        for (int i = 0; i < length; ++i) {
            this._overflow[this._overflowUsed++] = data[i];
            if (this._overflowUsed != 16) continue;
            this.encryptBlock(this._overflow, this._outBuffer);
            this._output.write(this._outBuffer);
            this._overflowUsed = 0;
        }
    }

    public void decrypt(byte[] data, int length) throws IOException {
        if (data == null || length <= 0) {
            return;
        }
        for (int i = 0; i < length; ++i) {
            this._overflow[this._overflowUsed++] = data[i];
            if (this._overflowUsed != 16) continue;
            if (this._outBufferUsed) {
                this._output.write(this._outBuffer);
            }
            this.decryptBlock(this._overflow, this._outBuffer);
            this._outBufferUsed = true;
            this._overflowUsed = 0;
        }
    }

    public void finishEncryption() throws IOException {
        byte pad = (byte)(16 - this._overflowUsed);
        while (this._overflowUsed < 16) {
            this._overflow[this._overflowUsed++] = pad;
        }
        this.encryptBlock(this._overflow, this._outBuffer);
        this._output.write(this._outBuffer);
        this._output.close();
    }

    public void finishDecryption() throws DecryptException, IOException {
        if (this._overflowUsed != 0) {
            throw new DecryptException();
        }
        if (!this._outBufferUsed) {
            return;
        }
        int pad = this._outBuffer[15] & 0xFF;
        if (pad <= 0 || pad > 16) {
            throw new DecryptException();
        }
        int left = 16 - pad;
        if (left > 0) {
            this._output.write(this._outBuffer, 0, left);
        }
        this._output.close();
    }
}

