/*
 * Decompiled with CFR 0.152.
 */
package jpass.data;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.xml.bind.JAXBException;
import jpass.crypt.io.CryptInputStream;
import jpass.crypt.io.CryptOutputStream;
import jpass.data.DocumentProcessException;
import jpass.util.StringUtils;
import jpass.xml.bind.Entries;
import jpass.xml.converter.JAXBConverter;

public final class DocumentHelper {
    private final String fileName;
    private final byte[] key;
    private static final JAXBConverter<Entries> CONVERTER = new JAXBConverter<Entries>(Entries.class, "resources/schemas/entries.xsd");

    private DocumentHelper(String fileName, byte[] key) {
        this.fileName = fileName;
        this.key = key;
    }

    public static DocumentHelper newInstance(String fileName) {
        return new DocumentHelper(fileName, null);
    }

    public static DocumentHelper newInstance(String fileName, byte[] key) {
        return new DocumentHelper(fileName, key);
    }

    public Entries readDocument() throws FileNotFoundException, IOException, DocumentProcessException {
        Entries entries;
        InputStream inputStream = null;
        try {
            inputStream = this.key == null ? new FileInputStream(this.fileName) : new GZIPInputStream(new CryptInputStream(new FileInputStream(this.fileName), this.key));
            entries = CONVERTER.unmarshal(inputStream);
        }
        catch (JAXBException e) {
            throw new DocumentProcessException(StringUtils.stripString(e.getLinkedException() == null ? e.getMessage() : e.getLinkedException().getMessage()));
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
        }
        return entries;
    }

    public void writeDocument(Entries document) throws DocumentProcessException, IOException {
        OutputStream outputStream = null;
        try {
            outputStream = this.key == null ? new FileOutputStream(this.fileName) : new GZIPOutputStream(new CryptOutputStream(new FileOutputStream(this.fileName), this.key));
            CONVERTER.marshal(document, outputStream, this.key == null);
        }
        catch (JAXBException e) {
            throw new DocumentProcessException(StringUtils.stripString(e.getLinkedException() == null ? e.getMessage() : e.getLinkedException().getMessage()));
        }
        catch (Exception e) {
            throw new DocumentProcessException(e.getMessage());
        }
        finally {
            if (outputStream != null) {
                outputStream.close();
            }
        }
    }
}

