/*
 * Decompiled with CFR 0.152.
 */
package jpass.ui.action;

import javax.swing.SwingWorker;
import jpass.ui.JPassFrame;
import jpass.ui.MessageDialog;

public abstract class Worker
extends SwingWorker<Void, Void> {
    private final JPassFrame parent;

    public Worker(JPassFrame parent) {
        this.parent = parent;
        this.parent.setProcessing(true);
    }

    @Override
    protected void done() {
        super.done();
        this.stopProcessing();
        try {
            this.get();
        }
        catch (Exception e) {
            this.showErrorMessage(e);
        }
    }

    protected void showErrorMessage(Exception e) {
        String message = e.getCause() != null ? e.getCause().getMessage() : e.getMessage();
        MessageDialog.showErrorMessage(this.parent, message);
    }

    protected void stopProcessing() {
        this.parent.setProcessing(false);
        this.parent.refreshAll();
    }
}

