/*
 * Decompiled with CFR 0.152.
 */
package shared.browserlaunch;

import java.io.IOException;
import java.lang.reflect.Method;

public class JBrowserLaunch {
    public static boolean openURL(String url) {
        boolean flag = false;
        String osName = System.getProperty("os.name");
        try {
            if (osName.startsWith("Mac OS")) {
                Class<?> fileMgr = Class.forName("com.apple.eio.FileManager");
                Method openURL = fileMgr.getDeclaredMethod("openURL", String.class);
                openURL.invoke(null, url);
                flag = true;
            } else if (osName.startsWith("Windows")) {
                Runtime.getRuntime().exec("rundll32 url.dll,FileProtocolHandler \"" + url + "\"");
                flag = true;
            } else {
                String[] browsers = new String[]{"firefox", "epiphany", "seamonkey", "mozilla", "netscape", "opera", "konqueror"};
                String browser = null;
                for (String item : browsers) {
                    try {
                        if (Runtime.getRuntime().exec(new String[]{"which", item}).waitFor() != 0) continue;
                        browser = item;
                        break;
                    }
                    catch (IOException ex) {
                        // empty catch block
                    }
                }
                if (browser != null) {
                    Runtime.getRuntime().exec(new String[]{browser, url});
                    flag = true;
                }
            }
        }
        catch (Exception ex) {
            flag = false;
        }
        return flag;
    }
}

