/*
 * Decompiled with CFR 0.152.
 */
package net.java.balloontip.positioners;

import java.awt.Point;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import net.java.balloontip.BalloonTip;
import net.java.balloontip.positioners.BalloonTipPositioner;
import net.java.balloontip.styles.BalloonTipStyle;

public abstract class BasicBalloonTipPositioner
extends BalloonTipPositioner {
    protected int x = 0;
    protected int y = 0;
    protected int hOffset = 0;
    protected boolean flipX = false;
    protected boolean flipY = false;
    protected int preferredHorizontalOffset;
    protected int preferredVerticalOffset;
    protected int minimumHorizontalOffset;
    protected boolean offsetCorrection = true;
    protected boolean orientationCorrection = true;
    protected boolean fixedAttachLocation = false;
    protected float attachLocationX = 0.0f;
    protected float attachLocationY = 0.0f;

    public BasicBalloonTipPositioner(int hO, int vO) {
        this.preferredHorizontalOffset = hO;
        this.preferredVerticalOffset = vO;
    }

    public void setBalloonTip(BalloonTip balloonTip) {
        this.balloonTip = balloonTip;
        balloonTip.getStyle().setHorizontalOffset(this.preferredHorizontalOffset);
        balloonTip.getStyle().setVerticalOffset(this.preferredVerticalOffset);
        this.minimumHorizontalOffset = balloonTip.getStyle().getMinimalHorizontalOffset();
        balloonTip.addPropertyChangeListener("style", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                BalloonTipStyle style = (BalloonTipStyle)evt.getNewValue();
                style.setHorizontalOffset(BasicBalloonTipPositioner.this.preferredHorizontalOffset);
                style.setVerticalOffset(BasicBalloonTipPositioner.this.preferredVerticalOffset);
                BasicBalloonTipPositioner.this.minimumHorizontalOffset = style.getMinimalHorizontalOffset();
            }
        });
    }

    public int getPreferredHorizontalOffset() {
        return this.preferredHorizontalOffset;
    }

    public void setPreferredHorizontalOffset(int preferredHorizontalOffset) {
        this.preferredHorizontalOffset = preferredHorizontalOffset;
        this.balloonTip.getStyle().setHorizontalOffset(preferredHorizontalOffset);
        this.balloonTip.repaint();
    }

    public int getPreferredVerticalOffset() {
        return this.preferredVerticalOffset;
    }

    public void setPreferredVerticalOffset(int preferredVerticalOffset) {
        this.preferredVerticalOffset = preferredVerticalOffset;
        this.minimumHorizontalOffset = 2 * preferredVerticalOffset;
        this.balloonTip.getStyle().setVerticalOffset(preferredVerticalOffset);
    }

    public boolean isOffsetCorrected() {
        return this.offsetCorrection;
    }

    public void enableOffsetCorrection(boolean offsetCorrection) {
        this.offsetCorrection = offsetCorrection;
    }

    public boolean isOrientationCorrected() {
        return this.orientationCorrection;
    }

    public void enableOrientationCorrection(boolean orientationCorrection) {
        this.orientationCorrection = orientationCorrection;
    }

    public boolean isFixedAttachLocation() {
        return this.fixedAttachLocation;
    }

    public void enableFixedAttachLocation(boolean fixedAttachLocation) {
        this.fixedAttachLocation = fixedAttachLocation;
    }

    public float getAttachLocationX() {
        return this.attachLocationX;
    }

    public float getAttachLocationY() {
        return this.attachLocationY;
    }

    public void setAttachLocation(float attachLocationX, float attachLocationY) {
        this.attachLocationX = attachLocationX;
        this.attachLocationY = attachLocationY;
    }

    public Point getTipLocation() {
        int tipX = this.x + this.hOffset;
        int tipY = this.y + this.balloonTip.getHeight();
        if (this.flipX) {
            tipX = this.x + this.hOffset;
        }
        if (this.flipY) {
            tipY = this.y;
        }
        return new Point(tipX, tipY);
    }

    protected void applyOffsetCorrection() {
        int overflow = -this.x;
        int balloonWidth = this.balloonTip.getWidth();
        if (overflow > 0) {
            this.x += overflow;
            this.hOffset -= overflow;
            if (this.hOffset < this.minimumHorizontalOffset) {
                this.hOffset = this.minimumHorizontalOffset;
                this.x = this.flipX ? (this.x += -overflow + (balloonWidth - this.preferredHorizontalOffset) - this.minimumHorizontalOffset) : (this.x += -overflow + this.preferredHorizontalOffset - this.minimumHorizontalOffset);
            }
        }
        if ((overflow = this.x + balloonWidth - this.balloonTip.getTopLevelContainer().getWidth()) > 0) {
            this.x -= overflow;
            this.hOffset += overflow;
            if (this.hOffset > balloonWidth - this.minimumHorizontalOffset) {
                this.hOffset = balloonWidth - this.minimumHorizontalOffset;
                this.x = this.flipX ? (this.x += overflow + this.preferredHorizontalOffset + this.minimumHorizontalOffset) : (this.x += overflow - (balloonWidth - this.preferredHorizontalOffset) + this.minimumHorizontalOffset);
            }
        }
    }
}

