/*
 * Decompiled with CFR 0.152.
 */
package com.ehsunbehravesh.mypasswords;

public class PasswordAnalyser {
    private int points;
    private String password;

    public PasswordAnalyser(String password) {
        this.password = password;
        this.points = -1;
    }

    public int getPoints() {
        if (this.points == -1) {
            this.calculatePoints();
        }
        return this.points;
    }

    private void calculatePoints() {
        int differentChars;
        int pointsOfLength = 0;
        int pointsOfDifferentChars = 0;
        if (this.password.length() > 4) {
            pointsOfLength = 1;
        }
        if (this.password.length() > 6) {
            pointsOfLength = 2;
        }
        if (this.password.length() > 8) {
            pointsOfLength = 4;
        }
        if (this.password.length() > 10) {
            pointsOfLength = 5;
        }
        if ((differentChars = this.calcDifferentChars(this.password)) > 1) {
            pointsOfDifferentChars = 1;
        }
        if (differentChars > 2) {
            pointsOfDifferentChars = 4;
        }
        if (differentChars > 3) {
            pointsOfDifferentChars = 6;
        }
        this.points = pointsOfLength + pointsOfDifferentChars;
    }

    private int calcDifferentChars(String password) {
        String alphabets = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ".substring(0, "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ".length() / 2);
        String capitalAlphabets = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ".substring("abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ".length() / 2);
        int hasAlphabets = this.anyExists(password, alphabets);
        int hasCapitalAlphabets = this.anyExists(password, capitalAlphabets);
        int hasNumbers = this.anyExists(password, "1234567890");
        int hasSymbols = this.anyExists(password, "-=_+)(*&^%$#@!<>/\\}{[]?.,");
        return hasAlphabets + hasCapitalAlphabets + hasNumbers + hasSymbols;
    }

    private int anyExists(String text, String chars) {
        for (int i = 0; i < text.length(); ++i) {
            if (chars.indexOf(text.charAt(i)) < 0) continue;
            return 1;
        }
        return 0;
    }
}

