/*
 * Decompiled with CFR 0.152.
 */
package com.ehsunbehravesh.mypasswords.gui;

import com.ehsunbehravesh.mypasswords.PasswordGenerator;
import com.ehsunbehravesh.mypasswords.Utils;
import com.ehsunbehravesh.mypasswords.resource.ResourceLoader;
import java.awt.Color;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Point;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.URL;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;

public class PasswordGeneratorDialog
extends JDialog
implements ClipboardOwner {
    private JButton btnCopy;
    private JButton btnGenerate;
    private JComboBox cmbType;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JPanel jPanel1;
    private JTextField txtLength;
    private JTextField txtPassword;
    private JPopupMenu mnuMain;
    private JMenuItem mniCopy;

    public PasswordGeneratorDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.myInitComponents();
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.txtLength = new JTextField();
        this.jLabel3 = new JLabel();
        this.cmbType = new JComboBox();
        this.btnGenerate = new JButton();
        this.txtPassword = new JTextField();
        this.btnCopy = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle("Password Generator");
        this.setResizable(false);
        this.jPanel1.setBackground(new Color(255, 255, 255));
        this.jLabel1.setFont(new Font("Tahoma", 0, 14));
        this.jLabel1.setText("Password Generator");
        this.jLabel2.setText("Length:");
        this.txtLength.setText("8");
        this.txtLength.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                PasswordGeneratorDialog.this.txtLengthKeyPressed(evt);
            }
        });
        this.jLabel3.setText("Characters:");
        this.cmbType.setModel(new DefaultComboBoxModel<String>(new String[]{"Alphabets", "Numbers", "Alphabets & Numbers", "Alphabets & Numbers & Symbols"}));
        this.cmbType.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                PasswordGeneratorDialog.this.cmbTypeKeyPressed(evt);
            }
        });
        this.btnGenerate.setFont(new Font("DejaVu Sans", 1, 13));
        this.btnGenerate.setText("Generate");
        this.btnGenerate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PasswordGeneratorDialog.this.btnGenerateActionPerformed(evt);
            }
        });
        this.btnGenerate.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                PasswordGeneratorDialog.this.btnGenerateKeyPressed(evt);
            }
        });
        this.txtPassword.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                PasswordGeneratorDialog.this.txtPasswordMouseClicked(evt);
            }
        });
        this.txtPassword.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent evt) {
                PasswordGeneratorDialog.this.txtPasswordKeyPressed(evt);
            }
        });
        this.btnCopy.setText("Copy");
        this.btnCopy.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PasswordGeneratorDialog.this.btnCopyActionPerformed(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGap(32, 32, 32).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jLabel1).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel2).addComponent(this.jLabel3)).addGap(54, 54, 54).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.cmbType, 0, -1, Short.MAX_VALUE).addComponent(this.txtLength).addComponent(this.btnGenerate, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE))).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.txtPassword, -2, 320, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnCopy, -1, -1, Short.MAX_VALUE))).addContainerGap(29, Short.MAX_VALUE)));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGap(21, 21, 21).addComponent(this.jLabel1).addGap(26, 26, 26).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabel2).addComponent(this.txtLength, -2, -1, -2)).addGap(18, 18, 18).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabel3).addComponent(this.cmbType, -2, -1, -2)).addGap(18, 18, 18).addComponent(this.btnGenerate).addGap(18, 18, 18).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.txtPassword, -2, -1, -2).addComponent(this.btnCopy)).addContainerGap(36, Short.MAX_VALUE)));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE));
        this.pack();
    }

    private void btnGenerateActionPerformed(ActionEvent evt) {
        this.generatePassword();
    }

    private void txtPasswordMouseClicked(MouseEvent evt) {
        if (SwingUtilities.isRightMouseButton(evt)) {
            Point point = evt.getPoint();
            this.mnuMain.show(this.txtPassword, point.x, point.y);
        }
    }

    private void txtLengthKeyPressed(KeyEvent evt) {
        this.txtLengthKeyPress(evt);
    }

    private void cmbTypeKeyPressed(KeyEvent evt) {
        this.cmbTypeKeyPress(evt);
    }

    private void btnGenerateKeyPressed(KeyEvent evt) {
        this.btnGenerateKeyPress(evt);
    }

    private void txtPasswordKeyPressed(KeyEvent evt) {
        this.txtPasswordKeyPress(evt);
    }

    private void btnCopyActionPerformed(ActionEvent evt) {
        this.btnCopyActionPerform(evt);
    }

    private void myInitComponents() {
        URL url = ResourceLoader.class.getResource("safe.png");
        ImageIcon safeIcon = new ImageIcon(url);
        this.setIconImage(safeIcon.getImage());
        this.mnuMain = new JPopupMenu();
        url = ResourceLoader.class.getResource("copy.png");
        this.mniCopy = new JMenuItem("Copy Password", new ImageIcon(url));
        this.mnuMain.add(this.mniCopy);
        ActionListener menuActionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (e.getSource() == PasswordGeneratorDialog.this.mniCopy) {
                    PasswordGeneratorDialog.this.mniCopyActionPerformed(e);
                }
            }
        };
        this.mniCopy.addActionListener(menuActionListener);
        this.txtLength.requestFocus();
    }

    private void mniCopyActionPerformed(ActionEvent e) {
        Utils.setClipboardContents(this.txtPassword.getText(), this);
    }

    private void generatePassword() {
        int length;
        try {
            length = Integer.parseInt(this.txtLength.getText());
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this, "Invalid length!", "Warning", 2);
            this.txtLength.selectAll();
            this.txtLength.requestFocus();
            return;
        }
        PasswordGenerator passwordGenerator = new PasswordGenerator(length, this.cmbType.getSelectedIndex() + 1);
        this.txtPassword.setText(passwordGenerator.generatePassword());
    }

    @Override
    public void lostOwnership(Clipboard clipboard, Transferable contents) {
    }

    private void txtLengthKeyPress(KeyEvent evt) {
        int key = evt.getKeyCode();
        if (key == 27) {
            this.closeDialog();
        }
    }

    private void closeDialog() {
        this.setVisible(false);
    }

    private void cmbTypeKeyPress(KeyEvent evt) {
        int key = evt.getKeyCode();
        if (key == 27) {
            this.closeDialog();
        }
    }

    private void btnGenerateKeyPress(KeyEvent evt) {
        int key = evt.getKeyCode();
        if (key == 27) {
            this.closeDialog();
        }
    }

    private void txtPasswordKeyPress(KeyEvent evt) {
        int key = evt.getKeyCode();
        if (key == 27) {
            this.closeDialog();
        }
    }

    private void btnCopyActionPerform(ActionEvent evt) {
        Utils.setClipboardContents(this.txtPassword.getText(), this);
    }
}

