/*
 * Decompiled with CFR 0.152.
 */
package de.saring.polarpersonaltrainer.importer;

import de.saring.exerciseviewer.core.EVException;
import de.saring.exerciseviewer.data.EVExercise;
import de.saring.exerciseviewer.parser.impl.PolarPedParser;
import de.saring.sportstracker.core.STException;
import de.saring.sportstracker.data.Exercise;
import de.saring.sportstracker.data.ExerciseList;
import de.saring.sportstracker.data.SportType;
import de.saring.sportstracker.data.SportTypeList;
import de.saring.sportstracker.storage.IStorage;
import de.saring.sportstracker.storage.XMLStorage;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

public class PedImporter {
    private static final String FILENAME_EXERCISE_LIST = "exercises.xml";
    private static final String FILENAME_SPORT_TYPE_LIST = "sport-types.xml";
    private static String dataDirectory;
    private static boolean dryRun;
    private ExerciseList exerciseList;
    private SportTypeList sportTypeList;
    IStorage storage;
    private int addedExercises = 0;

    static {
        dryRun = false;
    }

    private static void printUsage(Options options) {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp("PedImporter", options);
    }

    public static void main(String[] args) {
        Options options = new Options();
        OptionBuilder.withLongOpt("filename");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired();
        OptionBuilder.withDescription("Input file exported from polarpersonaltrainer.com");
        options.addOption(OptionBuilder.create("f"));
        OptionBuilder.withLongOpt("datadir");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription("Directory where the SportsTracker data are stored, default $HOME/.sportstracker");
        options.addOption(OptionBuilder.create("d"));
        OptionBuilder.withLongOpt("sportType");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription("sport-type id from <datadir>/sport-types.xml, default 1");
        options.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt("sportSubType");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription("sport-subtype id from <datadir>/sport-types.xml, default 1");
        options.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt("dry-run");
        OptionBuilder.withDescription("if this parameter is set, no data is written to disk");
        options.addOption(OptionBuilder.create("n"));
        GnuParser parser = new GnuParser();
        String filename = null;
        int sportTypeId = 1;
        int sportSubTypeId = 1;
        try {
            CommandLine line = parser.parse(options, args);
            filename = line.getOptionValue("f");
            if (line.hasOption("sportType")) {
                String sportType = line.getOptionValue("sportType");
                sportTypeId = Integer.parseInt(sportType);
            }
            if (line.hasOption("sportSubType")) {
                String sportSubType = line.getOptionValue("sportSubType");
                sportSubTypeId = Integer.parseInt(sportSubType);
            }
            dataDirectory = line.hasOption("datadir") ? line.getOptionValue("datadir") : String.valueOf(System.getProperty("user.home")) + "/.sportstracker";
            if (line.hasOption("n")) {
                dryRun = true;
            }
        }
        catch (ParseException exp) {
            System.out.println("Usage error: " + exp.getMessage());
            PedImporter.printUsage(options);
            return;
        }
        if (filename == null) {
            PedImporter.printUsage(options);
        }
        PedImporter app = new PedImporter();
        try {
            app.initApplication(filename, sportTypeId, sportSubTypeId);
        }
        catch (STException ex) {
            System.out.println(ex.getMessage());
            ex.printStackTrace();
        }
        catch (EVException ex) {
            System.out.println(ex.getMessage());
            ex.printStackTrace();
        }
    }

    private void initApplication(String filename, int sportTypeId, int sportSubTypeId) throws STException, EVException {
        Boolean modified = false;
        this.storage = new XMLStorage();
        String exerciseFilename = String.valueOf(dataDirectory) + "/" + FILENAME_EXERCISE_LIST;
        this.sportTypeList = this.storage.readSportTypeList(String.valueOf(dataDirectory) + "/" + FILENAME_SPORT_TYPE_LIST);
        this.exerciseList = this.storage.readExerciseList(exerciseFilename, this.sportTypeList);
        try {
            this.checkSuppliedSportType(sportTypeId, sportSubTypeId);
        }
        catch (EVException ex) {
            System.out.println(ex.getMessage());
            return;
        }
        PolarPedParser parser = new PolarPedParser();
        parser.parseExercise(filename);
        int exerciseCount = parser.getExerciseCount();
        int exerciseIndex = 0;
        while (exerciseIndex < exerciseCount) {
            block6: {
                try {
                    EVExercise pedExercise = parser.parseExercise(filename, exerciseIndex);
                    Boolean found = false;
                    for (Exercise exercise : this.exerciseList) {
                        if (!pedExercise.getDate().equals(exercise.getDate())) continue;
                        found = true;
                        break;
                    }
                    if (found.booleanValue()) break block6;
                    Exercise newExercise = new Exercise(this.exerciseList.getNewID());
                    newExercise.setDate(pedExercise.getDate());
                    newExercise.setAvgSpeed(pedExercise.getSpeed().getSpeedAVG());
                    newExercise.setIntensity(Exercise.IntensityType.NORMAL);
                    newExercise.setAvgHeartRate(pedExercise.getHeartRateAVG());
                    newExercise.setCalories(pedExercise.getEnergy());
                    newExercise.setDistance((float)pedExercise.getSpeed().getDistance() / 1000.0f);
                    newExercise.setDuration(pedExercise.getDuration() / 10);
                    newExercise.setSportType((SportType)this.sportTypeList.getByID(sportTypeId));
                    newExercise.setSportSubType(((SportType)this.sportTypeList.getByID(sportTypeId)).getSportSubTypeList().getByID(sportSubTypeId));
                    this.exerciseList.set(newExercise);
                    modified = true;
                    ++this.addedExercises;
                }
                catch (EVException eVException) {
                    break;
                }
            }
            ++exerciseIndex;
        }
        this.storeExerciseList(this.exerciseList, exerciseFilename, modified);
    }

    private void storeExerciseList(ExerciseList exerciseList, String filename, Boolean modified) throws STException {
        if (dryRun) {
            System.out.println("Dry run, nothing written to disk");
        } else if (modified.booleanValue()) {
            this.storage.storeExerciseList(exerciseList, filename);
        }
        if (this.addedExercises > 0) {
            System.out.println("added " + this.addedExercises + " exercise(s)");
        } else {
            System.out.println("no new exercise found in input file");
        }
    }

    private void checkSuppliedSportType(int sportTypeId, int sportSubTypeId) throws EVException {
        if (this.sportTypeList.getByID(sportTypeId) == null) {
            throw new EVException("sport-type id " + sportTypeId + " not found in " + dataDirectory + "/sport-types.xml");
        }
        if (((SportType)this.sportTypeList.getByID(sportTypeId)).getSportSubTypeList().getByID(sportSubTypeId) == null) {
            throw new EVException("sport-subtype id " + sportSubTypeId + " not found in  " + dataDirectory + "/sport-types.xml");
        }
    }
}

