/*
 * Decompiled with CFR 0.152.
 */
package de.saring.sportstracker.data;

import de.saring.sportstracker.data.Equipment;
import de.saring.sportstracker.data.Exercise;
import de.saring.sportstracker.data.SportSubType;
import de.saring.sportstracker.data.SportType;
import de.saring.sportstracker.data.SportTypeList;
import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;

public final class ExerciseFilter
implements Serializable {
    private Date dateStart;
    private Date dateEnd;
    private SportType sportType = null;
    private SportSubType sportSubType = null;
    private Exercise.IntensityType intensity;
    private Equipment equipment = null;
    private String commentSubString = null;
    private boolean regularExpressionMode = false;

    public Date getDateStart() {
        return this.dateStart;
    }

    public void setDateStart(Date dateStart) {
        this.dateStart = dateStart;
    }

    public Date getDateEnd() {
        return this.dateEnd;
    }

    public void setDateEnd(Date dateEnd) {
        this.dateEnd = dateEnd;
    }

    public SportType getSportType() {
        return this.sportType;
    }

    public void setSportType(SportType sportType) {
        this.sportType = sportType;
    }

    public SportSubType getSportSubType() {
        return this.sportSubType;
    }

    public void setSportSubType(SportSubType sportSubType) {
        this.sportSubType = sportSubType;
    }

    public Exercise.IntensityType getIntensity() {
        return this.intensity;
    }

    public void setIntensity(Exercise.IntensityType intensity) {
        this.intensity = intensity;
    }

    public Equipment getEquipment() {
        return this.equipment;
    }

    public void setEquipment(Equipment equipment) {
        this.equipment = equipment;
    }

    public boolean isRegularExpressionMode() {
        return this.regularExpressionMode;
    }

    public void setRegularExpressionMode(boolean regularExpressionMode) {
        this.regularExpressionMode = regularExpressionMode;
    }

    public String getCommentSubString() {
        return this.commentSubString;
    }

    public void setCommentSubString(String commentSubString) {
        this.commentSubString = commentSubString;
    }

    public static ExerciseFilter createDefaultExerciseFilter() {
        Calendar cStart = Calendar.getInstance();
        Calendar cEnd = Calendar.getInstance();
        Calendar cNow = Calendar.getInstance();
        cStart.clear();
        cEnd.clear();
        cStart.set(cNow.get(1), cNow.get(2), 1, 0, 0, 0);
        cEnd.set(cNow.get(1), cNow.get(2), cNow.getActualMaximum(5), 23, 59, 59);
        ExerciseFilter filter = new ExerciseFilter();
        filter.dateStart = cStart.getTime();
        filter.dateEnd = cEnd.getTime();
        filter.sportType = null;
        filter.sportSubType = null;
        filter.intensity = null;
        filter.equipment = null;
        filter.commentSubString = "";
        filter.regularExpressionMode = false;
        return filter;
    }

    public void updateSportTypes(SportTypeList sportTypeList) {
        if (this.sportType != null) {
            this.sportType = (SportType)sportTypeList.getByID(this.sportType.getId());
            if (this.sportType != null) {
                if (this.sportSubType != null) {
                    this.sportSubType = this.sportType.getSportSubTypeList().getByID(this.sportSubType.getId());
                }
                if (this.equipment != null) {
                    this.equipment = this.sportType.getEquipmentList().getByID(this.equipment.getId());
                }
            } else {
                this.sportSubType = null;
                this.equipment = null;
            }
        }
    }

    public String toString() {
        StringBuilder sBuilder = new StringBuilder();
        sBuilder.append(String.valueOf(ExerciseFilter.class.getName()) + ":\n");
        sBuilder.append(" [dateStart=" + this.dateStart + "\n");
        sBuilder.append("  dateEnd=" + this.dateEnd + "\n");
        sBuilder.append("  sportType=" + this.sportType + "\n");
        sBuilder.append("  sportSubType=" + this.sportSubType + "\n");
        sBuilder.append("  intensity=" + (Object)((Object)this.intensity) + "\n");
        sBuilder.append("  equipment=" + this.equipment + "\n");
        sBuilder.append("  commentSubString=" + this.commentSubString + "\n");
        sBuilder.append("  regularExpressionMode=" + this.regularExpressionMode + "]\n");
        return sBuilder.toString();
    }
}

