/*
 * Decompiled with CFR 0.152.
 */
package de.saring.sportstracker.data.statistic;

import de.saring.sportstracker.data.Exercise;
import de.saring.util.data.IdObjectList;

public class StatisticCalculator {
    private int exerciseCount = 0;
    private double totalDistance = 0.0;
    private int totalDuration = 0;
    private int totalAscent = 0;
    private int totalCalories = 0;
    private float avgDistance = 0.0f;
    private float avgSpeed = 0.0f;
    private int avgDuration = 0;
    private int avgAscent = 0;
    private int avgHeartRate = 0;
    private int avgCalories = 0;
    private float minDistance = 0.0f;
    private float minAvgSpeed = 0.0f;
    private int minDuration = 0;
    private int minAscent = 0;
    private int minAvgHeartRate = 0;
    private int minCalories = 0;
    private float maxDistance = 0.0f;
    private float maxAvgSpeed = 0.0f;
    private int maxDuration = 0;
    private int maxAscent = 0;
    private int maxAvgHeartRate = 0;
    private int maxCalories = 0;

    public StatisticCalculator(IdObjectList<Exercise> exercises) {
        this.exerciseCount = exercises.size();
        if (this.exerciseCount == 0) {
            return;
        }
        double totalAvgSpeed = 0.0;
        long totalHeartRate = 0L;
        int numberOfExerciseWithDistance = 0;
        int numberOfExercisesWithHeartRate = 0;
        int numberOfExercisesWithCalories = 0;
        Exercise firstExercise = exercises.getAt(0);
        this.minDistance = firstExercise.getDistance();
        this.minAvgSpeed = firstExercise.getAvgSpeed();
        this.minDuration = firstExercise.getDuration();
        this.minAscent = firstExercise.getAscent();
        this.minAvgHeartRate = firstExercise.getAvgHeartRate();
        for (Exercise currExercise : exercises) {
            boolean fDistanceRecorded;
            boolean bl = fDistanceRecorded = currExercise.getDistance() > 0.0f && currExercise.getAvgSpeed() > 0.0f;
            if (fDistanceRecorded) {
                ++numberOfExerciseWithDistance;
            }
            this.totalDistance += (double)currExercise.getDistance();
            totalAvgSpeed += (double)currExercise.getAvgSpeed();
            this.totalDuration += currExercise.getDuration();
            this.totalAscent += currExercise.getAscent();
            if (currExercise.getAvgHeartRate() > 0) {
                totalHeartRate += (long)currExercise.getAvgHeartRate();
                ++numberOfExercisesWithHeartRate;
            }
            if (currExercise.getCalories() > 0) {
                this.totalCalories += currExercise.getCalories();
                ++numberOfExercisesWithCalories;
            }
            if (currExercise.getDistance() < this.minDistance) {
                this.minDistance = currExercise.getDistance();
            }
            if (currExercise.getAvgSpeed() < this.minAvgSpeed) {
                this.minAvgSpeed = currExercise.getAvgSpeed();
            }
            if (currExercise.getDuration() < this.minDuration) {
                this.minDuration = currExercise.getDuration();
            }
            if (currExercise.getAscent() < this.minAscent) {
                this.minAscent = currExercise.getAscent();
            }
            if (this.minAvgHeartRate <= 0 || currExercise.getAvgHeartRate() > 0 && currExercise.getAvgHeartRate() < this.minAvgHeartRate) {
                this.minAvgHeartRate = currExercise.getAvgHeartRate();
            }
            if (this.minCalories <= 0 || currExercise.getCalories() > 0 && currExercise.getCalories() < this.minCalories) {
                this.minCalories = currExercise.getCalories();
            }
            if (currExercise.getDistance() > this.maxDistance) {
                this.maxDistance = currExercise.getDistance();
            }
            if (currExercise.getAvgSpeed() > this.maxAvgSpeed) {
                this.maxAvgSpeed = currExercise.getAvgSpeed();
            }
            if (currExercise.getDuration() > this.maxDuration) {
                this.maxDuration = currExercise.getDuration();
            }
            if (currExercise.getAscent() > this.maxAscent) {
                this.maxAscent = currExercise.getAscent();
            }
            if (currExercise.getAvgHeartRate() > this.maxAvgHeartRate) {
                this.maxAvgHeartRate = currExercise.getAvgHeartRate();
            }
            if (currExercise.getCalories() <= this.maxCalories) continue;
            this.maxCalories = currExercise.getCalories();
        }
        if (numberOfExerciseWithDistance > 0) {
            this.avgDistance = (float)(this.totalDistance / (double)numberOfExerciseWithDistance);
            this.avgSpeed = (float)(totalAvgSpeed / (double)numberOfExerciseWithDistance);
        } else {
            this.avgDistance = 0.0f;
            this.avgSpeed = 0.0f;
        }
        this.avgDuration = this.totalDuration / this.exerciseCount;
        this.avgAscent = this.totalAscent / this.exerciseCount;
        if (numberOfExercisesWithHeartRate > 0) {
            this.avgHeartRate = (int)(totalHeartRate / (long)numberOfExercisesWithHeartRate);
        }
        if (numberOfExercisesWithCalories > 0) {
            this.avgCalories = this.totalCalories / numberOfExercisesWithCalories;
        }
    }

    public int getAvgAscent() {
        return this.avgAscent;
    }

    public void setAvgAscent(int avgAscent) {
        this.avgAscent = avgAscent;
    }

    public int getAvgCalories() {
        return this.avgCalories;
    }

    public void setAvgCalories(int avgCalories) {
        this.avgCalories = avgCalories;
    }

    public float getAvgDistance() {
        return this.avgDistance;
    }

    public void setAvgDistance(float avgDistance) {
        this.avgDistance = avgDistance;
    }

    public int getAvgDuration() {
        return this.avgDuration;
    }

    public void setAvgDuration(int avgDuration) {
        this.avgDuration = avgDuration;
    }

    public int getAvgHeartRate() {
        return this.avgHeartRate;
    }

    public void setAvgHeartRate(int avgHeartRate) {
        this.avgHeartRate = avgHeartRate;
    }

    public float getAvgSpeed() {
        return this.avgSpeed;
    }

    public void setAvgSpeed(float avgSpeed) {
        this.avgSpeed = avgSpeed;
    }

    public int getExerciseCount() {
        return this.exerciseCount;
    }

    public void setExerciseCount(int exerciseCount) {
        this.exerciseCount = exerciseCount;
    }

    public int getMaxAscent() {
        return this.maxAscent;
    }

    public void setMaxAscent(int maxAscent) {
        this.maxAscent = maxAscent;
    }

    public int getMaxAvgHeartRate() {
        return this.maxAvgHeartRate;
    }

    public void setMaxAvgHeartRate(int maxAvgHeartRate) {
        this.maxAvgHeartRate = maxAvgHeartRate;
    }

    public float getMaxAvgSpeed() {
        return this.maxAvgSpeed;
    }

    public void setMaxAvgSpeed(float maxAvgSpeed) {
        this.maxAvgSpeed = maxAvgSpeed;
    }

    public int getMaxCalories() {
        return this.maxCalories;
    }

    public void setMaxCalories(int maxCalories) {
        this.maxCalories = maxCalories;
    }

    public float getMaxDistance() {
        return this.maxDistance;
    }

    public void setMaxDistance(float maxDistance) {
        this.maxDistance = maxDistance;
    }

    public int getMaxDuration() {
        return this.maxDuration;
    }

    public void setMaxDuration(int maxDuration) {
        this.maxDuration = maxDuration;
    }

    public int getMinAscent() {
        return this.minAscent;
    }

    public void setMinAscent(int minAscent) {
        this.minAscent = minAscent;
    }

    public int getMinAvgHeartRate() {
        return this.minAvgHeartRate;
    }

    public void setMinAvgHeartRate(int minAvgHeartRate) {
        this.minAvgHeartRate = minAvgHeartRate;
    }

    public float getMinAvgSpeed() {
        return this.minAvgSpeed;
    }

    public void setMinAvgSpeed(float minAvgSpeed) {
        this.minAvgSpeed = minAvgSpeed;
    }

    public int getMinCalories() {
        return this.minCalories;
    }

    public void setMinCalories(int minCalories) {
        this.minCalories = minCalories;
    }

    public float getMinDistance() {
        return this.minDistance;
    }

    public void setMinDistance(float minDistance) {
        this.minDistance = minDistance;
    }

    public int getMinDuration() {
        return this.minDuration;
    }

    public void setMinDuration(int minDuration) {
        this.minDuration = minDuration;
    }

    public int getTotalAscent() {
        return this.totalAscent;
    }

    public void setTotalAscent(int totalAscent) {
        this.totalAscent = totalAscent;
    }

    public int getTotalCalories() {
        return this.totalCalories;
    }

    public void setTotalCalories(int totalCalories) {
        this.totalCalories = totalCalories;
    }

    public double getTotalDistance() {
        return this.totalDistance;
    }

    public void setTotalDistance(double totalDistance) {
        this.totalDistance = totalDistance;
    }

    public int getTotalDuration() {
        return this.totalDuration;
    }

    public void setTotalDuration(int totalDuration) {
        this.totalDuration = totalDuration;
    }
}

