/*
 * Decompiled with CFR 0.152.
 */
package de.saring.sportstracker.gui;

import de.saring.sportstracker.core.STOptions;
import de.saring.sportstracker.data.Exercise;
import de.saring.sportstracker.gui.STContext;
import de.saring.sportstracker.gui.STController;
import de.saring.sportstracker.gui.STDocument;
import de.saring.sportstracker.gui.STView;
import de.saring.sportstracker.gui.views.BaseView;
import de.saring.sportstracker.gui.views.EntryView;
import de.saring.sportstracker.gui.views.calendarview.CalendarView;
import de.saring.sportstracker.gui.views.listview.ExerciseListView;
import de.saring.sportstracker.gui.views.listview.NoteListView;
import de.saring.sportstracker.gui.views.listview.WeightListView;
import de.saring.util.data.IdDateObjectList;
import de.saring.util.gui.mac.MacSpecials;
import de.saring.util.unitcalc.CalculationUtils;
import de.saring.util.unitcalc.FormatUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Toolkit;
import java.util.Arrays;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.border.EmptyBorder;
import org.jdesktop.application.FrameView;

@Singleton
public class STViewImpl
extends FrameView
implements STView {
    private static final String SEPARATOR = "---";
    private STContext context;
    private STDocument document;
    private STController controller;
    private BaseView currentView;
    private CalendarView calendarView;
    private ExerciseListView exerciseListView;
    private NoteListView noteListView;
    private WeightListView weightListView;
    private IdDateObjectList<Exercise> displayedExercises = new IdDateObjectList();
    private JLabel laStatusBar;

    @Inject
    public STViewImpl(STContext context, STDocument document, STController controller, CalendarView calendarView, ExerciseListView exerciseListView, NoteListView noteListView, WeightListView weightListView) {
        super(context.getSAFContext().getApplication());
        this.context = context;
        this.document = document;
        this.controller = controller;
        this.calendarView = calendarView;
        this.exerciseListView = exerciseListView;
        this.noteListView = noteListView;
        this.weightListView = weightListView;
    }

    public static void preInit() {
        if (MacSpecials.isMacOSX()) {
            MacSpecials.setApplicationMenuName("SportsTracker");
        }
    }

    @Override
    public void initView() {
        this.createView();
        STOptions options = this.document.getOptions();
        this.context.setFormatUtils(new FormatUtils(options.getUnitSystem(), options.getSpeedView()));
        this.calendarView.initView();
        this.exerciseListView.initView();
        this.noteListView.initView();
        this.weightListView.initView();
        if (options.getInitialView() == STOptions.View.Calendar) {
            this.switchToView(EntryView.ViewType.CALENDAR);
        } else {
            this.switchToView(EntryView.ViewType.EXERCISE_LIST);
        }
    }

    private void createView() {
        this.initMacUI();
        this.setMenuBar(this.createMenuBar());
        this.setToolBar(new JToolBar());
        this.createToolBarButtons(new String[]{"st.view.open_exerciseviewer", "st.view.save", "st.view.print", SEPARATOR, "st.view.calendar_view", "st.view.exercise_list_view", "st.view.note_list_view", "st.view.weight_list_view", SEPARATOR, "st.view.filter_exercises", "st.view.filter_disable", SEPARATOR, "st.view.exercise_add", "st.view.note_add", "st.view.weight_add", "st.view.entry_delete", "st.view.entry_edit", "st.view.view_hrm", SEPARATOR, "st.view.sporttype_editor", "st.view.statistics", "st.view.overview_diagram"});
        JPanel statusPanel = new JPanel(new BorderLayout());
        JSeparator statusPanelSeparator = new JSeparator();
        this.laStatusBar = new JLabel(" ");
        statusPanel.add((Component)statusPanelSeparator, "North");
        statusPanel.add((Component)this.laStatusBar, "West");
        statusPanel.setBorder(new EmptyBorder(2, 2, 2, 2));
        this.setStatusBar(statusPanel);
    }

    private JMenuBar createMenuBar() {
        JMenuBar menuBar = new JMenuBar();
        this.getFrame().setJMenuBar(menuBar);
        String[] fileMenuItems = new String[]{"st.view.open_exerciseviewer", "st.view.save", SEPARATOR, "st.view.print", SEPARATOR, "st.view.quit"};
        if (MacSpecials.isMacOSX()) {
            fileMenuItems = Arrays.copyOf(fileMenuItems, fileMenuItems.length - 2);
        }
        menuBar.add(this.createMenu("st.view.file", fileMenuItems));
        String[] editMenuItems = new String[]{"st.view.exercise_add", "st.view.note_add", "st.view.weight_add", "st.view.entry_delete", "st.view.entry_edit", SEPARATOR, "st.view.view_hrm", SEPARATOR, "st.view.preferences"};
        if (MacSpecials.isMacOSX()) {
            editMenuItems = Arrays.copyOf(editMenuItems, editMenuItems.length - 2);
        }
        menuBar.add(this.createMenu("st.view.edit", editMenuItems));
        menuBar.add(this.createMenu("st.view.view", new String[]{"st.view.calendar_view", "st.view.exercise_list_view", "st.view.note_list_view", "st.view.weight_list_view", SEPARATOR, "st.view.filter_exercises", "st.view.filter_disable"}));
        menuBar.add(this.createMenu("st.view.tools", new String[]{"st.view.sporttype_editor", "st.view.statistics", "st.view.overview_diagram"}));
        if (!MacSpecials.isMacOSX()) {
            menuBar.add(this.createMenu("st.view.help", new String[]{"st.view.about"}));
        }
        return menuBar;
    }

    private JMenu createMenu(String menuName, String[] actionNames) {
        int modifier = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
        JMenu menu = new JMenu();
        menu.setName(menuName);
        String[] stringArray = actionNames;
        int n = actionNames.length;
        int n2 = 0;
        while (n2 < n) {
            String actionName = stringArray[n2];
            if (actionName.equals(SEPARATOR)) {
                menu.addSeparator();
            } else {
                JMenuItem menuItem = new JMenuItem();
                menuItem.setAction(this.controller.getActionMap().get(actionName));
                KeyStroke keyStroke = menuItem.getAccelerator();
                if (keyStroke != null) {
                    menuItem.setAccelerator(KeyStroke.getKeyStroke(keyStroke.getKeyCode(), modifier));
                }
                menu.add(menuItem);
            }
            ++n2;
        }
        return menu;
    }

    private void createToolBarButtons(String[] actionNames) {
        String[] stringArray = actionNames;
        int n = actionNames.length;
        int n2 = 0;
        while (n2 < n) {
            String actionName = stringArray[n2];
            if (actionName.equals(SEPARATOR)) {
                this.getToolBar().addSeparator();
            } else {
                JButton button = new JButton(this.controller.getActionMap().get(actionName));
                button.setHideActionText(true);
                button.setMnemonic(-1);
                this.getToolBar().add(button);
            }
            ++n2;
        }
    }

    private void initMacUI() {
        if (MacSpecials.isMacOSX()) {
            MacSpecials.useScreenMenuBar(true);
            ImageIcon appIcon = new ImageIcon(this.getClass().getResource("/icons/st-logo.png"));
            MacSpecials.getInstance().setDockIcon(appIcon.getImage());
            Action aboutAction = this.controller.getActionMap().get("st.view.about");
            MacSpecials.getInstance().setAboutAction(aboutAction);
            Action prefsAction = this.controller.getActionMap().get("st.view.preferences");
            MacSpecials.getInstance().setPreferencesAction(prefsAction);
        }
    }

    @Override
    public void postInit() {
        this.calendarView.selectToday();
    }

    @Override
    public EntryView getCurrentView() {
        return this.currentView;
    }

    @Override
    public void updateView() {
        STOptions options = this.document.getOptions();
        this.context.setFormatUtils(new FormatUtils(options.getUnitSystem(), options.getSpeedView()));
        this.displayedExercises = this.document.getFilterableExerciseList();
        this.currentView.updateView();
        this.updateEntryActions();
    }

    @Override
    public IdDateObjectList<Exercise> getDisplayedExercises() {
        return this.displayedExercises;
    }

    @Override
    public void switchToView(EntryView.ViewType viewType) {
        switch (viewType) {
            case CALENDAR: {
                this.currentView = this.calendarView;
                break;
            }
            case EXERCISE_LIST: {
                this.currentView = this.exerciseListView;
                break;
            }
            case NOTE_LIST: {
                this.currentView = this.noteListView;
                break;
            }
            case WEIGHT_LIST: {
                this.currentView = this.weightListView;
            }
        }
        this.currentView.updateView();
        if (this.currentView.getSelectedExerciseCount() > 0) {
            this.currentView.removeSelection();
        }
        this.updateEntryActions();
        this.controller.getActionMap().get("st.view.calendar_view").setEnabled(this.currentView != this.calendarView);
        this.controller.getActionMap().get("st.view.exercise_list_view").setEnabled(this.currentView != this.exerciseListView);
        this.controller.getActionMap().get("st.view.note_list_view").setEnabled(this.currentView != this.noteListView);
        this.controller.getActionMap().get("st.view.weight_list_view").setEnabled(this.currentView != this.weightListView);
        this.setComponent(this.currentView);
        this.currentView.revalidate();
        this.currentView.repaint();
    }

    @Override
    public void updateEntryActions() {
        boolean fHRMEnabled;
        int selExerciseCount = this.currentView.getSelectedExerciseCount();
        int selNoteCount = this.currentView.getSelectedNoteCount();
        int selWeightCount = this.currentView.getSelectedWeightCount();
        boolean fDeleteEnabled = selExerciseCount > 0 || selNoteCount > 0 || selWeightCount > 0;
        boolean fEditEnabled = selExerciseCount == 1 || selNoteCount == 1 || selWeightCount == 1;
        boolean bl = fHRMEnabled = selExerciseCount == 1;
        if (fHRMEnabled) {
            int selExerciseID = this.currentView.getSelectedExerciseIDs()[0];
            Exercise selExercise = (Exercise)this.document.getExerciseList().getByID(selExerciseID);
            fHRMEnabled = selExercise.getHrmFile() != null && selExercise.getHrmFile().trim().length() > 0;
        }
        this.controller.getActionMap().get("st.view.entry_delete").setEnabled(fDeleteEnabled);
        this.controller.getActionMap().get("st.view.entry_edit").setEnabled(fEditEnabled);
        this.controller.getActionMap().get("st.view.view_hrm").setEnabled(fHRMEnabled);
        boolean filterableView = this.currentView == this.calendarView || this.currentView == this.exerciseListView;
        this.controller.getActionMap().get("st.view.filter_exercises").setEnabled(filterableView);
        this.controller.getActionMap().get("st.view.filter_disable").setEnabled(filterableView && this.document.isFilterEnabled());
        this.updateStatusBar();
        this.updateSaveAction();
    }

    @Override
    public void updateSaveAction() {
        this.controller.getActionMap().get("st.view.save").setEnabled(this.document.isDirtyData());
    }

    private void updateStatusBar() {
        String statusText = " ";
        int[] selExerciseIDs = this.currentView.getSelectedExerciseIDs();
        if (selExerciseIDs.length > 0) {
            float sumDistance = 0.0f;
            float sumAvgSpeed = 0.0f;
            int sumDuration = 0;
            if (selExerciseIDs.length == 1) {
                Exercise selExercise = (Exercise)this.document.getExerciseList().getByID(selExerciseIDs[0]);
                sumDistance = selExercise.getDistance();
                sumAvgSpeed = selExercise.getAvgSpeed();
                sumDuration = selExercise.getDuration();
            } else {
                int[] nArray = selExerciseIDs;
                int n = selExerciseIDs.length;
                int n2 = 0;
                while (n2 < n) {
                    int exerciseID = nArray[n2];
                    Exercise selExercise = (Exercise)this.document.getExerciseList().getByID(exerciseID);
                    sumDistance += selExercise.getDistance();
                    sumDuration += selExercise.getDuration();
                    ++n2;
                }
                sumAvgSpeed = CalculationUtils.calculateAvgSpeed(sumDistance, sumDuration);
            }
            String strCount = String.valueOf(selExerciseIDs.length);
            String strDistance = this.context.getFormatUtils().distanceToString(sumDistance, 3);
            String strAVGSpeed = this.context.getFormatUtils().speedToString(sumAvgSpeed, 3);
            String strDuration = this.context.getFormatUtils().seconds2TimeString(sumDuration);
            statusText = this.context.getResReader().getString("st.view.statusbar", strCount, strDistance, strAVGSpeed, strDuration);
        }
        this.laStatusBar.setText(statusText);
    }
}

