/*
 * Decompiled with CFR 0.152.
 */
package de.saring.sportstracker.gui.dialogs;

import de.saring.sportstracker.data.Equipment;
import de.saring.sportstracker.data.Exercise;
import de.saring.sportstracker.data.ExerciseFilter;
import de.saring.sportstracker.data.SportSubType;
import de.saring.sportstracker.data.SportType;
import de.saring.sportstracker.gui.STContext;
import de.saring.sportstracker.gui.STDocument;
import de.saring.util.gui.DialogUtils;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DateFormat;
import java.util.Calendar;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import javax.inject.Inject;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import org.jdesktop.application.Action;
import org.jdesktop.application.ApplicationActionMap;
import org.jdesktop.swingx.JXDatePicker;

public class FilterDialog
extends JDialog {
    private static final Logger LOGGER = Logger.getLogger(FilterDialog.class.getName());
    private STContext context;
    private STDocument document;
    private ExerciseFilter selectedFilter = null;
    private static final String ACTION_CURRENT_WEEK = "st.dlg.filter.current_week";
    private static final String ACTION_CURRENT_MONTH = "st.dlg.filter.current_month";
    private static final String ACTION_CURRENT_YEAR = "st.dlg.filter.current_year";
    private static final String ACTION_ALL_TIME = "st.dlg.filter.all_time";
    private static final String ACTION_OK = "st.dlg.filter.ok";
    private static final String ACTION_CANCEL = "st.dlg.filter.cancel";
    private JButton btAllTime;
    private JButton btCancel;
    private JButton btCurrentMonth;
    private JButton btCurrentWeek;
    private JButton btCurrentYear;
    private JButton btOK;
    private JComboBox cbEquipment;
    private JComboBox cbIntensity;
    private JCheckBox cbRegExpression;
    private JComboBox cbSportSubType;
    private JComboBox cbSportType;
    private JXDatePicker dpDateEnd;
    private JXDatePicker dpDateStart;
    private JLabel laCommentString;
    private JLabel laEquipment;
    private JLabel laFilter;
    private JLabel laFrom;
    private JLabel laIntensity;
    private JLabel laSportSubType;
    private JLabel laSportType;
    private JLabel laTimePeriod;
    private JLabel laTo;
    private JPanel pDataCenter;
    private JPanel pDataLeft;
    private JPanel pDataRight;
    private JPanel pFilterDataGrid;
    private JPanel pTimeButtons;
    private JSeparator separator;
    private JTextField tfCommentString;

    @Inject
    public FilterDialog(STContext context, STDocument document) {
        super((Frame)context.getMainFrame(), true);
        this.context = context;
        this.document = document;
        this.initComponents();
        this.getRootPane().setDefaultButton(this.btOK);
        DateFormat dateFormat = DateFormat.getDateInstance(2);
        this.dpDateStart.setFormats(dateFormat);
        this.dpDateEnd.setFormats(dateFormat);
        this.dpDateStart.setLinkPanel(null);
        this.dpDateEnd.setLinkPanel(null);
        ApplicationActionMap actionMap = context.getSAFContext().getActionMap(this.getClass(), this);
        this.btCurrentWeek.setAction(actionMap.get(ACTION_CURRENT_WEEK));
        this.btCurrentMonth.setAction(actionMap.get(ACTION_CURRENT_MONTH));
        this.btCurrentYear.setAction(actionMap.get(ACTION_CURRENT_YEAR));
        this.btAllTime.setAction(actionMap.get(ACTION_ALL_TIME));
        this.btOK.setAction(actionMap.get(ACTION_OK));
        javax.swing.Action aCancel = actionMap.get(ACTION_CANCEL);
        this.btCancel.setAction(aCancel);
        DialogUtils.setDialogEscapeKeyAction(this, aCancel);
        this.cbSportType.removeAllItems();
        this.cbSportType.addItem(context.getResReader().getString("st.dlg.filter.all.text", new Object[0]));
        for (SportType sportType : document.getSportTypeList()) {
            this.cbSportType.addItem(sportType.getName());
        }
        this.cbIntensity.removeAllItems();
        this.cbIntensity.addItem(context.getResReader().getString("st.dlg.filter.all.text", new Object[0]));
        Exercise.IntensityType[] intensityTypeArray = Exercise.IntensityType.values();
        int n = intensityTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            Exercise.IntensityType intensity = intensityTypeArray[n2];
            this.cbIntensity.addItem(intensity);
            ++n2;
        }
    }

    public void setInitialFilter(ExerciseFilter iFilter) {
        this.dpDateStart.setDate(iFilter.getDateStart());
        this.dpDateEnd.setDate(iFilter.getDateEnd());
        if (iFilter.getSportType() != null) {
            int sportTypeIndex = this.document.getSportTypeList().indexOf(iFilter.getSportType());
            this.cbSportType.setSelectedIndex(sportTypeIndex + 1);
        }
        this.updateForSelectedSportType();
        if (iFilter.getSportType() != null && iFilter.getSportSubType() != null) {
            int subTypeIndex = iFilter.getSportType().getSportSubTypeList().indexOf(iFilter.getSportSubType());
            this.cbSportSubType.setSelectedIndex(subTypeIndex + 1);
        }
        if (iFilter.getIntensity() != null) {
            this.cbIntensity.setSelectedItem((Object)iFilter.getIntensity());
        }
        if (iFilter.getSportType() != null && iFilter.getEquipment() != null) {
            int equipmentIndex = iFilter.getSportType().getEquipmentList().indexOf(iFilter.getEquipment());
            this.cbEquipment.setSelectedIndex(equipmentIndex + 1);
        }
        this.tfCommentString.setText(iFilter.getCommentSubString());
        this.cbRegExpression.setSelected(iFilter.isRegularExpressionMode());
        this.cbSportType.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FilterDialog.this.updateForSelectedSportType();
            }
        });
    }

    private void updateForSelectedSportType() {
        this.cbSportSubType.removeAllItems();
        this.cbSportSubType.addItem(this.context.getResReader().getString("st.dlg.filter.all.text", new Object[0]));
        this.cbEquipment.removeAllItems();
        this.cbEquipment.addItem(this.context.getResReader().getString("st.dlg.filter.all.text", new Object[0]));
        int selSportTypeIndex = this.cbSportType.getSelectedIndex();
        if (--selSportTypeIndex < 0) {
            return;
        }
        SportType selSportType = (SportType)this.document.getSportTypeList().getAt(selSportTypeIndex);
        for (SportSubType sportSubType : selSportType.getSportSubTypeList()) {
            this.cbSportSubType.addItem(sportSubType.getName());
        }
        for (Equipment equipment : selSportType.getEquipmentList()) {
            this.cbEquipment.addItem(equipment.getName());
        }
    }

    @Action(name="st.dlg.filter.current_week")
    public void setCurrentWeek() {
        Calendar cStart = Calendar.getInstance();
        Calendar cEnd = Calendar.getInstance();
        Calendar cNow = Calendar.getInstance();
        cStart.clear();
        cEnd.clear();
        cStart.set(cNow.get(1), cNow.get(2), cNow.get(5), 0, 0, 0);
        cEnd.set(cNow.get(1), cNow.get(2), cNow.get(5), 23, 59, 59);
        int weekStartDayCount = 0;
        if (this.document.getOptions().isWeekStartSunday()) {
            switch (cNow.get(7)) {
                case 2: {
                    weekStartDayCount = -1;
                    break;
                }
                case 3: {
                    weekStartDayCount = -2;
                    break;
                }
                case 4: {
                    weekStartDayCount = -3;
                    break;
                }
                case 5: {
                    weekStartDayCount = -4;
                    break;
                }
                case 6: {
                    weekStartDayCount = -5;
                    break;
                }
                case 7: {
                    weekStartDayCount = -6;
                }
            }
        } else {
            switch (cNow.get(7)) {
                case 3: {
                    weekStartDayCount = -1;
                    break;
                }
                case 4: {
                    weekStartDayCount = -2;
                    break;
                }
                case 5: {
                    weekStartDayCount = -3;
                    break;
                }
                case 6: {
                    weekStartDayCount = -4;
                    break;
                }
                case 7: {
                    weekStartDayCount = -5;
                    break;
                }
                case 1: {
                    weekStartDayCount = -6;
                }
            }
        }
        cStart.add(5, weekStartDayCount);
        cEnd.add(5, weekStartDayCount + 6);
        this.dpDateStart.setDate(cStart.getTime());
        this.dpDateEnd.setDate(cEnd.getTime());
    }

    @Action(name="st.dlg.filter.current_month")
    public void setCurrentMonth() {
        Calendar cStart = Calendar.getInstance();
        Calendar cEnd = Calendar.getInstance();
        Calendar cNow = Calendar.getInstance();
        cStart.clear();
        cEnd.clear();
        cStart.set(cNow.get(1), cNow.get(2), 1, 0, 0, 0);
        cEnd.set(cNow.get(1), cNow.get(2), cNow.getActualMaximum(5), 23, 59, 59);
        this.dpDateStart.setDate(cStart.getTime());
        this.dpDateEnd.setDate(cEnd.getTime());
    }

    @Action(name="st.dlg.filter.current_year")
    public void setCurrentYear() {
        Calendar cStart = Calendar.getInstance();
        Calendar cEnd = Calendar.getInstance();
        Calendar cNow = Calendar.getInstance();
        cStart.clear();
        cEnd.clear();
        cStart.set(cNow.get(1), 0, 1, 0, 0, 0);
        cEnd.set(cNow.get(1), 11, 31, 23, 59, 59);
        this.dpDateStart.setDate(cStart.getTime());
        this.dpDateEnd.setDate(cEnd.getTime());
    }

    @Action(name="st.dlg.filter.all_time")
    public void setAllTime() {
        Calendar cStart = Calendar.getInstance();
        Calendar cEnd = Calendar.getInstance();
        cStart.clear();
        cEnd.clear();
        cStart.set(1900, 0, 1, 0, 0, 0);
        cEnd.set(2999, 11, 31, 23, 59, 59);
        this.dpDateStart.setDate(cStart.getTime());
        this.dpDateEnd.setDate(cEnd.getTime());
    }

    @Action(name="st.dlg.filter.ok")
    public void ok() {
        int selIntensityIndex;
        ExerciseFilter filter = new ExerciseFilter();
        if (this.dpDateStart.getDate() == null) {
            this.context.showMessageDialog(this, 0, "common.error", "st.dlg.filter.error.date", new Object[0]);
            this.dpDateStart.requestFocus();
            return;
        }
        if (this.dpDateEnd.getDate() == null) {
            this.context.showMessageDialog(this, 0, "common.error", "st.dlg.filter.error.date", new Object[0]);
            this.dpDateEnd.requestFocus();
            return;
        }
        Calendar cTemp = Calendar.getInstance();
        cTemp.clear();
        cTemp.setTime(this.dpDateStart.getDate());
        cTemp.set(11, 0);
        cTemp.set(12, 0);
        cTemp.set(13, 0);
        filter.setDateStart(cTemp.getTime());
        cTemp.clear();
        cTemp.setTime(this.dpDateEnd.getDate());
        cTemp.set(11, 23);
        cTemp.set(12, 59);
        cTemp.set(13, 59);
        filter.setDateEnd(cTemp.getTime());
        if (!filter.getDateStart().before(filter.getDateEnd())) {
            this.context.showMessageDialog(this, 0, "common.error", "st.dlg.filter.error.start_after_end", new Object[0]);
            return;
        }
        int selSportTypeIndex = this.cbSportType.getSelectedIndex() - 1;
        if (selSportTypeIndex >= 0) {
            int selEquipmentIndex;
            filter.setSportType((SportType)this.document.getSportTypeList().getAt(selSportTypeIndex));
            int selSportSubTypeIndex = this.cbSportSubType.getSelectedIndex() - 1;
            if (selSportSubTypeIndex >= 0) {
                filter.setSportSubType(filter.getSportType().getSportSubTypeList().getAt(selSportSubTypeIndex));
            }
            if ((selEquipmentIndex = this.cbEquipment.getSelectedIndex() - 1) >= 0) {
                filter.setEquipment(filter.getSportType().getEquipmentList().getAt(selEquipmentIndex));
            }
        }
        if ((selIntensityIndex = this.cbIntensity.getSelectedIndex() - 1) >= 0) {
            filter.setIntensity((Exercise.IntensityType)((Object)this.cbIntensity.getSelectedItem()));
        }
        filter.setCommentSubString(this.tfCommentString.getText().trim());
        filter.setRegularExpressionMode(this.cbRegExpression.isSelected());
        if (filter.isRegularExpressionMode()) {
            try {
                Pattern.compile(filter.getCommentSubString());
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, "Syntax error in the regular expression search string: " + filter.getCommentSubString(), e);
                this.tfCommentString.selectAll();
                this.context.showMessageDialog(this, 0, "common.error", "st.dlg.filter.error.reg_expression_error", new Object[0]);
                this.tfCommentString.requestFocus();
                return;
            }
        }
        this.selectedFilter = filter;
        this.dispose();
    }

    @Action(name="st.dlg.filter.cancel")
    public void cancel() {
        this.dispose();
    }

    public ExerciseFilter getSelectedFilter() {
        return this.selectedFilter;
    }

    private void initComponents() {
        this.btOK = new JButton();
        this.btCancel = new JButton();
        this.laTimePeriod = new JLabel();
        this.laFrom = new JLabel();
        this.laTo = new JLabel();
        this.laFilter = new JLabel();
        this.pFilterDataGrid = new JPanel();
        this.pDataLeft = new JPanel();
        this.laSportType = new JLabel();
        this.cbSportType = new JComboBox();
        this.pDataCenter = new JPanel();
        this.laSportSubType = new JLabel();
        this.cbSportSubType = new JComboBox();
        this.pDataRight = new JPanel();
        this.laIntensity = new JLabel();
        this.cbIntensity = new JComboBox();
        this.laCommentString = new JLabel();
        this.tfCommentString = new JTextField();
        this.cbRegExpression = new JCheckBox();
        this.separator = new JSeparator();
        this.pTimeButtons = new JPanel();
        this.btCurrentWeek = new JButton();
        this.btCurrentMonth = new JButton();
        this.btCurrentYear = new JButton();
        this.btAllTime = new JButton();
        this.dpDateStart = new JXDatePicker();
        this.dpDateEnd = new JXDatePicker();
        this.laEquipment = new JLabel();
        this.cbEquipment = new JComboBox();
        this.setDefaultCloseOperation(2);
        this.setModal(true);
        this.setName("st.dlg.filter");
        this.setResizable(false);
        this.btOK.setText("OK");
        this.btOK.setName("btOK");
        this.btCancel.setText("Cancel");
        this.btCancel.setName("btCancel");
        this.laTimePeriod.setFont(this.laTimePeriod.getFont().deriveFont(this.laTimePeriod.getFont().getStyle() | 1));
        this.laTimePeriod.setText("_Time Period");
        this.laTimePeriod.setName("st.dlg.filter.time_period");
        this.laFrom.setText("_From:");
        this.laFrom.setName("st.dlg.filter.from");
        this.laTo.setText("_to:");
        this.laTo.setName("st.dlg.filter.to");
        this.laFilter.setFont(this.laFilter.getFont().deriveFont(this.laFilter.getFont().getStyle() | 1));
        this.laFilter.setText("_Filter");
        this.laFilter.setName("st.dlg.filter.filter");
        this.pFilterDataGrid.setName("pFilterDataGrid");
        this.pFilterDataGrid.setLayout(new GridLayout(1, 3, 20, 0));
        this.pDataLeft.setName("pDataLeft");
        this.laSportType.setText("_Sport type:");
        this.laSportType.setName("st.dlg.filter.sport_type");
        this.cbSportType.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1"}));
        this.cbSportType.setName("cbSportType");
        GroupLayout pDataLeftLayout = new GroupLayout(this.pDataLeft);
        this.pDataLeft.setLayout(pDataLeftLayout);
        pDataLeftLayout.setHorizontalGroup(pDataLeftLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pDataLeftLayout.createSequentialGroup().addComponent(this.laSportType).addContainerGap(89, Short.MAX_VALUE)).addComponent(this.cbSportType, 0, 167, Short.MAX_VALUE));
        pDataLeftLayout.setVerticalGroup(pDataLeftLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pDataLeftLayout.createSequentialGroup().addComponent(this.laSportType).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cbSportType, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        this.pFilterDataGrid.add(this.pDataLeft);
        this.pDataCenter.setName("pDataCenter");
        this.laSportSubType.setText("_Sport subtype:");
        this.laSportSubType.setName("st.dlg.filter.sport_subtype");
        this.cbSportSubType.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1"}));
        this.cbSportSubType.setName("cbSportSubType");
        GroupLayout pDataCenterLayout = new GroupLayout(this.pDataCenter);
        this.pDataCenter.setLayout(pDataCenterLayout);
        pDataCenterLayout.setHorizontalGroup(pDataCenterLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pDataCenterLayout.createSequentialGroup().addComponent(this.laSportSubType).addContainerGap(66, Short.MAX_VALUE)).addComponent(this.cbSportSubType, 0, 167, Short.MAX_VALUE));
        pDataCenterLayout.setVerticalGroup(pDataCenterLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pDataCenterLayout.createSequentialGroup().addComponent(this.laSportSubType).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cbSportSubType, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        this.pFilterDataGrid.add(this.pDataCenter);
        this.pDataRight.setName("pDataRight");
        this.laIntensity.setText("_Intensity:");
        this.laIntensity.setName("st.dlg.filter.intensity");
        this.cbIntensity.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1"}));
        this.cbIntensity.setName("cbIntensity");
        GroupLayout pDataRightLayout = new GroupLayout(this.pDataRight);
        this.pDataRight.setLayout(pDataRightLayout);
        pDataRightLayout.setHorizontalGroup(pDataRightLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pDataRightLayout.createSequentialGroup().addComponent(this.laIntensity).addContainerGap(102, Short.MAX_VALUE)).addComponent(this.cbIntensity, 0, 167, Short.MAX_VALUE));
        pDataRightLayout.setVerticalGroup(pDataRightLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(pDataRightLayout.createSequentialGroup().addComponent(this.laIntensity).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cbIntensity, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        this.pFilterDataGrid.add(this.pDataRight);
        this.laCommentString.setText("_String in comments:");
        this.laCommentString.setName("st.dlg.filter.string_comments");
        this.tfCommentString.setName("tfCommentString");
        this.cbRegExpression.setText("_Regular expression mode (case sensitive)");
        this.cbRegExpression.setName("st.dlg.filter.reg_expression");
        this.separator.setName("separator");
        this.pTimeButtons.setName("pTimeButtons");
        this.pTimeButtons.setLayout(new GridLayout(1, 0, 15, 0));
        this.btCurrentWeek.setText("_Current Week");
        this.btCurrentWeek.setName("btCurrentWeek");
        this.pTimeButtons.add(this.btCurrentWeek);
        this.btCurrentMonth.setText("_Current Month");
        this.btCurrentMonth.setName("btCurrentMonth");
        this.pTimeButtons.add(this.btCurrentMonth);
        this.btCurrentYear.setText("_Current Year");
        this.btCurrentYear.setName("btCurrentYear");
        this.pTimeButtons.add(this.btCurrentYear);
        this.btAllTime.setText("_All Time");
        this.btAllTime.setName("btAllTime");
        this.pTimeButtons.add(this.btAllTime);
        this.dpDateStart.setName("dpDateStart");
        this.dpDateEnd.setName("dpDateEnd");
        this.laEquipment.setText("_Equipment:");
        this.laEquipment.setName("st.dlg.filter.equipment");
        this.cbEquipment.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.cbEquipment.setName("cbEquipment");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.laTimePeriod).addGroup(layout.createSequentialGroup().addGap(10, 10, 10).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.laFrom).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.dpDateStart, -2, 150, -2).addGap(18, 18, 18).addComponent(this.laTo).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.dpDateEnd, -2, 150, -2)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(this.btCancel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btOK)).addComponent(this.pTimeButtons, -2, 541, Short.MAX_VALUE))).addComponent(this.laFilter))).addGroup(layout.createSequentialGroup().addGap(20, 20, 20).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.laEquipment).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cbEquipment, 0, 451, Short.MAX_VALUE)).addComponent(this.pFilterDataGrid, -1, 543, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.laCommentString).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.tfCommentString, -1, 394, Short.MAX_VALUE)).addComponent(this.cbRegExpression)))).addContainerGap()).addComponent(this.separator, -1, 575, Short.MAX_VALUE));
        layout.linkSize(0, this.btCancel, this.btOK);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.laTimePeriod).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.laFrom).addComponent(this.dpDateStart, -2, -1, -2).addComponent(this.laTo).addComponent(this.dpDateEnd, -2, -1, -2)).addGap(18, 18, 18).addComponent(this.pTimeButtons, -2, -1, -2).addGap(18, 18, 18).addComponent(this.laFilter).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.pFilterDataGrid, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.laEquipment).addComponent(this.cbEquipment, -2, -1, -2)).addGap(20, 20, 20).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.laCommentString).addComponent(this.tfCommentString, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.cbRegExpression).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.separator, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED, -1, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.btOK).addComponent(this.btCancel)).addContainerGap()));
        this.pack();
    }
}

