/*
 * Decompiled with CFR 0.152.
 */
package de.saring.sportstracker.gui.dialogs;

import de.saring.sportstracker.data.Note;
import de.saring.sportstracker.gui.STContext;
import de.saring.sportstracker.gui.STDocument;
import de.saring.util.gui.DialogUtils;
import de.saring.util.gui.GuiCreateUtils;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.util.Calendar;
import javax.inject.Inject;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import net.miginfocom.swing.MigLayout;
import org.jdesktop.application.Action;
import org.jdesktop.application.ApplicationActionMap;
import org.jdesktop.swingx.JXDatePicker;

public class NoteDialog
extends JDialog {
    private STContext context;
    private STDocument document;
    private JXDatePicker dpDate;
    private JSpinner spHour;
    private JSpinner spMinute;
    private JTextArea taText;
    private JButton btOK;
    private JButton btCancel;
    private Note note;
    private static final String ACTION_OK = "st.dlg.note.ok";
    private static final String ACTION_CANCEL = "st.dlg.note.cancel";

    @Inject
    public NoteDialog(STContext context, STDocument document) {
        super((Frame)context.getMainFrame(), true);
        this.context = context;
        this.document = document;
        this.initGUI();
        ApplicationActionMap actionMap = context.getSAFContext().getActionMap(this.getClass(), this);
        this.btOK.setAction(actionMap.get(ACTION_OK));
        javax.swing.Action aCancel = actionMap.get(ACTION_CANCEL);
        this.btCancel.setAction(aCancel);
        DialogUtils.setDialogEscapeKeyAction(this, aCancel);
    }

    private void initGUI() {
        this.setName("st.dlg.note");
        JLabel laDate = GuiCreateUtils.createLabel("st.dlg.note.date", false);
        JLabel laTime = GuiCreateUtils.createLabel("st.dlg.note.time", false);
        JLabel laTimeSeparator = new JLabel(":");
        JLabel laText = GuiCreateUtils.createLabel("st.dlg.note.text", false);
        this.dpDate = GuiCreateUtils.createDatePicker();
        this.spHour = GuiCreateUtils.createSpinner(new SpinnerNumberModel(12, 0, 23, 1));
        this.spMinute = GuiCreateUtils.createSpinner(new SpinnerNumberModel(0, 0, 59, 1));
        this.taText = new JTextArea();
        this.taText.setLineWrap(true);
        this.taText.setWrapStyleWord(true);
        JScrollPane spText = new JScrollPane(this.taText);
        this.taText.setFont(new JTextField().getFont());
        this.btOK = new JButton();
        this.btCancel = new JButton();
        JPanel pButtons = GuiCreateUtils.createDialogButtonPanel(this.btCancel, this.btOK);
        Container pane = this.getContentPane();
        pane.setLayout(new MigLayout("insets 12, gap 12", "[][]25[][]5[]5[]", "[]16[]8[grow][]"));
        pane.add(laDate);
        pane.add(this.dpDate);
        pane.add(laTime);
        pane.add(this.spHour);
        pane.add(laTimeSeparator);
        pane.add((Component)this.spMinute, "wrap");
        pane.add((Component)laText, "wrap");
        pane.add((Component)spText, "spanx, width 400, height 160, grow, wrap");
        pane.add((Component)pButtons, "spanx, growx");
        this.getRootPane().setDefaultButton(this.btOK);
        this.setResizable(false);
        this.pack();
    }

    public void setNote(Note note) {
        this.note = note;
        this.setInitialValues();
    }

    @Override
    public void setTitle(String title) {
        if (this.document.getNoteList().getByID(this.note.getId()) == null) {
            super.setTitle(this.context.getResReader().getString("st.dlg.note.title.add", new Object[0]));
        } else {
            super.setTitle(title);
        }
    }

    private void setInitialValues() {
        this.dpDate.setDate(this.note.getDate());
        Calendar calTemp = Calendar.getInstance();
        calTemp.setTime(this.note.getDate());
        this.spHour.setValue(calTemp.get(11));
        this.spMinute.setValue(calTemp.get(12));
        this.taText.setText(this.note.getText());
        this.taText.setCaretPosition(0);
    }

    @Action(name="st.dlg.note.ok")
    public void ok() {
        Note newNote = new Note(this.note.getId());
        if (this.dpDate.getDate() == null) {
            this.context.showMessageDialog(this, 0, "common.error", "st.dlg.note.error.date", new Object[0]);
            this.dpDate.requestFocus();
            return;
        }
        Calendar calTemp = Calendar.getInstance();
        calTemp.setTime(this.dpDate.getDate());
        calTemp.set(11, (Integer)this.spHour.getValue());
        calTemp.set(12, (Integer)this.spMinute.getValue());
        calTemp.set(13, 0);
        newNote.setDate(calTemp.getTime());
        String strText = this.taText.getText().trim();
        if (strText.length() == 0) {
            this.context.showMessageDialog(this, 0, "common.error", "st.dlg.note.error.no_text", new Object[0]);
            this.taText.requestFocus();
            return;
        }
        newNote.setText(strText);
        this.document.getNoteList().set(newNote);
        this.dispose();
    }

    @Action(name="st.dlg.note.cancel")
    public void cancel() {
        this.dispose();
    }
}

