/*
 * Decompiled with CFR 0.152.
 */
package de.saring.sportstracker.gui.dialogs;

import de.saring.sportstracker.core.STOptions;
import de.saring.sportstracker.gui.STContext;
import de.saring.sportstracker.gui.STDocument;
import de.saring.util.gui.DialogUtils;
import de.saring.util.unitcalc.FormatUtils;
import java.awt.Frame;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.inject.Inject;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTabbedPane;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.jdesktop.application.Action;
import org.jdesktop.application.ApplicationActionMap;

public class OptionsDialog
extends JDialog {
    private static final Logger LOGGER = Logger.getLogger(OptionsDialog.class.getName());
    private static final String ACTION_OK = "st.dlg.options.ok";
    private static final String ACTION_CANCEL = "st.dlg.options.cancel";
    private STContext context;
    private STDocument document;
    private ButtonGroup bgInitialView;
    private ButtonGroup bgSpeedUnitView;
    private ButtonGroup bgUnitSystem;
    private ButtonGroup bgWeekStart;
    private JButton btCancel;
    private JButton btOK;
    private JComboBox cbDefaultAutoCalculation;
    private JComboBox cbLookAndFeel;
    private JCheckBox cbSaveOnExit;
    private JCheckBox cbSecondGraph;
    private JCheckBox cbShowAscent;
    private JCheckBox cbShowAvgHeartrate;
    private JCheckBox cbShowComment;
    private JCheckBox cbShowEnergy;
    private JCheckBox cbShowEquipment;
    private JLabel laDefaultAutoCalculation;
    private JLabel laDiagram;
    private JLabel laInitialView;
    private JLabel laLookAndFeel;
    private JLabel laOptionalFields;
    private JLabel laSaveOnExit;
    private JLabel laSpeedView;
    private JLabel laUnitSystem;
    private JLabel laWeekStart;
    private JPanel paListView;
    private JPanel paMain;
    private JPanel paExerciseViewer;
    private JPanel paUnits;
    private JRadioButton rbCalendar;
    private JRadioButton rbDistanceHour;
    private JRadioButton rbEnglish;
    private JRadioButton rbExerciseList;
    private JRadioButton rbMetric;
    private JRadioButton rbMinutesDistance;
    private JRadioButton rbMonday;
    private JRadioButton rbSunday;
    private JTabbedPane tabbedPane;

    @Inject
    public OptionsDialog(STContext context, STDocument document) {
        super((Frame)context.getMainFrame(), true);
        this.context = context;
        this.document = document;
        this.initComponents();
        this.setTextTranslations();
        this.getRootPane().setDefaultButton(this.btOK);
        ApplicationActionMap actionMap = context.getSAFContext().getActionMap(this.getClass(), this);
        this.btOK.setAction(actionMap.get(ACTION_OK));
        javax.swing.Action aCancel = actionMap.get(ACTION_CANCEL);
        this.btCancel.setAction(aCancel);
        DialogUtils.setDialogEscapeKeyAction(this, aCancel);
        this.setInitialValues();
    }

    private void setTextTranslations() {
        this.tabbedPane.setTitleAt(0, this.context.getResReader().getString("st.dlg.options.main.title", new Object[0]));
        this.tabbedPane.setTitleAt(1, this.context.getResReader().getString("st.dlg.options.units.title", new Object[0]));
        this.tabbedPane.setTitleAt(2, this.context.getResReader().getString("st.dlg.options.listview.title", new Object[0]));
        this.tabbedPane.setTitleAt(3, this.context.getResReader().getString("st.dlg.options.exerciseviewer.title", new Object[0]));
    }

    private void setInitialValues() {
        STOptions options = this.document.getOptions();
        if (options.getInitialView() == STOptions.View.Calendar) {
            this.rbCalendar.setSelected(true);
        } else {
            this.rbExerciseList.setSelected(true);
        }
        if (options.getUnitSystem() == FormatUtils.UnitSystem.Metric) {
            this.rbMetric.setSelected(true);
        } else {
            this.rbEnglish.setSelected(true);
        }
        if (options.getSpeedView() == FormatUtils.SpeedView.DistancePerHour) {
            this.rbDistanceHour.setSelected(true);
        } else {
            this.rbMinutesDistance.setSelected(true);
        }
        if (options.isWeekStartSunday()) {
            this.rbSunday.setSelected(true);
        } else {
            this.rbMonday.setSelected(true);
        }
        this.cbSecondGraph.setSelected(options.isDisplaySecondDiagram());
        this.cbSaveOnExit.setSelected(options.isSaveOnExit());
        this.cbDefaultAutoCalculation.removeAllItems();
        this.cbDefaultAutoCalculation.addItem(new AutoCalculationComboBoxItem(STOptions.AutoCalculation.Distance, this.context.getResReader().getString("st.dlg.options.distance.text", new Object[0])));
        this.cbDefaultAutoCalculation.addItem(new AutoCalculationComboBoxItem(STOptions.AutoCalculation.AvgSpeed, this.context.getResReader().getString("st.dlg.options.avg_speed.text", new Object[0])));
        this.cbDefaultAutoCalculation.addItem(new AutoCalculationComboBoxItem(STOptions.AutoCalculation.Duration, this.context.getResReader().getString("st.dlg.options.duration.text", new Object[0])));
        int i = 0;
        while (i < this.cbDefaultAutoCalculation.getItemCount()) {
            AutoCalculationComboBoxItem item = (AutoCalculationComboBoxItem)this.cbDefaultAutoCalculation.getItemAt(i);
            if (item.getAutoCalculation() == options.getDefaultAutoCalcuation()) {
                this.cbDefaultAutoCalculation.setSelectedItem(item);
                break;
            }
            ++i;
        }
        this.cbShowAvgHeartrate.setSelected(options.isListViewShowAvgHeartrate());
        this.cbShowAscent.setSelected(options.isListViewShowAscent());
        this.cbShowEnergy.setSelected(options.isListViewShowEnergy());
        this.cbShowEquipment.setSelected(options.isListViewShowEquipment());
        this.cbShowComment.setSelected(options.isListViewShowComment());
        UIManager.LookAndFeelInfo[] lafInfos = UIManager.getInstalledLookAndFeels();
        String currentLAFClassName = UIManager.getLookAndFeel().getClass().getName();
        this.cbLookAndFeel.removeAllItems();
        UIManager.LookAndFeelInfo[] lookAndFeelInfoArray = lafInfos;
        int n = lafInfos.length;
        int n2 = 0;
        while (n2 < n) {
            UIManager.LookAndFeelInfo info = lookAndFeelInfoArray[n2];
            LAFComboBoxItem cbItem = new LAFComboBoxItem(info);
            this.cbLookAndFeel.addItem(cbItem);
            if (info.getClassName().equals(currentLAFClassName)) {
                this.cbLookAndFeel.setSelectedItem(cbItem);
            }
            ++n2;
        }
    }

    @Action(name="st.dlg.options.ok")
    public void ok() {
        STOptions options = this.document.getOptions();
        options.setInitialView(this.rbCalendar.isSelected() ? STOptions.View.Calendar : STOptions.View.List);
        options.setUnitSystem(this.rbMetric.isSelected() ? FormatUtils.UnitSystem.Metric : FormatUtils.UnitSystem.English);
        options.setSpeedView(this.rbDistanceHour.isSelected() ? FormatUtils.SpeedView.DistancePerHour : FormatUtils.SpeedView.MinutesPerDistance);
        options.setWeekStartSunday(this.rbSunday.isSelected());
        options.setDisplaySecondDiagram(this.cbSecondGraph.isSelected());
        options.setSaveOnExit(this.cbSaveOnExit.isSelected());
        AutoCalculationComboBoxItem acItem = (AutoCalculationComboBoxItem)this.cbDefaultAutoCalculation.getSelectedItem();
        options.setDefaultAutoCalcuation(acItem.getAutoCalculation());
        LAFComboBoxItem lafItem = (LAFComboBoxItem)this.cbLookAndFeel.getSelectedItem();
        options.setLookAndFeelClassName(lafItem.getLookAndFeelInfo().getClassName());
        this.setLookAndFeel(options.getLookAndFeelClassName());
        options.setListViewShowAvgHeartrate(this.cbShowAvgHeartrate.isSelected());
        options.setListViewShowEnergy(this.cbShowEnergy.isSelected());
        options.setListViewShowAscent(this.cbShowAscent.isSelected());
        options.setListViewShowEquipment(this.cbShowEquipment.isSelected());
        options.setListViewShowComment(this.cbShowComment.isSelected());
        this.document.storeOptions();
        this.dispose();
    }

    @Action(name="st.dlg.options.cancel")
    public void cancel() {
        this.dispose();
    }

    private void setLookAndFeel(String lookAndFeelClassName) {
        if (!UIManager.getLookAndFeel().getClass().getName().equals(lookAndFeelClassName)) {
            try {
                UIManager.setLookAndFeel(lookAndFeelClassName);
                SwingUtilities.updateComponentTreeUI(this.context.getMainFrame());
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, "Failed to change look&feel to " + lookAndFeelClassName + "!", e);
            }
        }
    }

    private void initComponents() {
        this.bgInitialView = new ButtonGroup();
        this.bgUnitSystem = new ButtonGroup();
        this.bgSpeedUnitView = new ButtonGroup();
        this.bgWeekStart = new ButtonGroup();
        this.tabbedPane = new JTabbedPane();
        this.paMain = new JPanel();
        this.laInitialView = new JLabel();
        this.rbCalendar = new JRadioButton();
        this.rbExerciseList = new JRadioButton();
        this.laDefaultAutoCalculation = new JLabel();
        this.cbDefaultAutoCalculation = new JComboBox();
        this.laLookAndFeel = new JLabel();
        this.cbLookAndFeel = new JComboBox();
        this.laSaveOnExit = new JLabel();
        this.cbSaveOnExit = new JCheckBox();
        this.paUnits = new JPanel();
        this.laWeekStart = new JLabel();
        this.laUnitSystem = new JLabel();
        this.rbMetric = new JRadioButton();
        this.rbEnglish = new JRadioButton();
        this.laSpeedView = new JLabel();
        this.rbDistanceHour = new JRadioButton();
        this.rbMinutesDistance = new JRadioButton();
        this.rbMonday = new JRadioButton();
        this.rbSunday = new JRadioButton();
        this.paListView = new JPanel();
        this.laOptionalFields = new JLabel();
        this.cbShowAvgHeartrate = new JCheckBox();
        this.cbShowAscent = new JCheckBox();
        this.cbShowEnergy = new JCheckBox();
        this.cbShowEquipment = new JCheckBox();
        this.cbShowComment = new JCheckBox();
        this.paExerciseViewer = new JPanel();
        this.laDiagram = new JLabel();
        this.cbSecondGraph = new JCheckBox();
        this.btOK = new JButton();
        this.btCancel = new JButton();
        this.setDefaultCloseOperation(2);
        this.setModal(true);
        this.setName("st.dlg.options");
        this.setResizable(false);
        this.tabbedPane.setName("tabbedPane");
        this.paMain.setName("paMain");
        this.laInitialView.setFont(this.laInitialView.getFont().deriveFont(this.laInitialView.getFont().getStyle() | 1));
        this.laInitialView.setText("_Initial View");
        this.laInitialView.setName("st.dlg.options.initial_view");
        this.bgInitialView.add(this.rbCalendar);
        this.rbCalendar.setText("_Calendar");
        this.rbCalendar.setName("st.dlg.options.calendar");
        this.bgInitialView.add(this.rbExerciseList);
        this.rbExerciseList.setText("_Exercise list");
        this.rbExerciseList.setName("st.dlg.options.exercise_list");
        this.laDefaultAutoCalculation.setFont(this.laDefaultAutoCalculation.getFont().deriveFont(this.laDefaultAutoCalculation.getFont().getStyle() | 1));
        this.laDefaultAutoCalculation.setText("_Default Automatic Calculation");
        this.laDefaultAutoCalculation.setName("st.dlg.options.defaultautocalc");
        this.cbDefaultAutoCalculation.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.cbDefaultAutoCalculation.setName("cbDefaultAutoCalculation");
        this.laLookAndFeel.setFont(this.laLookAndFeel.getFont().deriveFont(this.laLookAndFeel.getFont().getStyle() | 1));
        this.laLookAndFeel.setText("_Look & Feel");
        this.laLookAndFeel.setName("st.dlg.options.lookandfeel");
        this.cbLookAndFeel.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.cbLookAndFeel.setName("cbLookAndFeel");
        this.laSaveOnExit.setFont(this.laSaveOnExit.getFont().deriveFont(this.laSaveOnExit.getFont().getStyle() | 1));
        this.laSaveOnExit.setText("_Save on Exit");
        this.laSaveOnExit.setName("st.dlg.options.save_exit");
        this.cbSaveOnExit.setText("_Automatically save on application exit");
        this.cbSaveOnExit.setName("st.dlg.options.autosave_exit");
        GroupLayout paMainLayout = new GroupLayout(this.paMain);
        this.paMain.setLayout(paMainLayout);
        paMainLayout.setHorizontalGroup(paMainLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(paMainLayout.createSequentialGroup().addContainerGap().addGroup(paMainLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.laInitialView).addGroup(paMainLayout.createSequentialGroup().addGap(12, 12, 12).addGroup(paMainLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.rbExerciseList).addComponent(this.rbCalendar))).addGroup(GroupLayout.Alignment.TRAILING, paMainLayout.createSequentialGroup().addGap(12, 12, 12).addComponent(this.cbDefaultAutoCalculation, 0, 319, Short.MAX_VALUE)).addComponent(this.laDefaultAutoCalculation).addGroup(paMainLayout.createSequentialGroup().addGap(12, 12, 12).addComponent(this.cbLookAndFeel, 0, 319, Short.MAX_VALUE)).addComponent(this.laLookAndFeel).addGroup(paMainLayout.createSequentialGroup().addGap(12, 12, 12).addComponent(this.cbSaveOnExit)).addComponent(this.laSaveOnExit)).addContainerGap()));
        paMainLayout.setVerticalGroup(paMainLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(paMainLayout.createSequentialGroup().addContainerGap().addComponent(this.laInitialView).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.rbCalendar).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.rbExerciseList).addGap(18, 18, 18).addComponent(this.laDefaultAutoCalculation).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.cbDefaultAutoCalculation, -2, -1, -2).addGap(18, 18, 18).addComponent(this.laLookAndFeel).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.cbLookAndFeel, -2, -1, -2).addGap(18, 18, 18).addComponent(this.laSaveOnExit).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.cbSaveOnExit).addContainerGap()));
        this.tabbedPane.addTab("_Main", this.paMain);
        this.paUnits.setName("paUnits");
        this.laWeekStart.setFont(this.laWeekStart.getFont().deriveFont(this.laWeekStart.getFont().getStyle() | 1));
        this.laWeekStart.setText("_Week Start");
        this.laWeekStart.setName("st.dlg.options.week_start");
        this.laUnitSystem.setFont(this.laUnitSystem.getFont().deriveFont(this.laUnitSystem.getFont().getStyle() | 1));
        this.laUnitSystem.setText("_Unit System");
        this.laUnitSystem.setName("st.dlg.options.unit_system");
        this.bgUnitSystem.add(this.rbMetric);
        this.rbMetric.setText("_Metric (e.g. kilometers)");
        this.rbMetric.setName("st.dlg.options.metric");
        this.bgUnitSystem.add(this.rbEnglish);
        this.rbEnglish.setText("_English (e.g. miles)");
        this.rbEnglish.setName("st.dlg.options.english");
        this.laSpeedView.setFont(this.laSpeedView.getFont().deriveFont(this.laSpeedView.getFont().getStyle() | 1));
        this.laSpeedView.setText("_Speed Unit View");
        this.laSpeedView.setName("st.dlg.options.speed_unit");
        this.bgSpeedUnitView.add(this.rbDistanceHour);
        this.rbDistanceHour.setText("_Distance per hour (e.g. km/h)");
        this.rbDistanceHour.setName("st.dlg.options.distance_hour");
        this.bgSpeedUnitView.add(this.rbMinutesDistance);
        this.rbMinutesDistance.setText("_Minutes per distance (e.g. min/km)");
        this.rbMinutesDistance.setName("st.dlg.options.minutes_distance");
        this.bgWeekStart.add(this.rbMonday);
        this.rbMonday.setText("_Monday");
        this.rbMonday.setName("st.dlg.options.monday");
        this.bgWeekStart.add(this.rbSunday);
        this.rbSunday.setText("_Sunday");
        this.rbSunday.setName("st.dlg.options.sunday");
        GroupLayout paUnitsLayout = new GroupLayout(this.paUnits);
        this.paUnits.setLayout(paUnitsLayout);
        paUnitsLayout.setHorizontalGroup(paUnitsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(paUnitsLayout.createSequentialGroup().addContainerGap().addGroup(paUnitsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.laUnitSystem).addGroup(paUnitsLayout.createSequentialGroup().addGap(12, 12, 12).addGroup(paUnitsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.rbEnglish).addComponent(this.rbMetric))).addComponent(this.laSpeedView).addGroup(paUnitsLayout.createSequentialGroup().addGap(12, 12, 12).addGroup(paUnitsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.rbMinutesDistance).addComponent(this.rbDistanceHour))).addComponent(this.laWeekStart).addGroup(paUnitsLayout.createSequentialGroup().addGap(12, 12, 12).addGroup(paUnitsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.rbSunday).addComponent(this.rbMonday)))).addContainerGap(79, Short.MAX_VALUE)));
        paUnitsLayout.setVerticalGroup(paUnitsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(paUnitsLayout.createSequentialGroup().addContainerGap().addComponent(this.laUnitSystem).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.rbMetric).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.rbEnglish).addGap(18, 18, 18).addComponent(this.laSpeedView).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.rbDistanceHour).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.rbMinutesDistance).addGap(18, 18, 18).addComponent(this.laWeekStart).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.rbMonday).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.rbSunday).addContainerGap()));
        this.tabbedPane.addTab("_Units", this.paUnits);
        this.paListView.setName("paListView");
        this.laOptionalFields.setFont(this.laOptionalFields.getFont().deriveFont(this.laOptionalFields.getFont().getStyle() | 1));
        this.laOptionalFields.setText("_Display Optional Fields");
        this.laOptionalFields.setName("st.dlg.options.list_optional_fields");
        this.cbShowAvgHeartrate.setText("_Average heart rate");
        this.cbShowAvgHeartrate.setName("st.dlg.options.show_avg_heartrate");
        this.cbShowAscent.setText("_Ascent");
        this.cbShowAscent.setName("st.dlg.options.show_ascent");
        this.cbShowEnergy.setText("_Calorie consumed");
        this.cbShowEnergy.setName("st.dlg.options.show_energy");
        this.cbShowEquipment.setText("_Equipment");
        this.cbShowEquipment.setName("st.dlg.options.show_equipment");
        this.cbShowComment.setText("_Comment");
        this.cbShowComment.setName("st.dlg.options.show_comment");
        GroupLayout paListViewLayout = new GroupLayout(this.paListView);
        this.paListView.setLayout(paListViewLayout);
        paListViewLayout.setHorizontalGroup(paListViewLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(paListViewLayout.createSequentialGroup().addContainerGap().addGroup(paListViewLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.laOptionalFields).addGroup(paListViewLayout.createSequentialGroup().addGap(12, 12, 12).addGroup(paListViewLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.cbShowAvgHeartrate).addComponent(this.cbShowEnergy).addComponent(this.cbShowAscent).addComponent(this.cbShowEquipment).addComponent(this.cbShowComment)))).addContainerGap(168, Short.MAX_VALUE)));
        paListViewLayout.setVerticalGroup(paListViewLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(paListViewLayout.createSequentialGroup().addContainerGap().addComponent(this.laOptionalFields).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.cbShowAvgHeartrate).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cbShowAscent).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cbShowEnergy).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cbShowEquipment).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cbShowComment).addGap(137, 137, 137)));
        this.tabbedPane.addTab("_List View", this.paListView);
        this.paExerciseViewer.setName("paExerciseViewer");
        this.laDiagram.setFont(this.laDiagram.getFont().deriveFont(this.laDiagram.getFont().getStyle() | 1));
        this.laDiagram.setText("_Diagram");
        this.laDiagram.setName("st.dlg.options.diagram");
        this.cbSecondGraph.setText("_Show two graphs initially on available data");
        this.cbSecondGraph.setName("st.dlg.options.second_graph");
        GroupLayout paExerciseViewerLayout = new GroupLayout(this.paExerciseViewer);
        this.paExerciseViewer.setLayout(paExerciseViewerLayout);
        paExerciseViewerLayout.setHorizontalGroup(paExerciseViewerLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(paExerciseViewerLayout.createSequentialGroup().addContainerGap().addGroup(paExerciseViewerLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(paExerciseViewerLayout.createSequentialGroup().addGap(12, 12, 12).addComponent(this.cbSecondGraph)).addComponent(this.laDiagram)).addContainerGap(32, Short.MAX_VALUE)));
        paExerciseViewerLayout.setVerticalGroup(paExerciseViewerLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(paExerciseViewerLayout.createSequentialGroup().addContainerGap().addComponent(this.laDiagram).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.cbSecondGraph).addContainerGap()));
        this.tabbedPane.addTab("_ExerciseViewer", this.paExerciseViewer);
        this.btOK.setText("_OK");
        this.btOK.setName("btOK");
        this.btCancel.setText("_Cancel");
        this.btCancel.setName("btCancel");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.tabbedPane, GroupLayout.Alignment.LEADING, -1, 343, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.btCancel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btOK))).addContainerGap()));
        layout.linkSize(0, this.btCancel, this.btOK);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.tabbedPane, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED, -1, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.btOK).addComponent(this.btCancel)).addContainerGap()));
        this.pack();
    }

    private class AutoCalculationComboBoxItem {
        private STOptions.AutoCalculation autoCalculation;
        private String text;

        public AutoCalculationComboBoxItem(STOptions.AutoCalculation autoCalculation, String text) {
            this.autoCalculation = autoCalculation;
            this.text = text;
        }

        public STOptions.AutoCalculation getAutoCalculation() {
            return this.autoCalculation;
        }

        public String toString() {
            return this.text;
        }
    }

    private class LAFComboBoxItem {
        private UIManager.LookAndFeelInfo lookAndFeelInfo;

        public LAFComboBoxItem(UIManager.LookAndFeelInfo lookAndFeelInfo) {
            this.lookAndFeelInfo = lookAndFeelInfo;
        }

        public UIManager.LookAndFeelInfo getLookAndFeelInfo() {
            return this.lookAndFeelInfo;
        }

        public String toString() {
            return this.lookAndFeelInfo.getName();
        }
    }
}

