/*
 * Decompiled with CFR 0.152.
 */
package de.saring.sportstracker.gui.views.calendarview;

import de.saring.exerciseviewer.core.EVException;
import de.saring.exerciseviewer.parser.ExerciseParserFactory;
import de.saring.sportstracker.data.Exercise;
import de.saring.sportstracker.gui.STContext;
import de.saring.sportstracker.gui.STController;
import de.saring.sportstracker.gui.views.calendarview.CalendarDay;
import de.saring.sportstracker.gui.views.calendarview.CalendarEntry;
import de.saring.sportstracker.gui.views.calendarview.CalendarWidget;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.TransferHandler;

public class HrmDndTransferHandler
extends TransferHandler {
    private static final Logger LOGGER = Logger.getLogger(HrmDndTransferHandler.class.getName());
    private STContext context;
    private STController controller;
    private CalendarWidget calendarWidget;

    public HrmDndTransferHandler(STContext context, STController controller, CalendarWidget calendarWidget) {
        this.context = context;
        this.controller = controller;
        this.calendarWidget = calendarWidget;
    }

    @Override
    public boolean canImport(TransferHandler.TransferSupport support) {
        if (!support.isDrop()) {
            return false;
        }
        if (!this.isWindowsFileDragFlavor(support) && !this.isUnixFileDragFlavor(support)) {
            return false;
        }
        CalendarDay calDayTarget = this.calendarWidget.getCalendarDayForPoint(support.getDropLocation().getDropPoint());
        return calDayTarget != null;
    }

    @Override
    public boolean importData(TransferHandler.TransferSupport support) {
        if (!this.canImport(support)) {
            return false;
        }
        String dropFilename = this.getFileToDrop(support);
        if (dropFilename == null) {
            this.context.showMessageDialog(this.calendarWidget, 0, "common.error", "st.calview.draganddrop.invalid_hrm_file", new Object[0]);
            return false;
        }
        CalendarEntry calEntryToDrop = this.calendarWidget.getCalendarEntryForPoint(support.getDropLocation().getDropPoint());
        Exercise exerciseToDrop = null;
        if (calEntryToDrop != null && calEntryToDrop.isExercise()) {
            exerciseToDrop = (Exercise)calEntryToDrop.getEntry();
        }
        return this.controller.dropHrmFile(dropFilename, exerciseToDrop);
    }

    private boolean isWindowsFileDragFlavor(TransferHandler.TransferSupport support) {
        return support.isDataFlavorSupported(DataFlavor.javaFileListFlavor);
    }

    private boolean isUnixFileDragFlavor(TransferHandler.TransferSupport support) {
        return support.isDataFlavorSupported(DataFlavor.getTextPlainUnicodeFlavor());
    }

    private String getFileToDrop(TransferHandler.TransferSupport support) {
        List<File> fileList = null;
        Transferable transferable = support.getTransferable();
        if (this.isWindowsFileDragFlavor(support)) {
            fileList = this.getFileListForWindows(transferable);
        } else if (this.isUnixFileDragFlavor(support)) {
            fileList = this.getFileListForUnix(transferable);
        }
        if (fileList == null || fileList.size() != 1 || fileList.get(0).isDirectory()) {
            return null;
        }
        try {
            String dropFilename = fileList.get(0).getAbsolutePath();
            ExerciseParserFactory.getParser(dropFilename);
            return dropFilename;
        }
        catch (EVException eVException) {
            return null;
        }
    }

    private List<File> getFileListForWindows(Transferable transferable) {
        try {
            return (List)transferable.getTransferData(DataFlavor.javaFileListFlavor);
        }
        catch (UnsupportedFlavorException e) {
            LOGGER.log(Level.WARNING, "Failed to get the list of dragged files!", e);
            return null;
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "Failed to get the list of dragged files!", e);
            return null;
        }
    }

    private List<File> getFileListForUnix(Transferable transferable) {
        ArrayList<File> lFiles;
        block15: {
            lFiles = new ArrayList<File>();
            BufferedReader bReader = null;
            try {
                try {
                    DataFlavor textPlainFlavor = DataFlavor.getTextPlainUnicodeFlavor();
                    Reader reader = textPlainFlavor.getReaderForText(transferable);
                    bReader = new BufferedReader(reader);
                    String line = null;
                    while ((line = bReader.readLine()) != null) {
                        if ("0".equals(line)) continue;
                        lFiles.add(new File(new URI(line)));
                    }
                }
                catch (Exception e) {
                    LOGGER.log(Level.WARNING, "Failed to get the list of dragged files!", e);
                    if (bReader != null) {
                        try {
                            bReader.close();
                        }
                        catch (IOException iOException) {}
                    }
                    break block15;
                }
            }
            catch (Throwable throwable) {
                if (bReader != null) {
                    try {
                        bReader.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (bReader != null) {
                try {
                    bReader.close();
                }
                catch (IOException iOException) {}
            }
        }
        return lFiles;
    }
}

