/*
 * Decompiled with CFR 0.152.
 */
package de.saring.sportstracker.gui.views.listview;

import de.saring.sportstracker.core.STException;
import de.saring.sportstracker.core.STExceptionID;
import de.saring.sportstracker.gui.views.BaseView;
import de.saring.util.gui.ListUtils;
import de.saring.util.gui.TableCellRendererOddEven;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.print.PrinterException;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.standard.OrientationRequested;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;

public abstract class BaseListView
extends BaseView {
    private JScrollPane scrollPane;
    private JTable table;

    protected abstract String[] getColumnNames();

    protected abstract AbstractTableModel getTableModel();

    public final void createTable() {
        this.table = new JTable();
        this.table.setAutoCreateRowSorter(true);
        this.table.getTableHeader().setReorderingAllowed(false);
        this.scrollPane = new JScrollPane();
        this.scrollPane.setViewportView(this.table);
        this.setLayout(new BorderLayout());
        this.add((Component)this.scrollPane, "Center");
        AbstractTableModel tableModel = this.getTableModel();
        this.table.setModel(tableModel);
        tableModel.addTableModelListener(this.table);
        this.table.setSelectionMode(2);
        ListUtils.increaseTableRowHeight(this.table);
        this.table.getRowSorter().toggleSortOrder(0);
        this.table.getRowSorter().toggleSortOrder(0);
        DefaultTableCellRenderer cellRenderer = this.getTableCellRender();
        int i = 0;
        while (i < tableModel.getColumnCount()) {
            this.table.getColumnModel().getColumn(i).setCellRenderer(cellRenderer);
            ++i;
        }
        this.table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                BaseListView.this.getView().updateEntryActions();
            }
        });
        this.table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2 && BaseListView.this.table.getSelectedRowCount() == 1) {
                    BaseListView.this.getController().editEntry();
                }
            }
        });
    }

    protected final JTable getTable() {
        return this.table;
    }

    protected DefaultTableCellRenderer getTableCellRender() {
        return new BaseListCellRenderer();
    }

    @Override
    public void updateView() {
        this.getTableModel().fireTableDataChanged();
    }

    @Override
    public void removeSelection() {
        this.table.clearSelection();
    }

    protected void printList(String headerText, String footerText) throws STException {
        JTable.PrintMode printMode = JTable.PrintMode.FIT_WIDTH;
        HashPrintRequestAttributeSet praSet = new HashPrintRequestAttributeSet();
        praSet.add(OrientationRequested.LANDSCAPE);
        MessageFormat header = new MessageFormat(headerText);
        MessageFormat footer = new MessageFormat(String.valueOf(footerText) + " {0}");
        try {
            this.table.print(printMode, header, footer, true, praSet, true);
        }
        catch (PrinterException e) {
            throw new STException(STExceptionID.GUI_PRINT_VIEW_FAILED, "Failed to print the entry list view ...", e);
        }
    }

    public class BaseListCellRenderer
    extends TableCellRendererOddEven {
        private DateFormat dFormat;

        public BaseListCellRenderer() {
            super(BaseListView.this.getContext().getResReader().getColor("common.table.background_odd"), BaseListView.this.getContext().getResReader().getColor("common.table.background_even"));
            this.dFormat = SimpleDateFormat.getDateInstance(2);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int rowIndex, int vColIndex) {
            Component component = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, rowIndex, vColIndex);
            String text = this.formatText(value, rowIndex, vColIndex);
            this.setText(text);
            this.setToolTipText(text);
            return component;
        }

        protected String formatText(Object value, int rowIndex, int columnIndex) {
            if (value == null) {
                return "";
            }
            if (value instanceof Date) {
                return this.dFormat.format((Date)value);
            }
            return value.toString();
        }
    }

    public abstract class BaseListTableModel
    extends AbstractTableModel {
        @Override
        public String getColumnName(int col) {
            return BaseListView.this.getColumnNames()[col];
        }

        @Override
        public int getColumnCount() {
            return BaseListView.this.getColumnNames().length;
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return false;
        }
    }
}

