/*
 * Decompiled with CFR 0.152.
 */
package de.saring.sportstracker.gui.views.listview;

import de.saring.sportstracker.core.STException;
import de.saring.sportstracker.data.Note;
import de.saring.sportstracker.gui.views.listview.BaseListView;
import java.util.Date;
import javax.inject.Singleton;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumnModel;

@Singleton
public class NoteListView
extends BaseListView {
    private static final int COLUMN_COUNT = 2;
    private static final int COLUMN_DATE = 0;
    private static final int COLUMN_TEXT = 1;
    private static final int HIDDEN_COLUMN_ID = 2;
    private String[] columnNames;
    private NotesTableModel tmNotes;

    @Override
    public void initView() {
        this.columnNames = new String[2];
        this.columnNames[0] = this.getContext().getResReader().getString("st.notelistview.date", new Object[0]);
        this.columnNames[1] = this.getContext().getResReader().getString("st.notelistview.text", new Object[0]);
        this.tmNotes = new NotesTableModel();
        this.createTable();
        this.getTable().setAutoResizeMode(3);
        TableColumnModel tcModel = this.getTable().getColumnModel();
        tcModel.getColumn(0).setWidth(80);
        tcModel.getColumn(1).setPreferredWidth(600);
    }

    @Override
    protected String[] getColumnNames() {
        return this.columnNames;
    }

    @Override
    protected AbstractTableModel getTableModel() {
        return this.tmNotes;
    }

    @Override
    public int getSelectedNoteCount() {
        return this.getTable().getSelectedRowCount();
    }

    @Override
    public int[] getSelectedNoteIDs() {
        int[] selectedRows = this.getTable().getSelectedRows();
        int[] selectedIDs = new int[selectedRows.length];
        int i = 0;
        while (i < selectedIDs.length) {
            int modelRow = this.getTable().convertRowIndexToModel(selectedRows[i]);
            selectedIDs[i] = (Integer)this.tmNotes.getValueAt(modelRow, 2);
            ++i;
        }
        return selectedIDs;
    }

    @Override
    public void print() throws STException {
        if (!this.getController().checkForExistingNotes()) {
            return;
        }
        this.printList(this.getContext().getResReader().getString("st.notelistview.print.title", new Object[0]), this.getContext().getResReader().getString("st.notelistview.print.page", new Object[0]));
    }

    class NotesTableModel
    extends BaseListView.BaseListTableModel {
        NotesTableModel() {
            super(NoteListView.this);
        }

        @Override
        public int getRowCount() {
            return NoteListView.this.getDocument().getNoteList().size();
        }

        @Override
        public Class<?> getColumnClass(int col) {
            switch (col) {
                case 0: {
                    return Date.class;
                }
            }
            return Object.class;
        }

        @Override
        public Object getValueAt(int row, int col) {
            Note note = (Note)NoteListView.this.getDocument().getNoteList().getAt(row);
            switch (col) {
                case 0: {
                    return note.getDate();
                }
                case 1: {
                    return NoteListView.this.getContext().getFormatUtils().firstLineOfText(note.getText());
                }
                case 2: {
                    return note.getId();
                }
            }
            return null;
        }
    }
}

