/*
 * Decompiled with CFR 0.152.
 */
package de.saring.sportstracker.storage;

import de.saring.sportstracker.core.STException;
import de.saring.sportstracker.core.STExceptionID;
import de.saring.sportstracker.data.Equipment;
import de.saring.sportstracker.data.SportSubType;
import de.saring.sportstracker.data.SportType;
import de.saring.sportstracker.data.SportTypeList;
import de.saring.sportstracker.storage.XMLUtils;
import java.awt.Color;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.jdom.Attribute;
import org.jdom.Document;
import org.jdom.Element;

public class XMLSportTypeList {
    private static final String XSD_SPORT_TYPES = "sport-types.xsd";

    public SportTypeList readSportTypeList(String source) throws STException {
        try {
            SportTypeList sportTypeList = new SportTypeList();
            File fSource = new File(source);
            if (!fSource.exists()) {
                return sportTypeList;
            }
            Document document = XMLUtils.getJDOMDocument(fSource, XSD_SPORT_TYPES);
            Element eSportTypeList = document.getRootElement();
            List lSportTypes = eSportTypeList.getChildren("sport-type");
            for (Element eSportType : lSportTypes) {
                sportTypeList.set(this.readSportType(eSportType));
            }
            return sportTypeList;
        }
        catch (Exception e) {
            throw new STException(STExceptionID.XMLSTORAGE_READ_SPORT_TYPE_LIST, "Failed to read sport type list from XML file '" + source + "' ...", e);
        }
    }

    private SportType readSportType(Element eSportType) throws Exception {
        SportType sportType = new SportType(Integer.parseInt(eSportType.getChildText("id")));
        sportType.setName(eSportType.getChildText("name"));
        sportType.setIcon(eSportType.getChildText("icon"));
        Element eColor = eSportType.getChild("color");
        int iRed = eColor.getAttribute("red").getIntValue();
        int iGreen = eColor.getAttribute("green").getIntValue();
        int iBlue = eColor.getAttribute("blue").getIntValue();
        sportType.setColor(new Color(iRed, iGreen, iBlue));
        Attribute aRecDistance = eSportType.getAttribute("record-distance");
        if (aRecDistance != null) {
            sportType.setRecordDistance(aRecDistance.getBooleanValue());
        }
        Element eSportSubTypeList = eSportType.getChild("sport-subtype-list");
        List lSportSubTypes = eSportSubTypeList.getChildren("sport-subtype");
        for (Element eSportSubType : lSportSubTypes) {
            SportSubType sportSubType = new SportSubType(Integer.parseInt(eSportSubType.getChildText("id")));
            sportSubType.setName(eSportSubType.getChildText("name"));
            sportType.getSportSubTypeList().set(sportSubType);
        }
        Element eEquipmentList = eSportType.getChild("equipment-list");
        if (eEquipmentList != null) {
            List lEquipmentList = eEquipmentList.getChildren("equipment");
            for (Element eEquipment : lEquipmentList) {
                Equipment equipment = new Equipment(Integer.parseInt(eEquipment.getChildText("id")));
                equipment.setName(eEquipment.getChildText("name"));
                sportType.getEquipmentList().set(equipment);
            }
        }
        return sportType;
    }

    public void storeSportTypeList(SportTypeList sportTypeList, String destination) throws STException {
        Element eSportTypeList = this.createSportTypeListElement(sportTypeList);
        try {
            XMLUtils.writeXMLFile(eSportTypeList, destination);
        }
        catch (IOException e) {
            throw new STException(STExceptionID.XMLSTORAGE_STORE_SPORT_TYPE_LIST, "Failed to write sport type list to XML file '" + destination + "' ...", e);
        }
    }

    private Element createSportTypeListElement(SportTypeList sportTypeList) {
        Element eSportTypeList = new Element("sport-type-list");
        for (SportType sportType : sportTypeList) {
            Element eSportType = new Element("sport-type");
            eSportTypeList.addContent(eSportType);
            eSportType.setAttribute("record-distance", String.valueOf(sportType.isRecordDistance()));
            XMLUtils.addElement(eSportType, "id", String.valueOf(sportType.getId()));
            XMLUtils.addElement(eSportType, "name", sportType.getName());
            XMLUtils.addElement(eSportType, "icon", sportType.getIcon());
            Element eColor = new Element("color");
            eColor.setAttribute("red", String.valueOf(sportType.getColor().getRed()));
            eColor.setAttribute("green", String.valueOf(sportType.getColor().getGreen()));
            eColor.setAttribute("blue", String.valueOf(sportType.getColor().getBlue()));
            eSportType.addContent(eColor);
            Element eSportSubTypeList = new Element("sport-subtype-list");
            eSportType.addContent(eSportSubTypeList);
            for (SportSubType sportSubType : sportType.getSportSubTypeList()) {
                Element eSportSubType = new Element("sport-subtype");
                eSportSubTypeList.addContent(eSportSubType);
                XMLUtils.addElement(eSportSubType, "id", String.valueOf(sportSubType.getId()));
                XMLUtils.addElement(eSportSubType, "name", sportSubType.getName());
            }
            Element eEquipmentList = new Element("equipment-list");
            eSportType.addContent(eEquipmentList);
            for (Equipment equipment : sportType.getEquipmentList()) {
                Element eEquipment = new Element("equipment");
                eEquipmentList.addContent(eEquipment);
                XMLUtils.addElement(eEquipment, "id", String.valueOf(equipment.getId()));
                XMLUtils.addElement(eEquipment, "name", equipment.getName());
            }
        }
        return eSportTypeList;
    }
}

