/*
 * Decompiled with CFR 0.152.
 */
package de.saring.exerciseviewer.data;

import de.saring.exerciseviewer.data.ExerciseAltitude;
import de.saring.exerciseviewer.data.ExerciseCadence;
import de.saring.exerciseviewer.data.ExerciseSample;
import de.saring.exerciseviewer.data.ExerciseSpeed;
import de.saring.exerciseviewer.data.ExerciseTemperature;
import de.saring.exerciseviewer.data.HeartRateLimit;
import de.saring.exerciseviewer.data.Lap;
import de.saring.exerciseviewer.data.RecordingMode;
import java.io.Serializable;
import java.util.Date;

public final class EVExercise
implements Serializable {
    private ExerciseFileType fileType;
    private byte userID;
    private Date date;
    private byte type;
    private String typeLabel;
    private RecordingMode recordingMode;
    private int duration;
    private short recordingInterval;
    private short heartRateAVG;
    private short heartRateMax;
    private ExerciseSpeed speed;
    private ExerciseCadence cadence;
    private ExerciseAltitude altitude;
    private ExerciseTemperature temperature;
    private int energy;
    private int energyTotal;
    private int sumExerciseTime;
    private int sumRideTime;
    private int odometer;
    private HeartRateLimit[] heartRateLimits;
    private Lap[] lapList;
    private ExerciseSample[] sampleList;
    public static final short DYNAMIC_RECORDING_INTERVAL = -1;

    public ExerciseFileType getFileType() {
        return this.fileType;
    }

    public void setFileType(ExerciseFileType fileType) {
        this.fileType = fileType;
    }

    public byte getUserID() {
        return this.userID;
    }

    public void setUserID(byte userID) {
        this.userID = userID;
    }

    public Date getDate() {
        return this.date;
    }

    public void setDate(Date date) {
        this.date = date;
    }

    public byte getType() {
        return this.type;
    }

    public void setType(byte type) {
        this.type = type;
    }

    public String getTypeLabel() {
        return this.typeLabel;
    }

    public void setTypeLabel(String typeLabel) {
        this.typeLabel = typeLabel;
    }

    public RecordingMode getRecordingMode() {
        return this.recordingMode;
    }

    public void setRecordingMode(RecordingMode recordingMode) {
        this.recordingMode = recordingMode;
    }

    public int getDuration() {
        return this.duration;
    }

    public void setDuration(int duration) {
        this.duration = duration;
    }

    public short getRecordingInterval() {
        return this.recordingInterval;
    }

    public void setRecordingInterval(short recordingInterval) {
        this.recordingInterval = recordingInterval;
    }

    public short getHeartRateAVG() {
        return this.heartRateAVG;
    }

    public void setHeartRateAVG(short heartRateAVG) {
        this.heartRateAVG = heartRateAVG;
    }

    public short getHeartRateMax() {
        return this.heartRateMax;
    }

    public void setHeartRateMax(short heartRateMax) {
        this.heartRateMax = heartRateMax;
    }

    public ExerciseSpeed getSpeed() {
        return this.speed;
    }

    public void setSpeed(ExerciseSpeed speed) {
        this.speed = speed;
    }

    public ExerciseCadence getCadence() {
        return this.cadence;
    }

    public void setCadence(ExerciseCadence cadence) {
        this.cadence = cadence;
    }

    public ExerciseAltitude getAltitude() {
        return this.altitude;
    }

    public void setAltitude(ExerciseAltitude altitude) {
        this.altitude = altitude;
    }

    public ExerciseTemperature getTemperature() {
        return this.temperature;
    }

    public void setTemperature(ExerciseTemperature temperature) {
        this.temperature = temperature;
    }

    public int getEnergy() {
        return this.energy;
    }

    public void setEnergy(int energy) {
        this.energy = energy;
    }

    public int getEnergyTotal() {
        return this.energyTotal;
    }

    public void setEnergyTotal(int energyTotal) {
        this.energyTotal = energyTotal;
    }

    public int getSumExerciseTime() {
        return this.sumExerciseTime;
    }

    public void setSumExerciseTime(int sumExerciseTime) {
        this.sumExerciseTime = sumExerciseTime;
    }

    public int getSumRideTime() {
        return this.sumRideTime;
    }

    public void setSumRideTime(int sumRideTime) {
        this.sumRideTime = sumRideTime;
    }

    public int getOdometer() {
        return this.odometer;
    }

    public void setOdometer(int odometer) {
        this.odometer = odometer;
    }

    public HeartRateLimit[] getHeartRateLimits() {
        return this.heartRateLimits;
    }

    public void setHeartRateLimits(HeartRateLimit[] heartRateLimits) {
        this.heartRateLimits = heartRateLimits;
    }

    public Lap[] getLapList() {
        return this.lapList;
    }

    public void setLapList(Lap[] lapList) {
        this.lapList = lapList;
    }

    public ExerciseSample[] getSampleList() {
        return this.sampleList;
    }

    public void setSampleList(ExerciseSample[] sampleList) {
        this.sampleList = sampleList;
    }

    public void repairSamples() {
        if (this.speed == null || this.speed.getDistance() == 0 || this.sampleList == null || this.sampleList.length == 0) {
            return;
        }
        if (this.sampleList.length < this.duration / 10 / this.recordingInterval) {
            return;
        }
        ExerciseSample lastSample = this.sampleList[this.sampleList.length - 1];
        double fRelation = (double)lastSample.getDistance() / (double)this.speed.getDistance();
        ExerciseSample[] exerciseSampleArray = this.sampleList;
        int n = this.sampleList.length;
        int n2 = 0;
        while (n2 < n) {
            ExerciseSample sample = exerciseSampleArray[n2];
            sample.setDistance((int)Math.round((double)sample.getDistance() / fRelation));
            ++n2;
        }
    }

    public String toString() {
        int i;
        StringBuilder sBuilder = new StringBuilder();
        sBuilder.append(String.valueOf(EVExercise.class.getName()) + ":\n");
        sBuilder.append(" [fileType=" + (Object)((Object)this.fileType) + "\n");
        sBuilder.append("  userID=" + this.userID + "\n");
        sBuilder.append("  date=" + this.date + "\n");
        sBuilder.append("  type=" + this.type + "\n");
        sBuilder.append("  typeLabel=" + this.typeLabel + "\n");
        sBuilder.append("  duration=" + this.duration + "\n");
        sBuilder.append("  recordingInterval=" + this.recordingInterval + "\n");
        sBuilder.append("  heartRateAVG=" + this.heartRateAVG + "\n");
        sBuilder.append("  heartRateMax=" + this.heartRateMax + "\n");
        sBuilder.append("  energy=" + this.energy + "\n");
        sBuilder.append("  energyTotal=" + this.energyTotal + "\n");
        sBuilder.append("  sumExerciseTime=" + this.sumExerciseTime + "\n");
        sBuilder.append("  sumRideTime=" + this.sumRideTime + "\n");
        sBuilder.append("  odometer=" + this.odometer + "]\n");
        if (this.recordingMode != null) {
            sBuilder.append(this.recordingMode);
        }
        if (this.speed != null) {
            sBuilder.append(this.speed);
        }
        if (this.cadence != null) {
            sBuilder.append(this.cadence);
        }
        if (this.altitude != null) {
            sBuilder.append(this.altitude);
        }
        if (this.temperature != null) {
            sBuilder.append(this.temperature);
        }
        if (this.heartRateLimits != null) {
            i = 0;
            while (i < this.heartRateLimits.length) {
                sBuilder.append("arrayIndex " + i + ": ");
                sBuilder.append(this.heartRateLimits[i]);
                ++i;
            }
        }
        if (this.lapList != null) {
            i = 0;
            while (i < this.lapList.length) {
                sBuilder.append("arrayIndex " + i + ": ");
                sBuilder.append(this.lapList[i]);
                ++i;
            }
        }
        if (this.sampleList != null) {
            i = 0;
            while (i < this.sampleList.length) {
                sBuilder.append("arrayIndex " + i + ": ");
                sBuilder.append(this.sampleList[i]);
                ++i;
            }
        }
        return sBuilder.toString();
    }

    public static enum ExerciseFileType {
        S710RAW,
        S610RAW,
        S510RAW,
        HRM,
        HAC4TUR,
        RS200SDRAW,
        F6RAW,
        SSCSV,
        GARMIN_FIT,
        GARMIN_TCX,
        PED,
        TIMEX_PWX,
        GPX;

    }
}

