/*
 * Decompiled with CFR 0.152.
 */
package de.saring.exerciseviewer.parser;

import de.saring.exerciseviewer.core.EVException;
import de.saring.exerciseviewer.parser.ExerciseParser;
import de.saring.exerciseviewer.parser.ExerciseParserInfo;
import java.util.ArrayList;
import java.util.List;
import java.util.ServiceLoader;

public class ExerciseParserFactory {
    private static ExerciseParserFactory instance;
    ServiceLoader<ExerciseParser> exerciseParserLoader = ServiceLoader.load(ExerciseParser.class);

    private ExerciseParserFactory() {
    }

    public static ExerciseParser getParser(String filename) throws EVException {
        ExerciseParserFactory.createInstance();
        for (ExerciseParser parser : ExerciseParserFactory.instance.exerciseParserLoader) {
            String[] stringArray = parser.getInfo().getSuffixes();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String suffix = stringArray[n2];
                if (filename.endsWith("." + suffix)) {
                    return parser;
                }
                ++n2;
            }
        }
        throw new EVException("No parser has been found for filename '" + filename + "' ...");
    }

    public static List<ExerciseParserInfo> getExerciseParserInfos() {
        ExerciseParserFactory.createInstance();
        ArrayList<ExerciseParserInfo> lInfos = new ArrayList<ExerciseParserInfo>();
        for (ExerciseParser parser : ExerciseParserFactory.instance.exerciseParserLoader) {
            lInfos.add(parser.getInfo());
        }
        return lInfos;
    }

    private static synchronized void createInstance() {
        if (instance == null) {
            instance = new ExerciseParserFactory();
        }
    }
}

