/*
 * Decompiled with CFR 0.152.
 */
package de.saring.exerciseviewer.parser.impl;

import de.saring.exerciseviewer.core.EVException;
import de.saring.exerciseviewer.data.EVExercise;
import de.saring.exerciseviewer.data.ExerciseAltitude;
import de.saring.exerciseviewer.data.ExerciseCadence;
import de.saring.exerciseviewer.data.ExerciseSample;
import de.saring.exerciseviewer.data.ExerciseSpeed;
import de.saring.exerciseviewer.data.ExerciseTemperature;
import de.saring.exerciseviewer.data.HeartRateLimit;
import de.saring.exerciseviewer.data.Lap;
import de.saring.exerciseviewer.data.LapAltitude;
import de.saring.exerciseviewer.data.LapSpeed;
import de.saring.exerciseviewer.data.LapTemperature;
import de.saring.exerciseviewer.data.RecordingMode;
import de.saring.exerciseviewer.parser.AbstractExerciseParser;
import de.saring.exerciseviewer.parser.ExerciseParserInfo;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;

public class HAC4TURParser
extends AbstractExerciseParser {
    private final ExerciseParserInfo info = new ExerciseParserInfo("HACTronic", new String[]{"tur", "TUR"});
    private static final String VERSION_HEADER_STRING = "HACtronic - Tour";
    private String[] fileContents;
    private int[] fileContentsBytes;
    private int nrOfLinesInNote;
    private int sampleInterval;

    @Override
    public ExerciseParserInfo getInfo() {
        return this.info;
    }

    @Override
    public EVExercise parseExercise(String filename) throws EVException {
        this.fileContents = this.readFileToStringArray(filename);
        this.fileContentsBytes = this.readFileToByteArray(filename);
        EVExercise exercise = new EVExercise();
        exercise.setFileType(EVExercise.ExerciseFileType.HAC4TUR);
        String strVersion = this.fileContents[0];
        if (strVersion == null || !strVersion.equals(VERSION_HEADER_STRING)) {
            throw new EVException("Failed to read HAC4 TUR File. Can't find correct header in file");
        }
        this.nrOfLinesInNote = this.readInteger(9);
        RecordingMode recMode = new RecordingMode();
        exercise.setRecordingMode(recMode);
        recMode.setSpeed((double)this.readFloat(15 + this.nrOfLinesInNote) > 0.0);
        recMode.setAltitude(true);
        recMode.setPower(false);
        recMode.setTemperature(true);
        String strDateAndTime = String.valueOf(this.readLine(7)) + "-" + this.readLine(8);
        try {
            exercise.setDate(new SimpleDateFormat("dd.MM.yyy-HH:mm").parse(strDateAndTime));
        }
        catch (Exception e) {
            throw new EVException("Failed to read exercise date and time from string '" + strDateAndTime + "'...", e);
        }
        exercise.setDuration(this.readInteger(11 + this.nrOfLinesInNote) * 10);
        exercise.setHeartRateAVG((short)Math.round(this.readFloat(19 + this.nrOfLinesInNote)));
        exercise.setOdometer(this.readInteger(39 + this.nrOfLinesInNote));
        exercise.setSumExerciseTime(this.readInteger(40 + this.nrOfLinesInNote) / 60);
        this.sampleInterval = this.readSampleInterval(54 + this.nrOfLinesInNote);
        exercise.setRecordingInterval((short)this.sampleInterval);
        exercise.setSampleList(this.readSamples(53 + this.nrOfLinesInNote, 54 + this.nrOfLinesInNote));
        exercise.setAltitude(this.calculateAltitudes(exercise));
        exercise.setCadence(this.calculateCadence(exercise));
        recMode.setCadence(exercise.getCadence().getCadenceMax() > 0);
        exercise.setSpeed(this.calculateSpeed(exercise));
        exercise.setTemperature(this.calculateTemperature(exercise));
        exercise.setHeartRateLimits(new HeartRateLimit[1]);
        exercise.getHeartRateLimits()[0] = this.calculateHeartRate(exercise);
        exercise.setLapList(this.getLaps(exercise));
        return exercise;
    }

    private ExerciseAltitude calculateAltitudes(EVExercise exercise) {
        int min = Integer.MAX_VALUE;
        int max = Integer.MIN_VALUE;
        int ascent = 0;
        long total = 0L;
        short prevAlt = Short.MAX_VALUE;
        ExerciseSample[] exerciseSampleArray = exercise.getSampleList();
        int n = exerciseSampleArray.length;
        int n2 = 0;
        while (n2 < n) {
            ExerciseSample sample = exerciseSampleArray[n2];
            short alt = sample.getAltitude();
            min = Math.min(alt, min);
            max = Math.max(alt, max);
            if (alt > prevAlt) {
                ascent += alt - prevAlt;
            }
            prevAlt = alt;
            total += (long)alt;
            ++n2;
        }
        ExerciseAltitude ea = new ExerciseAltitude();
        ea.setAltitudeMin((short)min);
        ea.setAltitudeMax((short)max);
        ea.setAltitudeAVG((short)(total / (long)exercise.getSampleList().length));
        ea.setAscent(ascent);
        return ea;
    }

    private ExerciseCadence calculateCadence(EVExercise exercise) {
        int maximum = Integer.MIN_VALUE;
        long total = 0L;
        ExerciseSample[] exerciseSampleArray = exercise.getSampleList();
        int n = exerciseSampleArray.length;
        int n2 = 0;
        while (n2 < n) {
            ExerciseSample sample = exerciseSampleArray[n2];
            short cadence = sample.getCadence();
            maximum = Math.max(cadence, maximum);
            total += (long)cadence;
            ++n2;
        }
        ExerciseCadence ec = new ExerciseCadence();
        ec.setCadenceMax((short)maximum);
        ec.setCadenceAVG((short)(total / (long)exercise.getSampleList().length));
        return ec;
    }

    private ExerciseSpeed calculateSpeed(EVExercise exercise) {
        float max = Float.MIN_VALUE;
        int nrMovingIntervals = 0;
        float speedAVG = 0.0f;
        int previousDistance = 0;
        ExerciseSample[] exerciseSampleArray = exercise.getSampleList();
        int n = exerciseSampleArray.length;
        int n2 = 0;
        while (n2 < n) {
            ExerciseSample sample = exerciseSampleArray[n2];
            if (sample.getDistance() > previousDistance) {
                speedAVG += (sample.getSpeed() - speedAVG) / (float)(++nrMovingIntervals);
            }
            max = Math.max(max, sample.getSpeed());
            previousDistance = sample.getDistance();
            ++n2;
        }
        ExerciseSpeed es = new ExerciseSpeed();
        int sampleCount = exercise.getSampleList().length;
        es.setDistance(exercise.getSampleList()[sampleCount - 1].getDistance());
        es.setSpeedAVG(speedAVG);
        es.setSpeedMax(max);
        return es;
    }

    private ExerciseTemperature calculateTemperature(EVExercise exercise) {
        int min = Integer.MAX_VALUE;
        int max = Integer.MIN_VALUE;
        long total = 0L;
        ExerciseSample[] exerciseSampleArray = exercise.getSampleList();
        int n = exerciseSampleArray.length;
        int n2 = 0;
        while (n2 < n) {
            ExerciseSample sample = exerciseSampleArray[n2];
            min = Math.min(min, sample.getTemperature());
            max = Math.max(max, sample.getTemperature());
            total += (long)sample.getTemperature();
            ++n2;
        }
        ExerciseTemperature et = new ExerciseTemperature();
        et.setTemperatureMax((short)max);
        et.setTemperatureMin((short)min);
        et.setTemperatureAVG((short)(total / (long)exercise.getSampleList().length));
        return et;
    }

    private HeartRateLimit calculateHeartRate(EVExercise exercise) throws EVException {
        short upper = (short)this.readInteger(35 + this.nrOfLinesInNote);
        short lower = (short)this.readInteger(36 + this.nrOfLinesInNote);
        int max = Integer.MIN_VALUE;
        int intervalsBelow = 0;
        int intervalsBetween = 0;
        int intervalsAbove = 0;
        ExerciseSample[] exerciseSampleArray = exercise.getSampleList();
        int n = exerciseSampleArray.length;
        int n2 = 0;
        while (n2 < n) {
            ExerciseSample sample = exerciseSampleArray[n2];
            short hr = sample.getHeartRate();
            max = Math.max(max, hr);
            if (hr < lower) {
                ++intervalsBelow;
            } else if (hr >= lower && hr <= upper) {
                ++intervalsBetween;
            } else {
                ++intervalsAbove;
            }
            ++n2;
        }
        exercise.setHeartRateMax((short)max);
        HeartRateLimit hrl = new HeartRateLimit();
        hrl.setLowerHeartRate(lower);
        hrl.setUpperHeartRate(upper);
        hrl.setTimeBelow(intervalsBelow * this.sampleInterval);
        hrl.setTimeWithin(intervalsBetween * this.sampleInterval);
        hrl.setTimeAbove(intervalsAbove * this.sampleInterval);
        return hrl;
    }

    private Lap[] getLaps(EVExercise exercise) {
        ExerciseSample lastSample = exercise.getSampleList()[exercise.getSampleList().length - 1];
        Lap lap = new Lap();
        lap.setTimeSplit(exercise.getDuration());
        lap.setHeartRateSplit(lastSample.getHeartRate());
        lap.setHeartRateMax(exercise.getHeartRateMax());
        lap.setHeartRateAVG(exercise.getHeartRateAVG());
        lap.setAltitude(new LapAltitude());
        lap.getAltitude().setAltitude(lastSample.getAltitude());
        lap.getAltitude().setAscent(exercise.getAltitude().getAscent());
        lap.setSpeed(new LapSpeed());
        lap.getSpeed().setCadence(lastSample.getCadence());
        lap.getSpeed().setDistance(exercise.getSpeed().getDistance());
        lap.getSpeed().setSpeedEnd(lastSample.getSpeed());
        lap.getSpeed().setSpeedAVG(exercise.getSpeed().getSpeedAVG());
        lap.setTemperature(new LapTemperature());
        lap.getTemperature().setTemperature(lastSample.getTemperature());
        return new Lap[]{lap};
    }

    private int readSampleInterval(int fpBeginSamples) throws EVException {
        int lengthUntilSamples = 0;
        int i = 0;
        while (i < fpBeginSamples) {
            lengthUntilSamples += this.fileContents[i].length() + 1;
            ++i;
        }
        int[] firstSampleBytes = Arrays.copyOfRange(this.fileContentsBytes, lengthUntilSamples, lengthUntilSamples + 20);
        int[] secondSampleBytes = Arrays.copyOfRange(this.fileContentsBytes, lengthUntilSamples + 20, lengthUntilSamples + 40);
        Sample firstSample = new Sample(firstSampleBytes);
        Sample secondSample = new Sample(secondSampleBytes);
        return (int)(secondSample.getTime() - firstSample.getTime());
    }

    private ExerciseSample[] readSamples(int fpNrSamples, int fpBeginSamples) throws EVException {
        int nrSamples = this.readInteger(fpNrSamples);
        int lengthUntilSamples = 0;
        int i = 0;
        while (i < fpBeginSamples) {
            lengthUntilSamples += this.fileContents[i].length() + 1;
            ++i;
        }
        ArrayList<Sample> samples = new ArrayList<Sample>();
        int i2 = 0;
        while (i2 < nrSamples) {
            int startFrom = lengthUntilSamples + i2 * 20;
            int[] sampleBytes = Arrays.copyOfRange(this.fileContentsBytes, startFrom, startFrom + 20);
            samples.add(new Sample(sampleBytes));
            ++i2;
        }
        ExerciseSample[] eSamples = new ExerciseSample[nrSamples];
        int previousDistance = 0;
        long firstTimestamp = nrSamples > 0 ? ((Sample)samples.get(0)).getTime() : 0L;
        int i3 = 0;
        while (i3 < nrSamples) {
            Sample sample = (Sample)samples.get(i3);
            eSamples[i3] = new ExerciseSample();
            eSamples[i3].setTimestamp((sample.getTime() - firstTimestamp) * 1000L);
            eSamples[i3].setHeartRate((short)sample.getHeartRate());
            eSamples[i3].setAltitude((short)sample.getAltitude());
            eSamples[i3].setCadence((short)sample.getCadence());
            int distanceDiff = sample.getDistance() - previousDistance;
            previousDistance = sample.getDistance();
            eSamples[i3].setDistance(sample.getDistance() * 10);
            eSamples[i3].setSpeed((float)distanceDiff / (float)this.sampleInterval * 3.6f * 10.0f);
            eSamples[i3].setTemperature((short)sample.getTemperature());
            ++i3;
        }
        return eSamples;
    }

    private float readFloat(int pos) throws EVException {
        try {
            return Float.parseFloat(this.readLine(pos));
        }
        catch (Exception e) {
            throw new EVException("Invalid value for float at position " + pos, e);
        }
    }

    private int readInteger(int pos) throws EVException {
        try {
            return Integer.parseInt(this.readLine(pos));
        }
        catch (Exception e) {
            throw new EVException("Invalid value for integer at position " + pos, e);
        }
    }

    private String readLine(int pos) {
        return this.fileContents[pos];
    }

    private static interface FilePosition {
        public static final int VERSION_HEADER = 0;
        public static final int START_DATE = 7;
        public static final int START_TIME = 8;
        public static final int NR_OF_LINES_IN_NOTE = 9;
        public static final int DURATION = 11;
        public static final int AVERAGE_SPEED = 15;
        public static final int AVERAGE_HEART_RATE = 19;
        public static final int HR_LIMIT_UPPER = 35;
        public static final int HR_LIMIT_LOWER = 36;
        public static final int ODOMETER = 39;
        public static final int TOTAL_EXERCISE_TIME = 40;
        public static final int NR_SAMPLES = 53;
        public static final int BEGIN_SAMPLES = 54;
    }

    private class Sample {
        private int[] contents = new int[20];
        private int distance = 0;
        private int altitude;
        private int heartRate;
        private int cadence;
        private int temperature;
        private long time;

        public Sample(int[] contents) throws EVException {
            if (contents.length != 20) {
                throw new EVException("Length of a sample should be 20 bytes!");
            }
            this.contents = contents;
            this.initializeValues();
        }

        public int getDistance() {
            return this.distance;
        }

        public int getAltitude() {
            return this.altitude;
        }

        public int getHeartRate() {
            return this.heartRate;
        }

        public int getCadence() {
            return this.cadence;
        }

        public long getTime() {
            return this.time;
        }

        public int getTemperature() {
            return this.temperature;
        }

        private void initializeValues() {
            this.distance = this.calculateDistance();
            this.altitude = this.calculateAltitude();
            this.heartRate = this.calculateHeartRate();
            this.cadence = this.calculateCadence();
            this.temperature = this.calculateTemperature();
            this.time = this.calculateTime();
        }

        private long calculateTime() {
            int[] timeBytes = Arrays.copyOfRange(this.contents, 0, 4);
            return (timeBytes[0] & 0xFF) + (timeBytes[1] << 8 & 0xFF00) + (timeBytes[2] << 16 & 0xFF0000) + (timeBytes[3] << 24 & 0xFF000000);
        }

        private int calculateDistance() {
            int[] distanceBytes = Arrays.copyOfRange(this.contents, 8, 12);
            int distance = 0;
            int theByte = 0;
            while (theByte < distanceBytes.length) {
                distance += distanceBytes[theByte] * (int)Math.pow(2.0, theByte * 8);
                ++theByte;
            }
            return distance;
        }

        private int calculateAltitude() {
            int[] altitudeBytes = Arrays.copyOfRange(this.contents, 12, 14);
            int altitude = 0;
            int theByte = 0;
            while (theByte < altitudeBytes.length) {
                altitude += altitudeBytes[theByte] * (int)Math.pow(2.0, theByte * 8);
                ++theByte;
            }
            return altitude;
        }

        private int calculateHeartRate() {
            return this.contents[14];
        }

        private int calculateCadence() {
            return this.contents[15];
        }

        private int calculateTemperature() {
            return this.contents[16];
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("distance = " + this.distance + ", ");
            builder.append("altitude = " + this.altitude + ", ");
            builder.append("HR = " + this.heartRate + ", ");
            builder.append("Cadence = " + this.cadence + ", ");
            builder.append("Temp = " + this.temperature + ", ");
            builder.append("Time (seconds) = " + this.time + ", ");
            return builder.toString();
        }
    }
}

