/*
 * Decompiled with CFR 0.152.
 */
package de.saring.exerciseviewer.parser.impl;

import de.saring.exerciseviewer.core.EVException;
import de.saring.exerciseviewer.data.EVExercise;
import de.saring.exerciseviewer.data.ExerciseAltitude;
import de.saring.exerciseviewer.data.ExerciseSample;
import de.saring.exerciseviewer.data.ExerciseSpeed;
import de.saring.exerciseviewer.data.HeartRateLimit;
import de.saring.exerciseviewer.data.Lap;
import de.saring.exerciseviewer.data.LapAltitude;
import de.saring.exerciseviewer.data.LapSpeed;
import de.saring.exerciseviewer.data.LapTemperature;
import de.saring.exerciseviewer.data.Position;
import de.saring.exerciseviewer.data.RecordingMode;
import de.saring.exerciseviewer.parser.AbstractExerciseParser;
import de.saring.exerciseviewer.parser.ExerciseParserInfo;
import java.text.SimpleDateFormat;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TimexPwxParser
extends AbstractExerciseParser {
    private final ExerciseParserInfo info = new ExerciseParserInfo("Timex PWX", new String[]{"pwx", "PWX"});
    int[][] s;

    private MinMaxAvg Node2MinMaxAvg(Node inNode) {
        MinMaxAvg result = new MinMaxAvg();
        NamedNodeMap attributes = inNode.getAttributes();
        int i = 0;
        while (i < attributes.getLength()) {
            if (attributes.item(i).getNodeName().equals("max")) {
                result.setMax(Float.valueOf(attributes.item(i).getTextContent()).floatValue());
            } else if (attributes.item(i).getNodeName().equals("min")) {
                result.setMin(Float.valueOf(attributes.item(i).getTextContent()).floatValue());
            } else if (attributes.item(i).getNodeName().equals("avg")) {
                result.setAvg(Float.valueOf(attributes.item(i).getTextContent()).floatValue());
            }
            ++i;
        }
        return result;
    }

    @Override
    public ExerciseParserInfo getInfo() {
        return this.info;
    }

    public int countNodeItems(Node node, String string2count) {
        NodeList children = node.getChildNodes();
        int numChildren = children.getLength();
        String currentNodeName = null;
        int numMatches = 0;
        int i = 0;
        while (i < numChildren) {
            currentNodeName = children.item(i).getNodeName();
            if (currentNodeName.equals(string2count)) {
                ++numMatches;
            }
            ++i;
        }
        return numMatches;
    }

    private EVExercise parseWorkoutNode(EVExercise exercise, Node workoutNode) {
        NodeList children = workoutNode.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            String childName = children.item(i).getNodeName();
            if (!childName.equals("athlete") && !childName.equals("goal")) {
                if (childName.equals("sportType")) {
                    exercise.setType((byte)0);
                    exercise.setTypeLabel(children.item(i).getTextContent());
                } else if (!childName.equals("cmt") && !childName.equals("code")) {
                    if (childName.equals("device")) {
                        exercise = this.parseWorkoutDeviceNode(exercise, children.item(i));
                    } else if (childName.equals("time")) {
                        try {
                            exercise.setDate(new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss").parse(children.item(i).getTextContent()));
                        }
                        catch (Exception exception) {
                            exercise.setDate(null);
                        }
                    } else if (childName.equals("summarydata")) {
                        SummaryData workoutSummary = this.parseSummaryData(children.item(i));
                        exercise.setDuration((int)workoutSummary.getDuration() * 10);
                        exercise.setSumExerciseTime((int)workoutSummary.getDuration() / 60);
                        exercise.setSumRideTime((int)workoutSummary.getDuration() / 60);
                        exercise.setEnergy((int)((double)workoutSummary.getWork() * 0.23884589662749595));
                        exercise.setHeartRateMax((short)workoutSummary.getHr().getMax());
                        exercise.setHeartRateAVG((short)workoutSummary.getHr().getAvg());
                        exercise.setOdometer((int)workoutSummary.getDistance() / 1000);
                        if (workoutSummary.getSpeed() != null) {
                            ExerciseSpeed workoutSpeed = new ExerciseSpeed();
                            workoutSpeed.setDistance((int)workoutSummary.getDistance());
                            workoutSpeed.setSpeedAVG(workoutSummary.getSpeed().getAvg() * 3.6f);
                            workoutSpeed.setSpeedMax(workoutSummary.getSpeed().getMax() * 3.6f);
                            exercise.setSpeed(workoutSpeed);
                        }
                        if (workoutSummary.getAltitude() != null) {
                            ExerciseAltitude workoutAltitude = new ExerciseAltitude();
                            workoutAltitude.setAltitudeAVG((short)workoutSummary.getAltitude().getAvg());
                            workoutAltitude.setAltitudeMax((short)workoutSummary.getAltitude().getMax());
                            workoutAltitude.setAltitudeMin((short)workoutSummary.getAltitude().getMin());
                            exercise.setAltitude(workoutAltitude);
                        }
                    } else if (!childName.equals("segment") && !childName.equals("sample") && childName.equals("extension")) {
                        exercise = this.parseWorkoutExtensionNode(exercise, children.item(i));
                    }
                }
            }
            ++i;
        }
        exercise = this.parseWorkoutSegments(exercise, workoutNode);
        exercise = this.parseWorkoutSamples(exercise, workoutNode);
        return exercise;
    }

    private EVExercise parseWorkoutExtensionNode(EVExercise exercise, Node workoutExtensionNode) {
        NodeList children = workoutExtensionNode.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            String childName = children.item(i).getNodeName();
            if (childName.equals("laps")) {
                exercise.setLapList(new Lap[Integer.valueOf(children.item(i).getTextContent()).intValue()]);
            } else if (childName.equals("ascent")) {
                exercise.getAltitude().setAscent(Integer.valueOf(children.item(i).getTextContent()));
            } else if (!childName.equals("descent")) {
                childName.equals("points");
            }
            ++i;
        }
        return exercise;
    }

    private EVExercise parseWorkoutDeviceNode(EVExercise exercise, Node deviceNode) {
        NodeList children = deviceNode.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            String childName = children.item(i).getNodeName();
            if (childName.equals("extension")) {
                exercise = this.parseDeviceExtensionNode(exercise, children.item(i));
            } else if (!childName.equals("make")) {
                if (childName.equals("model")) {
                    if (children.item(i).getTextContent().equals("Global Trainer")) {
                        exercise = this.setGlobalTrainerRecordingMode(exercise);
                        exercise = this.setGlobalTrainerZones(exercise);
                    }
                } else if (!childName.equals("stopdetectionsetting")) {
                    childName.equals("elevationchangesetting");
                }
            }
            ++i;
        }
        return exercise;
    }

    private EVExercise setGlobalTrainerRecordingMode(EVExercise exercise) {
        RecordingMode recMode = new RecordingMode();
        recMode.setPower(true);
        recMode.setLocation(true);
        recMode.setCadence(false);
        recMode.setAltitude(true);
        recMode.setSpeed(true);
        recMode.setBikeNumber((byte)0);
        recMode.setIntervalExercise(false);
        exercise.setRecordingMode(recMode);
        return exercise;
    }

    private EVExercise setGlobalTrainerZones(EVExercise exercise) {
        HeartRateLimit[] Zones = new HeartRateLimit[6];
        int i = 0;
        while (i < 6) {
            Zones[i] = new HeartRateLimit();
            Zones[i].setUpperHeartRate((short)(50 + (i + 1) * 25));
            Zones[i].setLowerHeartRate((short)(50 + i * 25));
            Zones[i].setAbsoluteRange(true);
            Zones[i].setTimeAbove(0);
            Zones[i].setTimeBelow(0);
            Zones[i].setTimeWithin(0);
            ++i;
        }
        exercise.setHeartRateLimits(new HeartRateLimit[6]);
        System.arraycopy(Zones, 0, exercise.getHeartRateLimits(), 0, 6);
        return exercise;
    }

    private EVExercise parseDeviceExtensionNode(EVExercise exercise, Node deviceExtensionNode) {
        NodeList children = deviceExtensionNode.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            String childName = children.item(i).getNodeName();
            if (childName.equals("settings")) {
                exercise = this.parseDeviceExtensionSettingsNode(exercise, children.item(i));
            } else {
                childName.equals("stoppage");
            }
            ++i;
        }
        return exercise;
    }

    private EVExercise parseDeviceExtensionSettingsNode(EVExercise exercise, Node deviceExtensionSettingsNode) {
        NodeList children = deviceExtensionSettingsNode.getChildNodes();
        HeartRateLimit[] Zones = new HeartRateLimit[6];
        int i = 0;
        while (i < 6) {
            Zones[i] = new HeartRateLimit();
            Zones[i].setUpperHeartRate((short)0);
            Zones[i].setLowerHeartRate((short)0);
            Zones[i].setAbsoluteRange(true);
            Zones[i].setTimeAbove(0);
            Zones[i].setTimeBelow(0);
            Zones[i].setTimeWithin(0);
            ++i;
        }
        i = 0;
        while (i < children.getLength()) {
            String childName = children.item(i).getNodeName();
            if (childName.equals("CHRMaxHR") || childName.equals("HRMMaxHR")) {
                short HRMMaxHR = Short.valueOf(children.item(i).getTextContent());
                double[] HRZonesPercentages = new double[]{1.0, 0.9, 0.8, 0.7, 0.6, 0.5};
                int k = 0;
                while (k < 5) {
                    Zones[k] = new HeartRateLimit();
                    Zones[k].setUpperHeartRate((short)(HRZonesPercentages[k] * (double)HRMMaxHR));
                    Zones[k].setLowerHeartRate((short)(1.0 + HRZonesPercentages[k + 1] * (double)HRMMaxHR));
                    Zones[k].setAbsoluteRange(true);
                    Zones[k].setTimeAbove(0);
                    Zones[k].setTimeBelow(0);
                    Zones[k].setTimeWithin(0);
                    ++k;
                }
            } else if (childName.equals("CHRManualZoneHigherLimit") || childName.equals("HRMBpmManHi")) {
                Zones[5].setUpperHeartRate(Short.valueOf(children.item(i).getTextContent()));
            } else if (childName.equals("CHRManualZoneLowerLimit") || childName.equals("HRMBpmManLo")) {
                Zones[5].setLowerHeartRate(Short.valueOf(children.item(i).getTextContent()));
            } else if (!childName.equals("HasHRMData")) {
                if (childName.equals("TotalNumberOfLaps")) {
                    exercise.setLapList(new Lap[Integer.valueOf(children.item(i).getTextContent()).intValue()]);
                } else if (childName.equals("KCalPerDevice")) {
                    exercise.setEnergyTotal(Integer.valueOf(children.item(i).getTextContent()));
                } else if (childName.equals("WorkoutType")) {
                    children.item(i).getTextContent().equals("Chrono");
                }
            }
            ++i;
        }
        RecordingMode recMode = new RecordingMode();
        recMode.setPower(false);
        recMode.setCadence(false);
        recMode.setAltitude(false);
        recMode.setSpeed(false);
        recMode.setBikeNumber((byte)0);
        recMode.setIntervalExercise(false);
        exercise.setRecordingMode(recMode);
        exercise.setHeartRateLimits(new HeartRateLimit[6]);
        System.arraycopy(Zones, 0, exercise.getHeartRateLimits(), 0, 6);
        return exercise;
    }

    private SummaryData parseSummaryData(Node summaryDataNode) {
        SummaryData nodeSummaryData = new SummaryData();
        NodeList children = summaryDataNode.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            String childName = children.item(i).getNodeName();
            if (childName.equals("beginning")) {
                nodeSummaryData.setBeginning(Double.valueOf(children.item(i).getTextContent()));
            } else if (childName.equals("duration")) {
                nodeSummaryData.setDuration(Double.valueOf(children.item(i).getTextContent()));
            } else if (childName.equals("hr")) {
                nodeSummaryData.setHr(this.Node2MinMaxAvg(children.item(i)));
            } else if (childName.equals("work")) {
                nodeSummaryData.setWork(Integer.valueOf(children.item(i).getTextContent()));
            } else if (childName.equals("spd")) {
                nodeSummaryData.setSpeed(this.Node2MinMaxAvg(children.item(i)));
            } else if (childName.equals("alt")) {
                nodeSummaryData.setAltitude(this.Node2MinMaxAvg(children.item(i)));
            } else if (childName.equals("dist")) {
                nodeSummaryData.setDistance(Float.valueOf(children.item(i).getTextContent()).floatValue());
            }
            ++i;
        }
        return nodeSummaryData;
    }

    private EVExercise parseWorkoutSegments(EVExercise exercise, Node workoutNode) {
        int totalLaps = exercise.getLapList().length;
        int currentLap = 0;
        NodeList children = workoutNode.getChildNodes();
        NodeList segmentChildren = null;
        float runningDistance = 0.0f;
        int i = 0;
        while (i < children.getLength()) {
            String childName = children.item(i).getNodeName();
            if (childName.equals("segment")) {
                segmentChildren = children.item(i).getChildNodes();
                Lap lap = new Lap();
                LapAltitude lapAlt = new LapAltitude();
                LapSpeed lapSpd = new LapSpeed();
                LapTemperature lapTmp = new LapTemperature();
                lapAlt.setAscent(0);
                lapAlt.setAltitude((short)0);
                lap.setAltitude(lapAlt);
                lapSpd.setCadence((short)0);
                lapSpd.setDistance(402);
                lapSpd.setSpeedAVG(0.0f);
                lapSpd.setSpeedEnd(0.0f);
                lap.setSpeed(lapSpd);
                lapTmp.setTemperature((short)25);
                lap.setTemperature(lapTmp);
                lap.setHeartRateSplit((short)0);
                lap.setHeartRateMax((short)0);
                int j = 0;
                while (j < segmentChildren.getLength()) {
                    childName = segmentChildren.item(j).getNodeName();
                    if (childName.equals("summarydata")) {
                        SummaryData segmentSummary = this.parseSummaryData(segmentChildren.item(j));
                        lap.setTimeSplit((int)((segmentSummary.getDuration() + segmentSummary.getBeginning()) * 10.0));
                        if (segmentSummary.getDistance() != 0.0f) {
                            lapSpd.setDistance((int)(runningDistance += segmentSummary.getDistance()));
                            lapSpd.setSpeedAVG((float)(3.6 * (double)segmentSummary.getDistance() / segmentSummary.getDuration()));
                            lapSpd.setSpeedEnd(0.0f);
                        } else {
                            runningDistance = (float)((double)runningDistance + 402.336);
                            lapSpd.setDistance((int)runningDistance);
                            lapSpd.setSpeedAVG((float)(1448.4096000000002 / segmentSummary.getDuration()));
                            lapSpd.setSpeedEnd(0.0f);
                        }
                        lap.setSpeed(lapSpd);
                        lap.setHeartRateAVG((short)segmentSummary.getHr().getAvg());
                        lap.setHeartRateMax((short)segmentSummary.getHr().getMax());
                        if (segmentSummary.getAltitude() != null) {
                            lapAlt.setAltitude((short)segmentSummary.getAltitude().getMax());
                            lapAlt.setAscent((int)(segmentSummary.getAltitude().getMax() - segmentSummary.getAltitude().getMin()));
                            lap.setAltitude(lapAlt);
                        }
                    }
                    ++j;
                }
                if (currentLap < totalLaps) {
                    exercise.getLapList()[currentLap++] = lap;
                }
            }
            ++i;
        }
        return exercise;
    }

    public static float getDistanceFromPositions(Position startPosition, Position stopPosition) {
        double earthRadius = 6369.6;
        double dLat = Math.toRadians(stopPosition.getLatitude() - startPosition.getLatitude());
        double dLng = Math.toRadians(stopPosition.getLongitude() - startPosition.getLongitude());
        double a = Math.sin(dLat / 2.0) * Math.sin(dLat / 2.0) + Math.cos(Math.toRadians(startPosition.getLatitude())) * Math.cos(Math.toRadians(stopPosition.getLatitude())) * Math.sin(dLng / 2.0) * Math.sin(dLng / 2.0);
        double c = 2.0 * Math.atan2(Math.sqrt(a), Math.sqrt(1.0 - a));
        double dist = earthRadius * c;
        int meterConversion = 1000;
        if (dist < 0.0) {
            dist = 0.0 - dist;
        }
        return (float)(dist * (double)meterConversion);
    }

    private EVExercise parseWorkoutSamples(EVExercise exercise, Node workoutNode) {
        int totalSamples = this.countNodeItems(workoutNode, "sample");
        int currentSampleNumber = 0;
        float lastDistance = 0.0f;
        boolean distanceinsample = false;
        boolean firstsample = true;
        exercise.setSampleList(new ExerciseSample[totalSamples]);
        double lastOffset = 0.0;
        double currentOffset = 0.0;
        Position lastPosition = new Position(0.0, 0.0);
        NodeList children = workoutNode.getChildNodes();
        NodeList sampleChildren = null;
        ExerciseSample lastSample = new ExerciseSample();
        Double latitude = 0.0;
        Double longitude = 0.0;
        double[] belowZone = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
        double[] inZone = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
        double[] aboveZone = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0};
        int istop = children.getLength();
        int i = 0;
        while (i < istop) {
            String childName = children.item(i).getNodeName();
            if (childName.equals("sample")) {
                ExerciseSample sample = new ExerciseSample();
                sampleChildren = children.item(i).getChildNodes();
                int jstop = sampleChildren.getLength();
                int j = 0;
                while (j < jstop) {
                    childName = sampleChildren.item(j).getNodeName();
                    if (childName.equals("timeoffset")) {
                        if (currentOffset != 0.0) {
                            lastOffset = currentOffset;
                        }
                        currentOffset = Double.valueOf(sampleChildren.item(j).getTextContent());
                        sample.setTimestamp((long)(1000.0 * currentOffset));
                    } else if (childName.equals("hr")) {
                        sample.setHeartRate(Short.valueOf(sampleChildren.item(j).getTextContent()));
                    } else if (childName.equals("spd")) {
                        sample.setSpeed(3.6f * Float.valueOf(sampleChildren.item(j).getTextContent()).floatValue());
                    } else if (!childName.equals("pwr") && !childName.equals("torq")) {
                        if (childName.equals("cad")) {
                            sample.setCadence(Short.valueOf(sampleChildren.item(j).getTextContent()));
                            exercise.getRecordingMode().setCadence(true);
                        } else if (childName.equals("dist")) {
                            sample.setDistance(Integer.valueOf(sampleChildren.item(j).getTextContent()));
                            distanceinsample = true;
                        } else if (childName.equals("lat")) {
                            latitude = (double)Double.valueOf(sampleChildren.item(j).getTextContent());
                        } else if (childName.equals("lon")) {
                            longitude = (double)Double.valueOf(sampleChildren.item(j).getTextContent());
                        } else if (childName.equals("alt")) {
                            sample.setAltitude(Float.valueOf(sampleChildren.item(j).getTextContent()).shortValue());
                        } else if (childName.equals("temp")) {
                            sample.setTemperature(Float.valueOf(sampleChildren.item(j).getTextContent()).shortValue());
                        } else {
                            childName.equals("time");
                        }
                    }
                    ++j;
                }
                sample.setPosition(new Position(latitude, longitude));
                if (firstsample) {
                    lastPosition = sample.getPosition();
                    firstsample = false;
                }
                if (!distanceinsample) {
                    sample.setDistance((int)(lastDistance += TimexPwxParser.getDistanceFromPositions(lastPosition, sample.getPosition())));
                    lastPosition = sample.getPosition();
                }
                if (sample.getHeartRate() == 0) {
                    sample.setHeartRate(lastSample.getHeartRate());
                } else {
                    lastSample.setHeartRate(sample.getHeartRate());
                }
                exercise.getSampleList()[currentSampleNumber++] = sample;
                j = 0;
                while (j < 6) {
                    if (sample.getHeartRate() > exercise.getHeartRateLimits()[j].getUpperHeartRate()) {
                        int n = j;
                        aboveZone[n] = aboveZone[n] + (currentOffset - lastOffset);
                    } else if (sample.getHeartRate() < exercise.getHeartRateLimits()[j].getLowerHeartRate()) {
                        int n = j;
                        belowZone[n] = belowZone[n] + (currentOffset - lastOffset);
                    } else {
                        int n = j;
                        inZone[n] = inZone[n] + (currentOffset - lastOffset);
                    }
                    ++j;
                }
            }
            ++i;
        }
        i = 0;
        while (i < 6) {
            exercise.getHeartRateLimits()[i].setTimeAbove((short)aboveZone[i]);
            exercise.getHeartRateLimits()[i].setTimeBelow((short)belowZone[i]);
            exercise.getHeartRateLimits()[i].setTimeWithin((short)inZone[i]);
            ++i;
        }
        exercise.setRecordingInterval((short)2);
        return exercise;
    }

    private Node findFirstPwx(Document doc) {
        NodeList rootNodeList = doc.getChildNodes();
        int i = 0;
        while (i < rootNodeList.getLength()) {
            if (rootNodeList.item(i).getNodeName().equals("pwx")) {
                return rootNodeList.item(i);
            }
            ++i;
        }
        return null;
    }

    @Override
    public EVExercise parseExercise(String filename) throws EVException {
        EVExercise exercise = new EVExercise();
        exercise.setFileType(EVExercise.ExerciseFileType.TIMEX_PWX);
        DocumentBuilderFactory dbf = null;
        DocumentBuilder db = null;
        Document doc = null;
        Node root = null;
        NodeList children = null;
        try {
            dbf = DocumentBuilderFactory.newInstance();
            db = dbf.newDocumentBuilder();
            doc = db.parse(filename);
            root = this.findFirstPwx(doc);
        }
        catch (Exception e) {
            throw new EVException("Failed to open pwx exercise file '" + filename + "' ...", e);
        }
        if (root == null) {
            throw new EVException("Failed to find a pwx node in file '" + filename + "'");
        }
        exercise.setFileType(EVExercise.ExerciseFileType.TIMEX_PWX);
        children = root.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            if (children.item(i).getNodeName().equals("workout")) {
                exercise = this.parseWorkoutNode(exercise, children.item(i));
            }
            ++i;
        }
        return exercise;
    }

    private class MinMaxAvg {
        private float min = 0.0f;
        private float max = 0.0f;
        private float avg = 0.0f;

        private MinMaxAvg() {
        }

        public void setMin(float in) {
            this.min = in;
        }

        public float getMin() {
            return this.min;
        }

        public void setMax(float in) {
            this.max = in;
        }

        public float getMax() {
            return this.max;
        }

        public void setAvg(float in) {
            this.avg = in;
        }

        public float getAvg() {
            return this.avg;
        }
    }

    private class SummaryData {
        private double beginning = 0.0;
        private double duration = 0.0;
        private int work = 0;
        private MinMaxAvg hr;
        private MinMaxAvg speed;
        private float distance = 0.0f;
        private MinMaxAvg altitude;

        private SummaryData() {
        }

        public void setBeginning(double in) {
            this.beginning = in;
        }

        public double getBeginning() {
            return this.beginning;
        }

        public void setDuration(double in) {
            this.duration = in;
        }

        public double getDuration() {
            return this.duration;
        }

        public void setWork(int in) {
            this.work = in;
        }

        public int getWork() {
            return this.work;
        }

        public void setHr(MinMaxAvg in) {
            this.hr = in;
        }

        public MinMaxAvg getHr() {
            return this.hr;
        }

        public void setSpeed(MinMaxAvg in) {
            this.speed = in;
        }

        public MinMaxAvg getSpeed() {
            return this.speed;
        }

        public void setDistance(float in) {
            this.distance = in;
        }

        public float getDistance() {
            return this.distance;
        }

        public void setAltitude(MinMaxAvg in) {
            this.altitude = in;
        }

        public MinMaxAvg getAltitude() {
            return this.altitude;
        }
    }
}

