/*
 * Decompiled with CFR 0.152.
 */
package de.saring.exerciseviewer.parser.impl.garminfit;

import com.garmin.fit.Decode;
import com.garmin.fit.MesgListener;
import de.saring.exerciseviewer.core.EVException;
import de.saring.exerciseviewer.data.EVExercise;
import de.saring.exerciseviewer.parser.AbstractExerciseParser;
import de.saring.exerciseviewer.parser.ExerciseParserInfo;
import de.saring.exerciseviewer.parser.impl.garminfit.FitMessageListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

public class GarminFitParser
extends AbstractExerciseParser {
    private final ExerciseParserInfo info = new ExerciseParserInfo("Garmin FIT", new String[]{"fit", "FIT"});

    @Override
    public ExerciseParserInfo getInfo() {
        return this.info;
    }

    @Override
    public EVExercise parseExercise(String filename) throws EVException {
        FitMessageListener mesgListener = new FitMessageListener();
        this.readFitFile(filename, mesgListener);
        return mesgListener.getExercise();
    }

    private void readFitFile(String filename, MesgListener mesgListener) throws EVException {
        FileInputStream fis = null;
        try {
            try {
                fis = new FileInputStream(new File(filename));
                new Decode().read((InputStream)fis, mesgListener);
            }
            catch (IOException ioe) {
                throw new EVException("Failed to read FIT file '" + filename + "'...", ioe);
            }
        }
        catch (Throwable throwable) {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException iOException) {}
            }
            throw throwable;
        }
        if (fis != null) {
            try {
                fis.close();
            }
            catch (IOException iOException) {}
        }
    }
}

