/*
 * Decompiled with CFR 0.152.
 */
package com.garmin.fit;

import com.garmin.fit.CRC;
import com.garmin.fit.Factory;
import com.garmin.fit.Field;
import com.garmin.fit.FieldComponent;
import com.garmin.fit.FieldDefinition;
import com.garmin.fit.Fit;
import com.garmin.fit.FitRuntimeException;
import com.garmin.fit.Mesg;
import com.garmin.fit.MesgDefinition;
import com.garmin.fit.MesgDefinitionListener;
import com.garmin.fit.MesgListener;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;

public class Decode {
    private STATE state;
    private byte fileHdrOffset = 0;
    private byte fileHdrSize;
    private long fileDataSize;
    private long fileBytesLeft = 3L;
    private int crc = 0;
    private Mesg mesg;
    private int localMesgIndex;
    private MesgDefinition[] localMesgDefs = new MesgDefinition[16];
    private int numFields;
    private int fieldIndex;
    private int fieldDataIndex;
    private int fieldBytesLeft;
    private byte[] fieldData = new byte[255];
    private int lastTimeOffset = 0;
    private long timestamp;
    private long systemTimeOffset = 0L;
    private Accumulator accumulator = new Accumulator();
    private boolean pause = false;
    private InputStream in;
    private ArrayList<MesgListener> mesgListeners = new ArrayList();
    private ArrayList<MesgDefinitionListener> mesgDefListeners = new ArrayList();

    public Decode() {
        this.state = STATE.FILE_HDR;
        if (Fit.debug) {
            System.out.printf("Fit.Decode: Starting decode...\n", new Object[0]);
        }
    }

    public void addListener(MesgListener mesgListener) {
        if (mesgListener != null && !this.mesgListeners.contains(mesgListener)) {
            this.mesgListeners.add(mesgListener);
        }
    }

    public void addListener(MesgDefinitionListener mesgDefinitionListener) {
        if (mesgDefinitionListener != null && !this.mesgDefListeners.contains(mesgDefinitionListener)) {
            this.mesgDefListeners.add(mesgDefinitionListener);
        }
    }

    public void setSystemTimeOffset(long l) {
        this.systemTimeOffset = l;
    }

    public boolean read(InputStream inputStream, MesgListener mesgListener) {
        this.addListener(mesgListener);
        return this.read(inputStream);
    }

    public boolean read(InputStream inputStream) {
        this.in = inputStream;
        return this.resume();
    }

    public void pause() {
        this.pause = true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean resume() {
        this.pause = false;
        try {
            int n;
            block8: while ((n = this.in.read()) >= 0) {
                if (this.pause) {
                    return false;
                }
                RETURN rETURN = this.read((byte)n);
                switch (rETURN) {
                    case CONTINUE: {
                        continue block8;
                    }
                    case MESG: {
                        for (Object object : this.mesgListeners) {
                            object.onMesg(this.mesg);
                        }
                        continue block8;
                    }
                    case MESG_DEF: {
                        for (Object object : this.mesgDefListeners) {
                            object.onMesgDefinition(this.localMesgDefs[this.localMesgIndex]);
                        }
                        continue block8;
                    }
                    case END_OF_FILE: {
                        return true;
                    }
                }
                throw new FitRuntimeException("FIT decode error: " + (Object)((Object)rETURN));
            }
            throw new FitRuntimeException("FIT decode error: Unexpected end of input stream.");
        }
        catch (IOException iOException) {
            throw new FitRuntimeException(iOException);
        }
    }

    public static boolean isFit(InputStream inputStream) {
        Decode decode = new Decode();
        try {
            int n;
            while ((n = inputStream.read()) >= 0) {
                switch (decode.read((byte)n)) {
                    case CONTINUE: 
                    case MESG: 
                    case MESG_DEF: {
                        break;
                    }
                    case END_OF_FILE: {
                        return true;
                    }
                    default: {
                        return false;
                    }
                }
                if (decode.state == STATE.FILE_HDR) continue;
                return true;
            }
        }
        catch (IOException iOException) {
            throw new FitRuntimeException(iOException);
        }
        catch (FitRuntimeException fitRuntimeException) {
            // empty catch block
        }
        return false;
    }

    public static boolean checkIntegrity(InputStream inputStream) {
        Decode decode = new Decode();
        try {
            int n;
            block7: while ((n = inputStream.read()) >= 0) {
                switch (decode.read((byte)n)) {
                    case CONTINUE: 
                    case MESG: 
                    case MESG_DEF: {
                        continue block7;
                    }
                    case END_OF_FILE: {
                        return true;
                    }
                }
                return false;
            }
        }
        catch (IOException iOException) {
            throw new FitRuntimeException(iOException);
        }
        catch (FitRuntimeException fitRuntimeException) {
            // empty catch block
        }
        return false;
    }

    public RETURN read(byte by) {
        if (Fit.debug) {
            if (this.fileBytesLeft == 2L) {
                System.out.printf("Fit.Decode: Expecting next 2 bytes to be end of file CRC = 0x%04X\n", this.crc);
            }
            System.out.printf("Fit.Decode: 0x%02X - %s\n", by & 0xFF, this.state.toString());
        }
        if (this.fileBytesLeft > 0L) {
            this.crc = CRC.get16(this.crc, by);
            --this.fileBytesLeft;
            if (this.fileBytesLeft == 1L) {
                if (this.state != STATE.RECORD) {
                    throw new FitRuntimeException("FIT decode error: Decoder not in correct state after last data byte in file.  Check message definitions.");
                }
                return RETURN.CONTINUE;
            }
            if (this.fileBytesLeft == 0L) {
                if (this.crc != 0) {
                    throw new FitRuntimeException("FIT decode error: File CRC failed.");
                }
                return RETURN.END_OF_FILE;
            }
        }
        switch (this.state) {
            case FILE_HDR: {
                byte by2 = this.fileHdrOffset;
                this.fileHdrOffset = (byte)(by2 + 1);
                switch (by2) {
                    case 0: {
                        this.fileHdrSize = by;
                        this.fileBytesLeft = this.fileHdrSize + 2;
                        break;
                    }
                    case 1: {
                        if ((by & 0xF0) <= 16) break;
                        throw new FitRuntimeException("FIT decode error: Protocol version " + ((by & 0xF0) >> 4) + "." + (by & 0xF) + " not supported.  Must be " + 1 + ".15 or earlier.");
                    }
                    case 4: {
                        this.fileDataSize = by & 0xFF;
                        break;
                    }
                    case 5: {
                        this.fileDataSize |= (long)(by & 0xFF) << 8;
                        break;
                    }
                    case 6: {
                        this.fileDataSize |= (long)(by & 0xFF) << 16;
                        break;
                    }
                    case 7: {
                        this.fileDataSize |= (long)(by & 0xFF) << 24;
                        break;
                    }
                    case 8: {
                        if (by == 46) break;
                        throw new FitRuntimeException("FIT decode error: File is not FIT format.  Check file header data type.");
                    }
                    case 9: {
                        if (by == 70) break;
                        throw new FitRuntimeException("FIT decode error: File is not FIT format.  Check file header data type.");
                    }
                    case 10: {
                        if (by == 73) break;
                        throw new FitRuntimeException("FIT decode error: File is not FIT format.  Check file header data type.");
                    }
                    case 11: {
                        if (by == 84) break;
                        throw new FitRuntimeException("FIT decode error: File is not FIT format.  Check file header data type.");
                    }
                }
                if (this.fileHdrOffset != this.fileHdrSize) break;
                this.fileBytesLeft = this.fileDataSize + 2L;
                this.state = STATE.RECORD;
                break;
            }
            case RECORD: {
                this.fieldIndex = 0;
                this.fieldBytesLeft = 0;
                if (this.fileBytesLeft > 1L) {
                    if ((by & 0x80) != 0) {
                        Field field = Factory.createField("record", "timestamp");
                        int n = by & 0x1F;
                        this.timestamp += (long)(n - this.lastTimeOffset & 0x1F);
                        this.lastTimeOffset = n;
                        field.setValue(this.timestamp);
                        this.localMesgIndex = (by & 0x60) >> 5;
                        if (this.localMesgDefs[this.localMesgIndex] == null) {
                            throw new FitRuntimeException("FIT decode error: Missing message definition for local message number " + this.localMesgIndex + ".");
                        }
                        this.mesg = Factory.createMesg(this.localMesgDefs[this.localMesgIndex].num);
                        this.mesg.localNum = this.localMesgIndex;
                        this.mesg.systemTimeOffset = this.systemTimeOffset;
                        this.mesg.addField(field);
                        if (this.localMesgDefs[this.localMesgIndex].fields.size() == 0) {
                            return RETURN.MESG;
                        }
                        this.state = STATE.FIELD_DATA;
                        break;
                    }
                    this.localMesgIndex = by & 0xF;
                    if ((by & 0x40) != 0) {
                        this.localMesgDefs[this.localMesgIndex] = new MesgDefinition();
                        this.localMesgDefs[this.localMesgIndex].localNum = this.localMesgIndex;
                        this.state = STATE.RESERVED1;
                        break;
                    }
                    if (this.localMesgDefs[this.localMesgIndex] == null) {
                        throw new FitRuntimeException("FIT decode error: Missing message definition for local message number " + this.localMesgIndex + ".");
                    }
                    this.mesg = Factory.createMesg(this.localMesgDefs[this.localMesgIndex].num);
                    this.mesg.localNum = this.localMesgIndex;
                    this.mesg.systemTimeOffset = this.systemTimeOffset;
                    if (this.localMesgDefs[this.localMesgIndex].fields.size() == 0) {
                        return RETURN.MESG;
                    }
                    this.state = STATE.FIELD_DATA;
                    break;
                }
                this.state = STATE.FILE_CRC_HIGH;
                break;
            }
            case RESERVED1: {
                this.state = STATE.ARCH;
                break;
            }
            case ARCH: {
                this.localMesgDefs[this.localMesgIndex].arch = by & 0xFF;
                this.state = STATE.MESG_NUM_0;
                break;
            }
            case MESG_NUM_0: {
                this.localMesgDefs[this.localMesgIndex].num = by & 0xFF;
                this.state = STATE.MESG_NUM_1;
                break;
            }
            case MESG_NUM_1: {
                this.localMesgDefs[this.localMesgIndex].num |= (by & 0xFF) << 8;
                if (this.localMesgDefs[this.localMesgIndex].arch == 1) {
                    this.localMesgDefs[this.localMesgIndex].num = this.localMesgDefs[this.localMesgIndex].num >> 8 | (this.localMesgDefs[this.localMesgIndex].num & 0xFF) << 8;
                } else if (this.localMesgDefs[this.localMesgIndex].arch != 0) {
                    throw new FitRuntimeException("FIT decode error: Endian " + this.localMesgDefs[this.localMesgIndex].arch + " not supported.");
                }
                this.state = STATE.NUM_FIELDS;
                break;
            }
            case NUM_FIELDS: {
                this.numFields = by & 0xFF;
                if (this.numFields == 0) {
                    this.state = STATE.RECORD;
                    break;
                }
                this.state = STATE.FIELD_NUM;
                break;
            }
            case FIELD_NUM: {
                this.localMesgDefs[this.localMesgIndex].fields.add(new FieldDefinition());
                this.localMesgDefs[this.localMesgIndex].fields.get((int)this.fieldIndex).num = by & 0xFF;
                this.state = STATE.FIELD_SIZE;
                break;
            }
            case FIELD_SIZE: {
                this.localMesgDefs[this.localMesgIndex].fields.get((int)this.fieldIndex).size = by & 0xFF;
                this.state = STATE.FIELD_TYPE;
                break;
            }
            case FIELD_TYPE: {
                this.localMesgDefs[this.localMesgIndex].fields.get((int)this.fieldIndex).type = by & 0xFF;
                if (++this.fieldIndex >= this.numFields) {
                    this.state = STATE.RECORD;
                    return RETURN.MESG_DEF;
                }
                this.state = STATE.FIELD_NUM;
                break;
            }
            case FIELD_DATA: {
                FieldDefinition fieldDefinition = this.localMesgDefs[this.localMesgIndex].fields.get(this.fieldIndex);
                if (this.fieldBytesLeft == 0) {
                    this.fieldDataIndex = 0;
                    this.fieldBytesLeft = fieldDefinition.size;
                }
                this.fieldData[this.fieldDataIndex++] = by;
                --this.fieldBytesLeft;
                if (this.fieldBytesLeft != 0) break;
                if ((fieldDefinition.type & 0x1F) < 14) {
                    Field field;
                    int n;
                    int n2;
                    int n3 = Fit.baseTypeSizes[fieldDefinition.type & 0x1F];
                    int n4 = fieldDefinition.size / n3;
                    if ((fieldDefinition.type & 0x80) != 0 && (this.localMesgDefs[this.localMesgIndex].arch & 1) != 1) {
                        for (n2 = 0; n2 < n4; ++n2) {
                            for (n = 0; n < n3 / 2; ++n) {
                                byte by3 = this.fieldData[n2 * n3 + n];
                                this.fieldData[n2 * n3 + n] = this.fieldData[n2 * n3 + n3 - n - 1];
                                this.fieldData[n2 * n3 + n3 - n - 1] = by3;
                            }
                        }
                    }
                    if ((field = Factory.createField(this.mesg.num, fieldDefinition.num)) != null) {
                        Long l;
                        field.read(new ByteArrayInputStream(this.fieldData), fieldDefinition.size);
                        if (fieldDefinition.num == 253 && (l = field.getLongValue()) != null) {
                            this.timestamp = l;
                            this.lastTimeOffset = (int)(this.timestamp & 0x1FL);
                        }
                        if (field.getNumValues() > 0) {
                            if (field.components.size() > 0) {
                                n2 = 0;
                                for (n = 0; n < field.components.size(); ++n) {
                                    FieldComponent fieldComponent = field.components.get(n);
                                    if (fieldComponent.fieldNum != 255) {
                                        Field field2 = Factory.createField(this.mesg.num, fieldComponent.fieldNum);
                                        Long l2 = field.getBitsValue(n2, fieldComponent.bits, field2.isSignedInteger());
                                        if (l2 == null) break;
                                        if (fieldComponent.accumulate) {
                                            l2 = this.accumulator.accumulate(this.mesg.num, field.num, n, l2, fieldComponent.bits);
                                        }
                                        Double d = ((double)l2.longValue() / fieldComponent.scale - fieldComponent.offset + field2.offset) * field2.scale;
                                        if (this.mesg.hasField(field2.num)) {
                                            this.mesg.getField(field2.num).addValue(d);
                                        } else {
                                            field2.addValue(d);
                                            this.mesg.addField(field2);
                                        }
                                    }
                                    n2 += fieldComponent.bits;
                                }
                            }
                            this.mesg.addField(field);
                        }
                    }
                }
                ++this.fieldIndex;
                if (this.fieldIndex < this.localMesgDefs[this.localMesgIndex].fields.size()) break;
                Factory.mapSubFields(this.mesg);
                this.state = STATE.RECORD;
                return RETURN.MESG;
            }
        }
        return RETURN.CONTINUE;
    }

    public Mesg getMesg() {
        return this.mesg;
    }

    private class Accumulator {
        ArrayList<AccumulatedField> fields = new ArrayList();

        Accumulator() {
        }

        public long accumulate(int n, int n2, int n3, long l, int n4) {
            int n5;
            AccumulatedField accumulatedField = null;
            for (n5 = 0; n5 < this.fields.size(); ++n5) {
                accumulatedField = this.fields.get(n5);
                if (accumulatedField.mesgNum == n && accumulatedField.fieldNum == n2 && accumulatedField.componentNum == n3) break;
            }
            if (n5 == this.fields.size()) {
                accumulatedField = new AccumulatedField(n, n2, n3);
                this.fields.add(accumulatedField);
            }
            return accumulatedField.accumulate(l, n4);
        }
    }

    private class AccumulatedField {
        int mesgNum;
        int fieldNum;
        int componentNum;
        long lastValue;
        long accumulatedValue;

        AccumulatedField(int n, int n2, int n3) {
            this.mesgNum = n;
            this.fieldNum = n2;
            this.componentNum = n3;
            this.lastValue = 0L;
            this.accumulatedValue = 0L;
        }

        public long accumulate(long l, int n) {
            long l2 = (1L << n) - 1L;
            this.accumulatedValue += l - this.lastValue & l2;
            this.lastValue = l;
            return this.accumulatedValue;
        }
    }

    private static enum STATE {
        FILE_HDR,
        RECORD,
        RESERVED1,
        ARCH,
        MESG_NUM_0,
        MESG_NUM_1,
        NUM_FIELDS,
        FIELD_NUM,
        FIELD_SIZE,
        FIELD_TYPE,
        FIELD_DATA,
        FILE_CRC_HIGH;

    }

    public static enum RETURN {
        CONTINUE,
        MESG,
        MESG_DEF,
        END_OF_FILE;

    }
}

