/*
 * Decompiled with CFR 0.152.
 */
package com.garmin.fit;

import com.garmin.fit.Field;
import com.garmin.fit.FieldDefinition;
import com.garmin.fit.FitRuntimeException;
import com.garmin.fit.Mesg;
import com.garmin.fit.MesgNum;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;

public class MesgDefinition {
    protected int num;
    protected int localNum;
    protected int arch;
    protected ArrayList<FieldDefinition> fields;

    protected MesgDefinition() {
        this.num = MesgNum.INVALID;
        this.localNum = 0;
        this.arch = 1;
        this.fields = new ArrayList();
    }

    public MesgDefinition(Mesg mesg) {
        this.num = mesg.num;
        this.localNum = mesg.localNum;
        this.arch = 1;
        if (this.localNum >= 16) {
            throw new FitRuntimeException("Invalid local message number " + this.localNum + ".  Local message number must be < " + 16 + ".");
        }
        this.fields = new ArrayList();
        for (Field field : mesg.fields) {
            this.fields.add(new FieldDefinition(field));
        }
    }

    public int getNum() {
        return this.num;
    }

    public int getLocalNum() {
        return this.localNum;
    }

    public int getArch() {
        return this.arch;
    }

    public ArrayList<FieldDefinition> getFields() {
        return this.fields;
    }

    public int write(DataOutput dataOutput) {
        int n = 6;
        try {
            dataOutput.writeByte(0x40 | this.localNum & 0xF);
            dataOutput.writeByte(0);
            dataOutput.writeByte(1);
            dataOutput.writeShort(this.num);
            dataOutput.writeByte(this.fields.size());
        }
        catch (IOException iOException) {
            return 0;
        }
        for (FieldDefinition fieldDefinition : this.fields) {
            int n2 = fieldDefinition.write(dataOutput);
            if (n2 == 0) {
                return 0;
            }
            n += n2;
        }
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof MesgDefinition)) {
            return false;
        }
        MesgDefinition mesgDefinition = (MesgDefinition)object;
        if (this.num != mesgDefinition.num) {
            return false;
        }
        if (this.localNum != mesgDefinition.localNum) {
            return false;
        }
        return this.fields.equals(mesgDefinition.fields);
    }

    public int hashCode() {
        int n = 1;
        n = n * 31 + new Integer(this.num).hashCode();
        n = n * 47 + new Integer(this.localNum).hashCode();
        n = n * 19 + this.fields.hashCode();
        return n;
    }
}

