/*
 * Decompiled with CFR 0.152.
 */
package devplugin;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.RandomAccessFile;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Locale;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import tvbrowser.core.Settings;
import util.ui.Localizer;

public class Date
implements Comparable<Date> {
    private static Localizer LOCALIZER = Localizer.getLocalizerFor(Date.class);
    private static final Logger LOGGER = Logger.getLogger(Date.class.getName());
    private static final HashMap<Integer, String> LONG_DATE_MAP = new HashMap(28);
    private static final byte DATE_CACHE_SIZE = 50;
    private short mYear;
    private byte mMonth;
    private byte mDay;

    public Date() {
        Calendar mCalendar = Calendar.getInstance();
        this.mYear = (short)mCalendar.get(1);
        this.mMonth = (byte)(mCalendar.get(2) + 1);
        this.mDay = (byte)mCalendar.get(5);
    }

    public Date(short year, byte month, byte dayOfMonth) {
        this.mYear = year;
        this.mMonth = month;
        this.mDay = dayOfMonth;
    }

    public Date(int year, int month, int dayOfMonth) {
        this.mYear = (short)year;
        this.mMonth = (byte)month;
        this.mDay = (byte)dayOfMonth;
    }

    public Date(Calendar cal) {
        this.mYear = (short)cal.get(1);
        this.mMonth = (byte)(cal.get(2) + 1);
        this.mDay = (byte)cal.get(5);
    }

    public Date(Date d) {
        this.mYear = d.mYear;
        this.mMonth = d.mMonth;
        this.mDay = d.mDay;
    }

    @Deprecated
    public Date(DataInput in) throws IOException, ClassNotFoundException {
        int version = in.readInt();
        if (version == 1) {
            int date = in.readInt();
            long l = (long)date * 24L * 60L * 60L * 1000L;
            java.util.Date d = new java.util.Date(l);
            Calendar mCalendar = Calendar.getInstance();
            mCalendar.setTime(d);
            this.mYear = (short)mCalendar.get(1);
            this.mMonth = (byte)(mCalendar.get(2) + 1);
            this.mDay = (byte)mCalendar.get(5);
        } else if (version == 2) {
            this.mYear = (short)in.readInt();
            this.mMonth = (byte)in.readInt();
            this.mDay = (byte)in.readInt();
        } else {
            this.mYear = in.readShort();
            this.mMonth = in.readByte();
            this.mDay = in.readByte();
        }
    }

    @Deprecated
    public Date(ObjectInputStream in) throws IOException, ClassNotFoundException {
        int version = in.readInt();
        if (version == 1) {
            int date = in.readInt();
            long l = (long)date * 24L * 60L * 60L * 1000L;
            java.util.Date d = new java.util.Date(l);
            Calendar mCalendar = Calendar.getInstance();
            mCalendar.setTime(d);
            this.mYear = (short)mCalendar.get(1);
            this.mMonth = (byte)(mCalendar.get(2) + 1);
            this.mDay = (byte)mCalendar.get(5);
        } else if (version == 2) {
            this.mYear = (short)in.readInt();
            this.mMonth = (byte)in.readInt();
            this.mDay = (byte)in.readInt();
        } else {
            this.mYear = in.readShort();
            this.mMonth = in.readByte();
            this.mDay = in.readByte();
        }
    }

    public static Date getCurrentDate() {
        return new Date();
    }

    public static Date createDateFromValue(long value) {
        short year = (short)(value / 10000L);
        byte month = (byte)(value % 10000L / 100L);
        byte day = (byte)(value % 100L);
        return new Date(year, month, day);
    }

    public static Date createYYYYMMDD(String date, String separator) {
        if (date == null) {
            return null;
        }
        String[] s = date.split(Pattern.quote(separator));
        if (s.length != 3) {
            return null;
        }
        try {
            short year = Short.parseShort(s[0]);
            byte month = Byte.parseByte(s[1]);
            byte day = Byte.parseByte(s[2]);
            return new Date(year, month, day);
        }
        catch (NumberFormatException e) {
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public static Date createDDMMYYYY(String date, String separator) {
        if (date == null) {
            return null;
        }
        String[] s = date.split(Pattern.quote(separator));
        if (s.length != 3) {
            return null;
        }
        try {
            short year = Short.parseShort(s[2]);
            byte month = Byte.parseByte(s[1]);
            byte day = Byte.parseByte(s[0]);
            return new Date(year, month, day);
        }
        catch (NumberFormatException e) {
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public static Date createYYMMDD(String date, String separator) {
        return Date.createYYYYMMDD("20" + date, separator);
    }

    public int getNumberOfDaysSince(Date date) {
        Calendar cal1 = date.getCalendar();
        java.util.Date utilDate1 = cal1.getTime();
        long millis1 = utilDate1.getTime();
        Calendar cal2 = this.getCalendar();
        java.util.Date utilDate2 = cal2.getTime();
        long millis2 = utilDate2.getTime();
        int hours = (int)((millis2 - millis1) / 1000L / 60L / 60L);
        if (hours % 24 > 1) {
            return (int)((double)hours / 24.0 + 0.99);
        }
        return (int)((millis2 - millis1) / 1000L / 60L / 60L / 24L);
    }

    public int getYear() {
        return this.mYear;
    }

    public int getMonth() {
        return this.mMonth;
    }

    public int getDayOfMonth() {
        return this.mDay;
    }

    public int getWeekOfYear() {
        Calendar cal = this.getCalendar();
        return cal.get(3);
    }

    public int getWeekOfYear(Locale locale) {
        Calendar cal = this.getCalendar(locale);
        return cal.get(3);
    }

    @Deprecated
    public void writeToDataFile(RandomAccessFile out) throws IOException {
        out.writeInt(3);
        out.writeShort(this.mYear);
        out.writeByte(this.mMonth);
        out.writeByte(this.mDay);
    }

    @Deprecated
    public void writeData(ObjectOutputStream out) throws IOException {
        out.writeInt(3);
        out.writeShort(this.mYear);
        out.writeByte(this.mMonth);
        out.writeByte(this.mDay);
    }

    public int hashCode() {
        return this.mYear * 10000 + this.mMonth * 100 + this.mDay;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Date) {
            Date d = (Date)obj;
            return d.getDayOfMonth() == this.getDayOfMonth() && d.getMonth() == this.getMonth() && d.getYear() == this.getYear();
        }
        return false;
    }

    public String getDateString() {
        return String.valueOf(this.getValue());
    }

    private String getFormattedString(boolean longDay, boolean longMonth) {
        Calendar cal = this.getCalendar();
        SimpleDateFormat day = new SimpleDateFormat(longDay ? "EEEEEE" : "E");
        SimpleDateFormat month = new SimpleDateFormat(longMonth ? "MMMMMM" : "MMM");
        int dayOfMonth = cal.get(5);
        java.util.Date javaDate = new java.util.Date(this.getCalendar().getTimeInMillis());
        return LOCALIZER.msg("datePattern", "{0}, {1} {2}", day.format(javaDate), month.format(javaDate), Integer.toString(dayOfMonth));
    }

    public String getFormattedString(String pattern) {
        SimpleDateFormat sdf = new SimpleDateFormat(pattern);
        java.util.Date javaDate = new java.util.Date(this.getCalendar().getTimeInMillis());
        return sdf.format(javaDate);
    }

    public String getFormattedString(String pattern, Locale locale) {
        SimpleDateFormat sdf = new SimpleDateFormat(pattern, locale);
        java.util.Date javaDate = new java.util.Date(this.getCalendar(locale).getTimeInMillis());
        return sdf.format(javaDate);
    }

    public String getLongDateString() {
        int hashCode = this.hashCode();
        String result = LONG_DATE_MAP.get(hashCode);
        if (result == null) {
            result = this.getFormattedString(true, true);
            if (LONG_DATE_MAP.size() < 50) {
                LONG_DATE_MAP.put(hashCode, result);
            } else {
                LOGGER.warning("Date.DATE_CACHE_SIZE is to small (50)!");
            }
        }
        return result;
    }

    public String getShortDayLongMonthString() {
        return this.getFormattedString(false, true);
    }

    public long getValue() {
        return this.mYear * 10000 + this.mMonth * 100 + this.mDay;
    }

    public Calendar getCalendar() {
        Calendar cal = Calendar.getInstance();
        cal.set(2, this.mMonth - 1);
        cal.set(1, this.mYear);
        cal.set(5, this.mDay);
        return cal;
    }

    public Calendar getCalendar(Locale locale) {
        Calendar cal = Calendar.getInstance(locale);
        cal.set(2, this.mMonth - 1);
        cal.set(1, this.mYear);
        cal.set(5, this.mDay);
        return cal;
    }

    public String toString() {
        return this.getFormattedString(false, false);
    }

    public Date addDays(int days) {
        Calendar cal = this.getCalendar();
        cal.add(5, days);
        return new Date(cal);
    }

    @Override
    public int compareTo(Date otherDate) {
        if (this.mYear < otherDate.mYear) {
            return -1;
        }
        if (this.mYear > otherDate.mYear) {
            return 1;
        }
        if (this.mMonth < otherDate.mMonth) {
            return -1;
        }
        if (this.mMonth > otherDate.mMonth) {
            return 1;
        }
        if (this.mDay < otherDate.mDay) {
            return -1;
        }
        if (this.mDay > otherDate.mDay) {
            return 1;
        }
        return 0;
    }

    public int getDayOfWeek() {
        Calendar cal = this.getCalendar();
        return cal.get(7);
    }

    public boolean isFirstDayOfWeek() {
        return this.getDayOfWeek() == Settings.propFirstDayOfWeek.getInt();
    }

    public boolean isFirstDayOfWeek(Locale locale) {
        Calendar cal = this.getCalendar(locale);
        return cal.get(7) == cal.getFirstDayOfWeek();
    }

    public void writeData(DataOutput out) throws IOException {
        out.writeInt(3);
        out.writeShort(this.mYear);
        out.writeByte(this.mMonth);
        out.writeByte(this.mDay);
    }

    public static Date readData(DataInput in) throws IOException {
        byte day;
        byte month;
        short year;
        int version = in.readInt();
        if (version == 1) {
            int date = in.readInt();
            long l = (long)date * 24L * 60L * 60L * 1000L;
            java.util.Date d = new java.util.Date(l);
            Calendar mCalendar = Calendar.getInstance();
            mCalendar.setTime(d);
            year = (short)mCalendar.get(1);
            month = (byte)(mCalendar.get(2) + 1);
            day = (byte)mCalendar.get(5);
        } else if (version == 2) {
            year = (short)in.readInt();
            month = (byte)in.readInt();
            day = (byte)in.readInt();
        } else {
            year = in.readShort();
            month = in.readByte();
            day = in.readByte();
        }
        return new Date(year, month, day);
    }

    public static void resetLocalizer() {
        LOCALIZER = Localizer.getLocalizerFor(Date.class);
    }
}

