/*
 * Decompiled with CFR 0.152.
 */
package devplugin;

import devplugin.ActionMenu;
import devplugin.AfterDataUpdateInfoPanel;
import devplugin.Channel;
import devplugin.ChannelDayProgram;
import devplugin.ContextMenuIf;
import devplugin.Date;
import devplugin.ImportanceValue;
import devplugin.Marker;
import devplugin.PluginCenterPanelWrapper;
import devplugin.PluginCommunication;
import devplugin.PluginInfo;
import devplugin.PluginManager;
import devplugin.PluginTreeNode;
import devplugin.PluginsFilterComponent;
import devplugin.PluginsProgramFilter;
import devplugin.Program;
import devplugin.ProgramInfo;
import devplugin.ProgramRatingIf;
import devplugin.ProgramReceiveIf;
import devplugin.ProgramReceiveTarget;
import devplugin.SettingsTab;
import devplugin.ThemeIcon;
import devplugin.ToolTipIcon;
import devplugin.Version;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Properties;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import tvbrowser.core.Settings;
import tvbrowser.core.icontheme.IconLoader;
import tvbrowser.core.plugin.PluginProxyManager;
import tvdataservice.MutableChannelDayProgram;
import util.io.stream.ObjectInputStreamProcessor;
import util.io.stream.ObjectOutputStreamProcessor;
import util.io.stream.StreamUtilities;
import util.ui.ImageUtilities;
import util.ui.Localizer;

public abstract class Plugin
implements Marker,
ContextMenuIf,
ProgramReceiveIf {
    public static final String CATEGORY_ALL = "all";
    public static final String CATEGORY_REMOTE_CONTROL_SOFTWARE = "remote_soft";
    public static final String CATEGORY_REMOTE_CONTROL_HARDWARE = "remote_hard";
    public static final String CATEGORY_ADDITONAL_DATA_SERVICE_SOFTWARE = "datasources_soft";
    public static final String CATEGORY_ADDITONAL_DATA_SERVICE_HARDWARE = "datasources_hard";
    public static final String CATEGORY_RATINGS = "ratings";
    public static final String CATEGORY_OTHER = "misc";
    public static final String ALL_CATEGORY = "all";
    public static final String REMOTE_CONTROL_SOFTWARE_CATEGORY = "remote_soft";
    public static final String REMOTE_CONTROL_HARDWARE_CATEGORY = "remote_hard";
    public static final String ADDITONAL_DATA_SERVICE_SOFTWARE_CATEGORY = "datasources_soft";
    public static final String ADDITONAL_DATA_SERVICE_HARDWARE_CATEGORY = "datasources_hard";
    public static final String RATINGS_CATEGORY = "ratings";
    public static final String OTHER_CATEGORY = "misc";
    private static final Logger LOGGER = Logger.getLogger(Plugin.class.getName());
    public static final String BIG_ICON = "BigIcon";
    public static final String NO_ICON_RESIZE = "NoIconResize";
    public static final String ACTION_ID_KEY = "ActionId";
    public static final String DISABLED_ON_TASK_MENU = "DISABLED_ON_TASK_MENU";
    public static final int SINGLE_CLICK_WAITING_TIME;
    public static final Localizer mLocalizer;
    private PluginTreeNode mRootNode;
    private static PluginManager mPluginManager;
    private Frame mParentFrame;
    private Icon mMarkIcon;

    public static final void setPluginManager(PluginManager manager) {
        if (mPluginManager == null) {
            mPluginManager = manager;
        }
    }

    public static final PluginManager getPluginManager() {
        return mPluginManager;
    }

    @Override
    public final String getId() {
        return Plugin.getPluginManager().getJavaPluginId(this);
    }

    public final void setParent(Frame parent) {
        this.mParentFrame = parent;
    }

    protected final Frame getParentFrame() {
        return this.mParentFrame;
    }

    protected final ImageIcon createImageIcon(String fileName) {
        return ImageUtilities.createImageIconFromJar(fileName, this.getClass());
    }

    protected final ImageIcon createImageIconForFileName(String fileName) {
        return ImageUtilities.createImageIconFromJar(fileName, null);
    }

    public final ImageIcon createImageIcon(String category, String icon, int size) {
        return Plugin.getPluginManager().getIconFromTheme(this, category, icon, size);
    }

    public final ImageIcon createImageIcon(String category, String icon) {
        return Plugin.getPluginManager().getIconFromTheme(this, category, icon, 16);
    }

    public final ImageIcon createImageIcon(ThemeIcon icon) {
        return Plugin.getPluginManager().getIconFromTheme(this, icon);
    }

    public void readData(ObjectInputStream in) throws IOException, ClassNotFoundException {
    }

    public void writeData(ObjectOutputStream out) throws IOException {
    }

    public void loadSettings(Properties settings) {
    }

    public Properties storeSettings() {
        return null;
    }

    public static Version getVersion() {
        return new Version(0, 0);
    }

    public PluginInfo getInfo() {
        String name = mLocalizer.msg("unkown", "Unknown");
        String desc = mLocalizer.msg("noDescription", "No description");
        String author = mLocalizer.msg("noAuthor", "No author given");
        return new PluginInfo(this.getClass(), name, desc, author);
    }

    @Override
    public ActionMenu getContextMenuActions(Program program) {
        return null;
    }

    public ActionMenu getContextMenuActions(Channel channel) {
        return null;
    }

    protected final Program getProgramFromContextMenuActionEvent(ActionEvent evt) {
        return (Program)evt.getSource();
    }

    public ActionMenu getButtonAction() {
        return null;
    }

    public String getProgramTableIconText() {
        return null;
    }

    public ToolTipIcon[] getProgramTableToolTipIcons(Program program) {
        return null;
    }

    public Icon[] getProgramTableIcons(Program program) {
        return null;
    }

    public SettingsTab getSettingsTab() {
        return null;
    }

    @Override
    public final Icon getMarkIcon() {
        if (this.mMarkIcon == null) {
            String iconFileName;
            ThemeIcon icon = this.getMarkIconFromTheme();
            if (icon != null) {
                this.mMarkIcon = IconLoader.getInstance().getIconFromTheme(this, icon);
            }
            if (this.mMarkIcon == null && (iconFileName = this.getMarkIconName()) != null) {
                this.mMarkIcon = ImageUtilities.createImageIconFromJar(iconFileName, this.getClass());
            }
        }
        return this.mMarkIcon;
    }

    @Override
    public final Icon[] getMarkIcons(Program p) {
        if (this.getMarkIcon() != null) {
            return new Icon[]{this.getMarkIcon()};
        }
        Icon[] icon = this.getMarkIconsForProgram(p);
        if (icon == null) {
            return new Icon[0];
        }
        return icon;
    }

    public Icon[] getMarkIconsForProgram(Program p) {
        return null;
    }

    public ThemeIcon getMarkIconFromTheme() {
        return null;
    }

    protected String getMarkIconName() {
        return null;
    }

    public void handleTvDataUpdateFinished() {
    }

    public void handleTvDataAdded(MutableChannelDayProgram newProg) {
    }

    public void handleTvDataAdded(ChannelDayProgram newProg) {
    }

    public void handleTvDataDeleted(ChannelDayProgram oldProg) {
    }

    public void handleTvDataTouched(ChannelDayProgram removedDayProgram, ChannelDayProgram addedDayProgram) {
    }

    public void onActivation() {
    }

    public void onDeactivation() {
    }

    public boolean canUseProgramTree() {
        return false;
    }

    public void handleTvBrowserStartFinished() {
    }

    public PluginTreeNode getRootNode() {
        if (this.mRootNode == null) {
            this.mRootNode = new PluginTreeNode(this);
            this.loadRootNode(this.mRootNode);
        }
        return this.mRootNode;
    }

    protected void loadRootNode(final PluginTreeNode node) {
        if (node == null) {
            return;
        }
        File nodeFile = new File(Settings.getUserSettingsDirName(), this.getId() + ".node");
        if (nodeFile.canRead()) {
            try {
                StreamUtilities.objectInputStream(nodeFile, new ObjectInputStreamProcessor(){

                    @Override
                    public void process(ObjectInputStream inputStream) throws IOException {
                        node.load(inputStream);
                        inputStream.close();
                    }
                });
            }
            catch (Exception e) {
                LOGGER.severe(mLocalizer.msg("error.couldNotReadFile", "Reading file '{0}' failed.", nodeFile.getAbsolutePath()));
                node.removeAllChildren();
            }
        }
    }

    public void storeRootNode() {
        this.storeRootNode(this.mRootNode);
    }

    protected void storeRootNode(final PluginTreeNode node) {
        File f = new File(Settings.getUserSettingsDirName(), this.getId() + ".node");
        if (node == null || node.isEmpty()) {
            f.delete();
            return;
        }
        try {
            StreamUtilities.objectOutputStream(f, new ObjectOutputStreamProcessor(){

                @Override
                public void process(ObjectOutputStream out) throws IOException {
                    if (node != null) {
                        node.store(out);
                    }
                    out.close();
                }
            });
        }
        catch (IOException e) {
            LOGGER.severe(mLocalizer.msg("error.couldNotWriteFile", "Storing file '{0}' failed.", f.getAbsolutePath()));
        }
    }

    @Override
    public boolean canReceiveProgramsWithTarget() {
        return false;
    }

    @Override
    public boolean receivePrograms(Program[] programArr, ProgramReceiveTarget receiveTarget) {
        return false;
    }

    @Override
    public boolean receiveValues(String[] values, ProgramReceiveTarget receiveTarget) {
        return false;
    }

    @Override
    public ProgramReceiveTarget[] getProgramReceiveTargets() {
        return ProgramReceiveTarget.createDefaultTargetArrayForProgramReceiveIf(this);
    }

    public PluginsProgramFilter[] getAvailableFilter() {
        return null;
    }

    public boolean isAllowedToDeleteProgramFilter(PluginsProgramFilter programFilter) {
        return false;
    }

    public String toString() {
        return this.getInfo().getName();
    }

    public Class<? extends PluginsFilterComponent>[] getAvailableFilterComponentClasses() {
        return null;
    }

    @Override
    public int getMarkPriorityForProgram(Program p) {
        return Settings.propProgramPanelUsedDefaultMarkPriority.getInt();
    }

    protected final boolean saveMe() {
        return PluginProxyManager.getInstance().saveSettings(PluginProxyManager.getInstance().getActivatedPluginForId(this.getId()));
    }

    public final void layoutWindow(String windowId, Window window) {
        this.layoutWindow(windowId, window, null);
    }

    public final void layoutWindow(String windowId, Window window, Dimension defaultSize) {
        Settings.layoutWindow(this.getId() + "." + windowId, window, defaultSize);
    }

    public ProgramRatingIf[] getRatingInterfaces() {
        return null;
    }

    @Override
    public int compareTo(ProgramReceiveIf o) {
        return this.getInfo().getName().compareTo(o.toString());
    }

    public ImportanceValue getImportanceValueForProgram(Program p) {
        return new ImportanceValue(1, -1);
    }

    public String getPluginCategory() {
        return "all";
    }

    public PluginCenterPanelWrapper getPluginCenterPanelWrapper() {
        return null;
    }

    public AfterDataUpdateInfoPanel getAfterDataUpdateInfoPanel() {
        return null;
    }

    public void handleTvBrowserSettingsChanged() {
    }

    public void handleTvDataUpdateStarted() {
    }

    public void handleTvDataUpdateStarted(Date until) {
        this.handleTvDataUpdateStarted();
    }

    public PluginCommunication getCommunicationClass() {
        return null;
    }

    public boolean isAllowingArtificialPluginTree() {
        return !this.canUseProgramTree();
    }

    public ProgramInfo[] getAddtionalProgramInfoForProgram(Program p, String uniqueId) {
        return null;
    }

    static {
        int doubleClickTime = 200;
        try {
            Object property = Toolkit.getDefaultToolkit().getDesktopProperty("awt.multiClickInterval");
            if (property != null) {
                doubleClickTime = (Integer)property;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (doubleClickTime < 50 || doubleClickTime > 2000) {
            doubleClickTime = 200;
        }
        SINGLE_CLICK_WAITING_TIME = doubleClickTime;
        mLocalizer = Localizer.getLocalizerFor(Plugin.class);
    }
}

