/*
 * Decompiled with CFR 0.152.
 */
package devplugin;

import devplugin.Plugin;
import devplugin.Program;
import devplugin.ProgramReceiveIf;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import util.misc.HashCodeUtilities;
import util.ui.Localizer;

public final class ProgramReceiveTarget
implements Comparable<ProgramReceiveTarget> {
    private static final Localizer mLocalizer = Localizer.getLocalizerFor(ProgramReceiveTarget.class);
    private String mReceiveIfId;
    private String mTargetId;
    private String mTargetName;

    public static ProgramReceiveTarget[] createDefaultTargetArrayForProgramReceiveIf(ProgramReceiveIf receiveIf) {
        return new ProgramReceiveTarget[]{new ProgramReceiveTarget(receiveIf, mLocalizer.msg("defaultTarget", "Default target"), "NULL")};
    }

    public static ProgramReceiveTarget createDefaultTargetForProgramReceiveIfId(String receiveIfId) {
        return new ProgramReceiveTarget(receiveIfId, mLocalizer.msg("defaultTarget", "Default target"), "NULL");
    }

    private ProgramReceiveTarget(String receiveIfId, String name, String targetId) {
        this.mReceiveIfId = receiveIfId;
        this.mTargetName = name;
        this.mTargetId = targetId;
    }

    public ProgramReceiveTarget(ProgramReceiveIf receiveIf, String name, String targetId) {
        this.mReceiveIfId = receiveIf.getId();
        this.mTargetName = name;
        this.mTargetId = targetId;
    }

    public ProgramReceiveTarget(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.readInt();
        this.mReceiveIfId = in.readUTF();
        this.mTargetId = in.readUTF();
        this.mTargetName = in.readUTF();
    }

    public void writeData(ObjectOutputStream out) throws IOException {
        out.writeInt(1);
        out.writeUTF(this.mReceiveIfId);
        out.writeUTF(this.mTargetId);
        out.writeUTF(this.mTargetName);
    }

    public String getTargetName() {
        return this.mTargetName;
    }

    public String toString() {
        return this.getTargetName();
    }

    public String getReceiveIfId() {
        return this.mReceiveIfId;
    }

    public String getTargetId() {
        return this.mTargetId;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o instanceof ProgramReceiveTarget) {
            return ((ProgramReceiveTarget)o).mReceiveIfId.compareTo(this.mReceiveIfId) == 0 && ((ProgramReceiveTarget)o).mTargetId.compareTo(this.mTargetId) == 0;
        }
        return false;
    }

    public int hashCode() {
        int result = HashCodeUtilities.hash(this.mReceiveIfId);
        result = HashCodeUtilities.hash(result, this.mTargetId);
        return result;
    }

    public ProgramReceiveIf getReceifeIfForIdOfTarget() {
        return Plugin.getPluginManager().getReceiceIfForId(this.mReceiveIfId);
    }

    public static boolean isDefaultProgramReceiveTargetForProgramReceiveIf(ProgramReceiveIf receiveIf, ProgramReceiveTarget receiveTarget) {
        if (receiveIf == null || receiveTarget == null) {
            return false;
        }
        return receiveIf.getId().compareTo(receiveTarget.mReceiveIfId) == 0 && receiveTarget.mTargetId.compareTo("NULL") == 0;
    }

    public boolean isReceiveTargetWithIdOfProgramReceiveIf(ProgramReceiveIf receiveIf, String id) {
        if (receiveIf == null || id == null) {
            return false;
        }
        return receiveIf.getId().compareTo(this.mReceiveIfId) == 0 && id.compareTo(this.mTargetId) == 0;
    }

    @Override
    public int compareTo(ProgramReceiveTarget other) {
        return this.getTargetName().compareTo(other.getTargetName());
    }

    public void receivePrograms(Program[] programs) {
        ProgramReceiveIf plugin = this.getReceifeIfForIdOfTarget();
        if (plugin != null && plugin.canReceiveProgramsWithTarget()) {
            plugin.receivePrograms(programs, this);
        }
    }
}

