/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.core;

import devplugin.Channel;
import devplugin.ChannelGroup;
import java.util.HashMap;
import java.util.TimeZone;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import tvbrowser.core.tvdataservice.TvDataServiceProxy;
import util.ui.Localizer;

public class DummyChannel
extends Channel {
    private static final Localizer LOCALIZER = Localizer.getLocalizerFor(DummyChannel.class);
    private static final ImageIcon ICON = new ImageIcon("imgs/unknown_channel.png");
    private static final HashMap<String, DummyGroup> DUMMY_GROUP_MAP = new HashMap();
    private Channel mOriginal = null;

    private static final DummyGroup getDummyGroup(String groupId) {
        DummyGroup dummyGroup = DUMMY_GROUP_MAP.get(groupId);
        if (dummyGroup == null) {
            dummyGroup = new DummyGroup(groupId);
            DUMMY_GROUP_MAP.put(groupId, dummyGroup);
        }
        return dummyGroup;
    }

    public DummyChannel(String dataServiceId, String groupId, String country, String channelId, String channelName) {
        super(dataServiceId, channelName, channelId, TimeZone.getDefault(), country, "\u00a9 " + LOCALIZER.msg("unknown", "Unknown"), LOCALIZER.msg("url", "http://enwiki.tvbrowser.org/index.php/Not_available"), (ChannelGroup)DummyChannel.getDummyGroup(groupId), (Icon)ICON, 0, null, new String[]{country}, null, true);
    }

    @Override
    public Icon getIcon() {
        if (this.mOriginal != null) {
            return this.mOriginal.getIcon();
        }
        return this.getDefaultIcon();
    }

    @Override
    public String getName() {
        if (this.mOriginal != null) {
            return this.mOriginal.getName();
        }
        return super.getName() + " " + LOCALIZER.msg("na", "(N/A)");
    }

    @Override
    public String getWebpage() {
        if (this.mOriginal != null) {
            return this.mOriginal.getWebpage();
        }
        return this.getDefaultWebPage();
    }

    public void setOriginal(Channel ch) {
        this.mOriginal = ch;
    }

    @Override
    public TvDataServiceProxy getDataServiceProxy() {
        if (this.mOriginal != null) {
            return this.mOriginal.getDataServiceProxy();
        }
        return super.getDataServiceProxy();
    }

    private static final class DummyGroup
    implements ChannelGroup {
        private String mGroupID;

        public DummyGroup(String groupID) {
            this.mGroupID = groupID;
        }

        @Override
        public String getName() {
            return LOCALIZER.msg("dummyGroupName", "Dummy Group");
        }

        @Override
        public String getId() {
            return this.mGroupID;
        }

        @Override
        public String getDescription() {
            return LOCALIZER.msg("dummyGroupDesc", "Dummy group for unknown channels");
        }

        @Override
        public String getProviderName() {
            return LOCALIZER.msg("unknown", "Unknown");
        }
    }
}

