/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.core.filters.filtercomponents;

import devplugin.Program;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import tvbrowser.core.filters.filtercomponents.AbstractFilterComponent;
import util.ui.Localizer;

public class ProgramRunningFilterComponent
extends AbstractFilterComponent {
    private int mSelectedBits = 0;
    private JCheckBox[] mCheckBox;
    private static final Localizer mLocalizer = Localizer.getLocalizerFor(ProgramRunningFilterComponent.class);
    private static int NOWRUNNING = 1;
    private static int ALREADYFINISHED = 2;
    private static int NOTYETSTARTED = 4;

    public ProgramRunningFilterComponent() {
        this("", "");
    }

    public ProgramRunningFilterComponent(String name, String description) {
        super(name, description);
    }

    @Override
    public int getVersion() {
        return 1;
    }

    @Override
    public boolean accept(Program program) {
        if (this.bitSet(this.mSelectedBits, NOWRUNNING) && program.isOnAir()) {
            return true;
        }
        if (this.bitSet(this.mSelectedBits, ALREADYFINISHED) && program.isExpired()) {
            return true;
        }
        return this.bitSet(this.mSelectedBits, NOTYETSTARTED) && !program.isExpired() && !program.isOnAir();
    }

    @Override
    public void read(ObjectInputStream in, int version) throws IOException, ClassNotFoundException {
        this.mSelectedBits = in.readInt();
    }

    @Override
    public void write(ObjectOutputStream out) throws IOException {
        out.writeInt(this.mSelectedBits);
    }

    @Override
    public JPanel getSettingsPanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.fill = 2;
        c.gridwidth = 0;
        this.mCheckBox = new JCheckBox[3];
        this.mCheckBox[0] = new JCheckBox(mLocalizer.msg("finished", "Already finished"));
        panel.add((Component)this.mCheckBox[0], c);
        if (this.bitSet(this.mSelectedBits, ALREADYFINISHED)) {
            this.mCheckBox[0].setSelected(true);
        }
        this.mCheckBox[1] = new JCheckBox(mLocalizer.msg("nowrunning", "Now running"));
        panel.add((Component)this.mCheckBox[1], c);
        if (this.bitSet(this.mSelectedBits, NOWRUNNING)) {
            this.mCheckBox[1].setSelected(true);
        }
        this.mCheckBox[2] = new JCheckBox(mLocalizer.msg("notyetstarted", "Not yet started"));
        panel.add((Component)this.mCheckBox[2], c);
        if (this.bitSet(this.mSelectedBits, NOTYETSTARTED)) {
            this.mCheckBox[2].setSelected(true);
        }
        JPanel centerPanel = new JPanel(new BorderLayout());
        centerPanel.add((Component)panel, "North");
        return centerPanel;
    }

    @Override
    public void saveSettings() {
        int selectedBits = 0;
        if (this.mCheckBox[0].isSelected()) {
            selectedBits |= ALREADYFINISHED;
        }
        if (this.mCheckBox[1].isSelected()) {
            selectedBits |= NOWRUNNING;
        }
        if (this.mCheckBox[2].isSelected()) {
            selectedBits |= NOTYETSTARTED;
        }
        this.mSelectedBits = selectedBits;
    }

    public String toString() {
        return mLocalizer.msg("ProgramState", "Programstate");
    }

    private boolean bitSet(int num, int pattern) {
        return (num & pattern) == pattern;
    }
}

