/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.core.filters.filtercomponents;

import devplugin.Marker;
import devplugin.Program;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import javax.swing.JPanel;
import tvbrowser.core.filters.filtercomponents.AbstractFilterComponent;
import tvbrowser.extras.reminderplugin.ReminderPlugin;
import util.ui.Localizer;

public class ReminderFilterComponent
extends AbstractFilterComponent {
    private static final Localizer mLocalizer = Localizer.getLocalizerFor(ReminderFilterComponent.class);

    public ReminderFilterComponent(String name, String desc) {
        super(name, desc);
    }

    public ReminderFilterComponent() {
        this("", "");
    }

    public String toString() {
        return mLocalizer.msg("name", "Reminder programs");
    }

    @Override
    public int getVersion() {
        return 1;
    }

    @Override
    public boolean accept(Program program) {
        Marker[] mark;
        String reminderPluginId = ReminderPlugin.getReminderPluginId();
        for (Marker element : mark = program.getMarkerArr()) {
            if (!reminderPluginId.equals(element.getId())) continue;
            return true;
        }
        return false;
    }

    @Override
    public void read(ObjectInputStream in, int version) throws IOException, ClassNotFoundException {
    }

    @Override
    public void write(ObjectOutputStream out) throws IOException {
    }

    @Override
    public String getTypeDescription() {
        return mLocalizer.msg("desc", "Accepts all programs that are marked by the Reminder.");
    }

    @Override
    public JPanel getSettingsPanel() {
        return null;
    }

    @Override
    public void saveSettings() {
    }
}

