/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.core.icontheme;

import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.factories.CC;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.Sizes;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Locale;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import tvbrowser.core.Settings;
import tvbrowser.core.icontheme.IconLoader;
import tvbrowser.core.icontheme.IconTheme;
import tvbrowser.core.icontheme.InfoIconTheme;
import tvbrowser.core.icontheme.InfoThemeLoader;
import tvbrowser.core.icontheme.ThemeDownloadItem;
import tvbrowser.core.icontheme.ThemeDownloader;
import util.ui.Localizer;
import util.ui.ScrollableJPanel;
import util.ui.UiUtilities;
import util.ui.WindowClosingIf;

public class ThemeDownloadDlg
extends JDialog
implements WindowClosingIf {
    public static final int THEME_ICON_TYPE = 0;
    public static final int INFO_ICON_TYPE = 1;
    static final Localizer LOCALIZER = Localizer.getLocalizerFor(ThemeDownloadDlg.class);
    private ThemePanel mMarked;
    private ArrayList<ThemeDownloadItem> mSelectedItems;
    private ArrayList<ThemeDownloadItem> mSuccessDownloads = new ArrayList();
    private JButton mDownload;
    private File mDownloadDirectory = null;

    public ThemeDownloadDlg(Window parent, int type) {
        super(parent, Dialog.ModalityType.APPLICATION_MODAL);
        ArrayList<String> currentNameList = new ArrayList<String>();
        String mSpecURL = null;
        switch (type) {
            case 0: {
                Comparable<IconTheme>[] available;
                this.setTitle(LOCALIZER.msg("title.iconTheme", "TV-Browser icon themes download"));
                mSpecURL = "http://www.tvbrowser.org/downloads/themes/themes.txt";
                this.mDownloadDirectory = IconLoader.USER_ICON_DIR;
                for (Comparable<IconTheme> theme : available = IconLoader.getInstance().getAvailableThemes()) {
                    currentNameList.add(((IconTheme)theme).getName());
                }
                break;
            }
            case 1: {
                Comparable<IconTheme>[] available;
                this.setTitle(LOCALIZER.msg("title.infoIconTheme", "TV-Browser info icon themes download"));
                mSpecURL = "http://www.tvbrowser.org/downloads/infothemes/infothemes.txt";
                this.mDownloadDirectory = InfoThemeLoader.USER_ICON_DIR;
                for (Comparable<IconTheme> theme : available = InfoThemeLoader.getInstance().getAvailableInfoIconThemes()) {
                    currentNameList.add(((InfoIconTheme)theme).toString());
                }
                break;
            }
        }
        MouseListener mouseListener = this.createMouseListener();
        FocusListener focusListener = this.createFocusListener();
        this.mSelectedItems = new ArrayList();
        final ScrollableJPanel mainPanel = new ScrollableJPanel(){

            @Override
            public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
                return Math.max(1, (int)visibleRect.getHeight() / 4);
            }

            @Override
            public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
                return Math.max(1, (int)visibleRect.getHeight() / 8);
            }
        };
        mainPanel.setLayout(new BoxLayout(mainPanel, 1));
        mainPanel.setBackground(UIManager.getColor("List.background"));
        this.mDownload = new JButton(LOCALIZER.msg("download", "Download selected themes"));
        this.mDownload.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                for (ThemeDownloadItem item : ThemeDownloadDlg.this.mSelectedItems) {
                    if (!item.download(ThemeDownloadDlg.this.mDownloadDirectory)) continue;
                    ThemeDownloadDlg.this.mSuccessDownloads.add(item);
                }
                ThemeDownloadDlg.this.close();
            }
        });
        JButton close = new JButton(Localizer.getLocalization("i18n_close"));
        close.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ThemeDownloadDlg.this.close();
            }
        });
        JPanel buttons = new JPanel(new FormLayout("default:grow,default,2dlu,default", "5dlu,default"));
        buttons.add((Component)this.mDownload, CC.xy(2, 2));
        buttons.add((Component)close, CC.xy(4, 2));
        this.mDownload.setEnabled(false);
        close.grabFocus();
        this.getRootPane().setDefaultButton(close);
        try {
            ThemeDownloadItem[] downloadItems = ThemeDownloader.downloadThemes(new URL(mSpecURL), this.mDownloadDirectory);
            if (downloadItems != null) {
                for (ThemeDownloadItem item : downloadItems) {
                    if (currentNameList.contains(item.getName(Locale.getDefault()))) continue;
                    mainPanel.add(new ThemePanel(item, mouseListener, focusListener));
                }
            }
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        final JScrollPane scroll = new JScrollPane(mainPanel);
        scroll.getViewport().setBackground(UIManager.getColor("List.background"));
        this.setLayout(new BorderLayout());
        ((JPanel)this.getContentPane()).setBorder(Borders.DIALOG);
        this.add((Component)scroll, "Center");
        this.add((Component)buttons, "South");
        Settings.layoutWindow("themeDownloadDlg", this, new Dimension(500, 500));
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                scroll.getVerticalScrollBar().setValue(0);
            }
        });
        UiUtilities.registerForClosing(this);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowOpened(WindowEvent e) {
                if (mainPanel.getComponentCount() == 0) {
                    JOptionPane.showMessageDialog(ThemeDownloadDlg.this, LOCALIZER.msg("noIcons", "No new icons were found."), Localizer.getLocalization("i18n_info"), 1);
                    ThemeDownloadDlg.this.close();
                }
            }
        });
    }

    private MouseListener createMouseListener() {
        MouseAdapter mouseListener = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                Component c = e.getComponent();
                if (!(c instanceof ThemePanel)) {
                    while (c.getParent() != null && c.getParent() instanceof ThemePanel) {
                        c = c.getParent();
                    }
                }
                if (c instanceof ThemePanel) {
                    if (ThemeDownloadDlg.this.mMarked != null && !ThemeDownloadDlg.this.mMarked.equals(c)) {
                        ThemeDownloadDlg.this.mMarked.unmark();
                    }
                    ThemeDownloadDlg.this.mMarked = (ThemePanel)c;
                    ThemeDownloadDlg.this.mMarked.mark();
                } else {
                    ThemeDownloadDlg.this.mMarked.unmark();
                }
            }
        };
        return mouseListener;
    }

    private FocusListener createFocusListener() {
        FocusAdapter focusListener = new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                Component c = e.getComponent();
                if (!(c instanceof ThemePanel)) {
                    while (c.getParent() != null && c.getParent() instanceof ThemePanel) {
                        c = c.getParent();
                    }
                }
                if (c instanceof ThemePanel) {
                    if (ThemeDownloadDlg.this.mMarked != null && !ThemeDownloadDlg.this.mMarked.equals(c)) {
                        ThemeDownloadDlg.this.mMarked.unmark();
                    }
                    ThemeDownloadDlg.this.mMarked = (ThemePanel)c;
                    ThemeDownloadDlg.this.mMarked.mark();
                } else {
                    ThemeDownloadDlg.this.mMarked.unmark();
                }
            }
        };
        return focusListener;
    }

    public ThemeDownloadItem[] getSuccessItems() {
        return this.mSuccessDownloads.toArray(new ThemeDownloadItem[this.mSuccessDownloads.size()]);
    }

    @Override
    public void close() {
        this.mSelectedItems.clear();
        this.dispose();
    }

    public boolean downloadSuccess() {
        return !this.mSuccessDownloads.isEmpty();
    }

    private final class ThemePanel
    extends JPanel {
        private ThemeDownloadItem mItem;
        private JCheckBox mSelected;
        private JEditorPane mDescription;
        private JEditorPane mAuthor;
        private JLabel mName;

        public ThemePanel(ThemeDownloadItem item, MouseListener mouseListener, FocusListener focusListener) {
            this.mItem = item;
            this.mSelected = new JCheckBox();
            this.mSelected.setOpaque(false);
            this.mSelected.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (e.getStateChange() == 1) {
                        ThemeDownloadDlg.this.mSelectedItems.add(ThemePanel.this.mItem);
                    } else {
                        ThemeDownloadDlg.this.mSelectedItems.remove(ThemePanel.this.mItem);
                    }
                    ThemeDownloadDlg.this.mDownload.setEnabled(!ThemeDownloadDlg.this.mSelectedItems.isEmpty());
                }
            });
            this.mSelected.addFocusListener(focusListener);
            this.setBackground(UIManager.getColor("List.background"));
            Color foreground = UIManager.getColor("List.foreground");
            this.setLayout(new FormLayout("10dlu,2dlu,28dlu,5dlu,50dlu:grow", "fill:default:grow,default,default,default,fill:default:grow"));
            this.setBorder(Borders.DLU2);
            this.mName = new JLabel(item.getName(Locale.getDefault()));
            this.mName.setFont(this.mName.getFont().deriveFont(1));
            this.mName.setFont(this.mName.getFont().deriveFont(this.mName.getFont().getSize2D() + 2.0f));
            this.mName.setOpaque(false);
            this.mName.setForeground(foreground);
            ImageIcon icon = this.mItem.getPreviewImage();
            String description = item.getDescription(Locale.getDefault());
            if (icon != null) {
                icon = (ImageIcon)UiUtilities.scaleIcon(icon, Sizes.dialogUnitXAsPixel(28, this.mName));
                JLabel iconLabel = new JLabel(icon);
                iconLabel.setOpaque(false);
                this.add((Component)iconLabel, CC.xywh(3, 1, 1, 5));
            }
            this.add((Component)this.mSelected, CC.xywh(1, 1, 1, 5));
            this.add((Component)this.mName, CC.xy(5, 2));
            if (description != null) {
                this.mDescription = UiUtilities.createHtmlHelpTextArea(description, foreground, this.getBackground());
                this.mDescription.setOpaque(false);
                this.mDescription.addMouseListener(mouseListener);
                this.add((Component)this.mDescription, CC.xy(5, 3));
            }
            this.mAuthor = UiUtilities.createHtmlHelpTextArea(LOCALIZER.msg("providedBy", "Provided by: {0}", this.mItem.getAuthor()), foreground, this.getBackground());
            this.mAuthor.setOpaque(false);
            this.mAuthor.addMouseListener(mouseListener);
            this.mAuthor.setForeground(foreground);
            this.add((Component)this.mAuthor, CC.xy(5, 4));
            this.addMouseListener(mouseListener);
        }

        public void mark() {
            this.setBackground(UIManager.getColor("List.selectionBackground"));
            this.mName.setForeground(UIManager.getColor("List.selectionForeground"));
            if (this.mDescription != null) {
                this.mDescription.setForeground(this.mName.getForeground());
                UiUtilities.updateHtmlHelpTextArea(this.mDescription, this.mItem.getDescription(Locale.getDefault()), this.mName.getForeground(), this.getBackground());
            }
            this.mAuthor.setForeground(this.mName.getForeground());
            UiUtilities.updateHtmlHelpTextArea(this.mAuthor, LOCALIZER.msg("providedBy", "Provided by: {0}", this.mItem.getAuthor()), this.mName.getForeground(), this.getBackground());
        }

        public void unmark() {
            this.setBackground(UIManager.getColor("List.background"));
            this.mName.setForeground(UIManager.getColor("List.foreground"));
            if (this.mDescription != null) {
                this.mDescription.setForeground(this.mName.getForeground());
                UiUtilities.updateHtmlHelpTextArea(this.mDescription, this.mItem.getDescription(Locale.getDefault()), this.mName.getForeground(), this.getBackground());
            }
            this.mAuthor.setForeground(this.mName.getForeground());
            UiUtilities.updateHtmlHelpTextArea(this.mAuthor, LOCALIZER.msg("providedBy", "Provided by: {0}", this.mItem.getAuthor()), this.mName.getForeground(), this.getBackground());
        }
    }
}

