/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.core.icontheme;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import tvbrowser.core.icontheme.ThemeDownloadItem;
import util.io.IOUtilities;

public class ThemeDownloader {
    private ArrayList<ThemeDownloadItem> mItemList = new ArrayList();

    private ThemeDownloader() {
    }

    private void loadThemes(URL specs, File iconDir) {
        Pattern namePattern = Pattern.compile("\\[(.*)\\]");
        Pattern keyValuePattern = Pattern.compile("(.+?)=(.*)");
        try {
            BufferedReader read = new BufferedReader(new InputStreamReader(IOUtilities.getStream(specs), "UTF-8"));
            String line = null;
            ThemeDownloadItem item = null;
            while ((line = read.readLine()) != null) {
                Matcher matcher = namePattern.matcher(line);
                if (matcher.find()) {
                    item = new ThemeDownloadItem(matcher.group(1));
                    this.mItemList.add(item);
                    continue;
                }
                matcher = keyValuePattern.matcher(line);
                if (!matcher.find()) continue;
                String value = matcher.group(2);
                if (item == null) continue;
                item.addProperty(matcher.group(1), value);
            }
            read.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private ThemeDownloadItem[] getLoadedThemes() {
        Object[] items = this.mItemList.toArray(new ThemeDownloadItem[this.mItemList.size()]);
        Arrays.sort(items);
        return items;
    }

    public static final ThemeDownloadItem[] downloadThemes(URL specs, File iconDir) {
        if (specs != null && iconDir != null) {
            ThemeDownloader load = new ThemeDownloader();
            load.loadThemes(specs, iconDir);
            return load.getLoadedThemes();
        }
        return null;
    }
}

