/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.core.search.booleansearch;

import java.util.Hashtable;
import tvbrowser.core.search.booleansearch.IMatcher;
import tvbrowser.core.search.booleansearch.IStringSize;
import tvbrowser.core.search.booleansearch.MatcherReuse;

class StringMatcher
implements IMatcher,
IStringSize {
    private String mMatchString;
    private Hashtable<String, Object> mMultiTable;
    private boolean mCaseSensitive;

    public StringMatcher(String s, boolean caseSensitive, Hashtable<String, Object> matcherTab) {
        this.mCaseSensitive = caseSensitive;
        this.mMatchString = s;
        if (!caseSensitive) {
            this.mMatchString = this.mMatchString.toLowerCase();
        }
        this.mMultiTable = matcherTab;
        Object o = this.mMultiTable.get(this.mMatchString);
        if (o == null) {
            this.mMultiTable.put(this.mMatchString, this);
        } else if (o instanceof StringMatcher) {
            MatcherReuse mr = new MatcherReuse(this.mMatchString, this.mCaseSensitive);
            this.mMultiTable.put(this.mMatchString, mr);
        }
    }

    @Override
    public boolean matches(String searchTerm) {
        return searchTerm.indexOf(this.mMatchString) != -1;
    }

    public String toString() {
        return this.mMatchString;
    }

    @Override
    public int size() {
        return this.mMatchString.length();
    }

    @Override
    public IMatcher optimize() {
        IMatcher b = (IMatcher)this.mMultiTable.get(this.mMatchString);
        this.mMultiTable = null;
        return b;
    }
}

