/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.extras.common;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Properties;
import java.util.logging.Logger;
import tvbrowser.core.Settings;
import tvbrowser.extras.common.DataDeserializer;
import tvbrowser.extras.common.DataSerializer;
import util.io.stream.ObjectOutputStreamProcessor;
import util.io.stream.StreamUtilities;

public class ConfigurationHandler {
    private static final Logger LOGGER = Logger.getLogger(ConfigurationHandler.class.getName());
    private String mFilePrefix;

    public ConfigurationHandler(String filePrefix) {
        this.mFilePrefix = filePrefix;
    }

    public void loadData(DataDeserializer deserializer) throws IOException {
        block18: {
            String userDirectoryName = Settings.getUserSettingsDirName();
            File userDirectory = new File(userDirectoryName);
            File datFile = new File(userDirectory, "java." + this.mFilePrefix + ".dat");
            if (datFile.exists()) {
                ObjectInputStream in = null;
                try {
                    in = new ObjectInputStream(new BufferedInputStream(new FileInputStream(datFile), 16384));
                    deserializer.read(in);
                }
                catch (IOException e) {
                    File oldFile = new File(userDirectory, "java." + this.mFilePrefix + ".dat_old");
                    if (oldFile.isFile()) {
                        try {
                            in = new ObjectInputStream(new BufferedInputStream(new FileInputStream(oldFile), 16384));
                            deserializer.read(in);
                            LOGGER.severe("Data file '" + datFile.getAbsolutePath() + "' could not be read. Read old version instead '" + oldFile.getAbsolutePath() + "'");
                            break block18;
                        }
                        catch (ClassNotFoundException e1) {
                            throw new IOException("Could not read file " + datFile.getAbsolutePath());
                        }
                    }
                    throw e;
                }
                catch (ClassNotFoundException e) {
                    throw new IOException("Could not read file " + datFile.getAbsolutePath());
                }
                finally {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (IOException exc) {}
                    }
                }
            }
        }
    }

    public void storeData(final DataSerializer serializer) throws IOException {
        String userDirectoryName = Settings.getUserSettingsDirName();
        File userDirectory = new File(userDirectoryName);
        File tmpDatFile = new File(userDirectory, this.mFilePrefix + ".dat.temp");
        File datFile = new File(userDirectory, "java." + this.mFilePrefix + ".dat");
        File oldVersion = new File(userDirectory, "java." + this.mFilePrefix + ".dat_old");
        StreamUtilities.objectOutputStream(tmpDatFile, new ObjectOutputStreamProcessor(){

            @Override
            public void process(ObjectOutputStream out) throws IOException {
                serializer.write(out);
                out.close();
            }
        });
        if (oldVersion.isFile()) {
            oldVersion.delete();
        }
        datFile.renameTo(oldVersion);
        tmpDatFile.renameTo(datFile);
    }

    public Properties loadSettings() throws IOException {
        String userDirectoryName = Settings.getUserSettingsDirName();
        File propFile = new File(userDirectoryName, "java." + this.mFilePrefix + ".prop");
        BufferedInputStream in = null;
        try {
            if (propFile.exists()) {
                Properties prop = new Properties();
                in = new BufferedInputStream(new FileInputStream(propFile), 16384);
                prop.load(in);
                in.close();
                Properties properties = prop;
                return properties;
            }
            Properties prop = new Properties();
            return prop;
        }
        catch (IOException thr) {
            throw new IOException("Could not read settings from " + propFile.getAbsolutePath());
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException exc) {}
            }
        }
    }

    public void storeSettings(Properties settings) throws IOException {
        String userDirectoryName = Settings.getUserSettingsDirName();
        FileOutputStream fOut = null;
        File tmpPropFile = new File(userDirectoryName, this.mFilePrefix + ".prop.temp");
        try {
            if (settings != null) {
                fOut = new FileOutputStream(tmpPropFile);
                settings.store(fOut, "Settings");
                fOut.close();
            }
            File propFile = new File(userDirectoryName, "java." + this.mFilePrefix + ".prop");
            propFile.delete();
            tmpPropFile.renameTo(propFile);
        }
        catch (Throwable thr) {
            throw new IOException("Could not store settings to " + tmpPropFile.getAbsolutePath());
        }
        finally {
            if (fOut != null) {
                try {
                    fOut.close();
                }
                catch (IOException exc) {}
            }
        }
    }
}

