/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.extras.common;

import java.awt.Component;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JLabel;
import javax.swing.JList;
import util.ui.Localizer;

public class DayListCellRenderer
extends DefaultListCellRenderer {
    private static final Localizer mLocalizer = Localizer.getLocalizerFor(DayListCellRenderer.class);

    public static String getDayString(int dayOfWeek) {
        String str;
        switch (dayOfWeek) {
            case -1: {
                str = mLocalizer.msg("day.daily", "Daily");
                break;
            }
            case -3: {
                str = mLocalizer.msg("day.weekday", "weekday");
                break;
            }
            case -2: {
                str = mLocalizer.msg("day.weekend", "weekend");
                break;
            }
            case 2: {
                str = mLocalizer.msg("day.monday", "monday");
                break;
            }
            case 3: {
                str = mLocalizer.msg("day.tuesday", "tuesday");
                break;
            }
            case 4: {
                str = mLocalizer.msg("day.wednesday", "wednesday");
                break;
            }
            case 5: {
                str = mLocalizer.msg("day.thursday", "thursday");
                break;
            }
            case 6: {
                str = mLocalizer.msg("day.friday", "friday");
                break;
            }
            case 7: {
                str = mLocalizer.msg("day.saturday", "saturday");
                break;
            }
            case 1: {
                str = mLocalizer.msg("day.sunday", "sunday");
                break;
            }
            default: {
                str = "<unknown>";
            }
        }
        return str;
    }

    @Override
    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        JLabel label = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
        if (value instanceof Integer) {
            label.setText(DayListCellRenderer.getDayString((Integer)value));
        }
        return label;
    }
}

