/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.extras.favoritesplugin;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.factories.CC;
import com.jgoodies.forms.layout.FormLayout;
import devplugin.ProgramReceiveIf;
import devplugin.ProgramReceiveTarget;
import devplugin.SettingsTab;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import tvbrowser.extras.favoritesplugin.FavoritesPlugin;
import tvbrowser.extras.favoritesplugin.core.Favorite;
import tvbrowser.extras.favoritesplugin.dlgs.ExclusionPanel;
import tvbrowser.extras.favoritesplugin.dlgs.FavoriteTreeModel;
import tvbrowser.extras.reminderplugin.ReminderPluginProxy;
import tvbrowser.ui.mainframe.MainFrame;
import util.ui.DefaultMarkingPrioritySelectionPanel;
import util.ui.Localizer;
import util.ui.PluginChooserDlg;
import util.ui.UiUtilities;

public class FavoritesSettingTab
implements SettingsTab {
    private static final Localizer mLocalizer = Localizer.getLocalizerFor(FavoritesSettingTab.class);
    private ProgramReceiveTarget[] mClientPluginTargets;
    private ProgramReceiveTarget[] mCurrentClientPluginTargets;
    private JLabel mPluginLabel;
    private JCheckBox mExpertMode;
    private JCheckBox mShowTypeSelection;
    private JCheckBox mShowRepetitions;
    private JCheckBox mAutoSelectRemider;
    private JCheckBox mProvideTab;
    private JCheckBox mShowDateSeparators;
    private JRadioButton mScrollTimeNext;
    private JRadioButton mScrollTimeDay;
    private JRadioButton mFilterStartAll;
    private JRadioButton mFilterStartDefault;
    private JRadioButton mFilterStartCurrent;
    private JRadioButton mFilterStartLast;
    private JCheckBox mFilterReactOnChange;
    private DefaultMarkingPrioritySelectionPanel mMarkingsPanel;
    private ExclusionPanel mExclusionPanel;

    @Override
    public JPanel createSettingsPanel() {
        PanelBuilder builder = new PanelBuilder(new FormLayout("5dlu,min(150dlu;pref):grow,5dlu,pref,5dlu", "pref,5dlu,pref,10dlu,pref,5dlu,pref,default,10dlu,pref,5dlu,pref,10dlu,pref,5dlu,pref,10dlu,pref,5dlu,pref,10dlu,pref,5dlu,default,default,default,10dlu,default,5dlu,default,10dlu,default,5dlu,default"));
        builder.border(Borders.DIALOG);
        this.mPluginLabel = new JLabel();
        JButton choose = new JButton(mLocalizer.msg("selectPlugins", "Choose Plugins"));
        this.mExpertMode = new JCheckBox(mLocalizer.msg("expertMode", "Always show advanced favorite edit dialog"), FavoritesPlugin.getInstance().isUsingExpertMode());
        this.mShowTypeSelection = new JCheckBox(mLocalizer.msg("showTypeSelection", "Show selection for creation of filter favorite"), FavoritesPlugin.getInstance().showTypeSelection());
        this.mShowTypeSelection.setEnabled(this.mExpertMode.isSelected());
        this.mShowRepetitions = new JCheckBox(mLocalizer.msg("showRepetitions", "Show repetitions in context menu of a favorite program"), FavoritesPlugin.getInstance().isShowingRepetitions());
        this.mAutoSelectRemider = new JCheckBox(mLocalizer.msg("autoSelectReminder", "Automatically remind of new favorite programs"), FavoritesPlugin.getInstance().isAutoSelectingReminder());
        this.mShowDateSeparators = new JCheckBox(mLocalizer.msg("showDateSeparator", "Show date separator in found programs list"), FavoritesPlugin.getInstance().showDateSeparators());
        this.mProvideTab = new JCheckBox(mLocalizer.msg("provideTab", "Provide tab in TV-Browser main window"), FavoritesPlugin.getInstance().provideTab());
        ProgramReceiveTarget[] targetsArr = FavoritesPlugin.getInstance().getClientPluginTargetIds();
        ArrayList<ProgramReceiveTarget> clientPlugins = new ArrayList<ProgramReceiveTarget>();
        for (ProgramReceiveTarget target : targetsArr) {
            ProgramReceiveIf plugin = target.getReceifeIfForIdOfTarget();
            if (plugin == null) continue;
            clientPlugins.add(target);
        }
        this.mClientPluginTargets = clientPlugins.toArray(new ProgramReceiveTarget[clientPlugins.size()]);
        this.mCurrentClientPluginTargets = this.mClientPluginTargets;
        this.mExpertMode.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                FavoritesSettingTab.this.mShowTypeSelection.setEnabled(e.getStateChange() == 1);
            }
        });
        this.handlePluginSelection();
        choose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Window parent = UiUtilities.getLastModalChildOf(MainFrame.getInstance());
                PluginChooserDlg chooser = null;
                chooser = new PluginChooserDlg(parent, FavoritesSettingTab.this.mClientPluginTargets, null, (ProgramReceiveIf)ReminderPluginProxy.getInstance());
                chooser.setVisible(true);
                if (chooser.getReceiveTargets() != null) {
                    FavoritesSettingTab.access$102(FavoritesSettingTab.this, chooser.getReceiveTargets());
                }
                FavoritesSettingTab.this.handlePluginSelection();
            }
        });
        int y = 1;
        builder.addSeparator(mLocalizer.msg("passTo", "Pass favorite programs to"), CC.xyw(1, y, 5));
        builder.add((Component)this.mPluginLabel, CC.xy(2, y += 2));
        builder.add((Component)choose, CC.xy(4, y));
        builder.addSeparator(mLocalizer.msg("expertSettings", "Expert mode"), CC.xyw(1, y += 2, 5));
        y += 2;
        builder.add((Component)this.mExpertMode, CC.xyw(2, y++, 3));
        builder.add((Component)this.mShowTypeSelection, CC.xyw(2, y, 3));
        y += 2;
        builder.addSeparator(mLocalizer.msg("repetitionSettings", "Repetitions"), CC.xyw(1, 10, 4));
        builder.add((Component)this.mShowRepetitions, CC.xyw(2, y += 2, 3));
        builder.addSeparator(mLocalizer.msg("reminderSettings", "Automatic reminder"), CC.xyw(1, y += 2, 4));
        builder.add((Component)this.mAutoSelectRemider, CC.xyw(2, y += 2, 3));
        builder.addSeparator(mLocalizer.msg("exclusions", "Global exclusion criterions"), CC.xyw(1, y += 2, 4));
        this.mExclusionPanel = new ExclusionPanel(FavoritesPlugin.getInstance().getGlobalExclusions(), UiUtilities.getLastModalChildOf(MainFrame.getInstance()), null);
        builder.add((Component)this.mExclusionPanel, CC.xyw(2, y += 2, 3));
        builder.addSeparator(mLocalizer.msg("miscSettings", "Miscellaneous"), CC.xyw(1, y += 2, 4));
        y += 2;
        builder.add((Component)this.mShowDateSeparators, CC.xyw(2, y++, 3));
        builder.add((Component)this.mProvideTab, CC.xyw(2, y, 3));
        JPanel timeButtonSettings = new JPanel(new FormLayout("10dlu,default:grow", "5dlu,default,5dlu,default,1dlu,default"));
        final JLabel timeButtonBehaviour = new JLabel(mLocalizer.msg("timeButtonBehaviour", "Time buttons behaviour:"));
        this.mScrollTimeNext = new JRadioButton(mLocalizer.msg("timeButtonScrollNext", "Scroll to next occurence of time from shown programs onward"), FavoritesPlugin.getInstance().timeButtonsScrollToNextTimeInTab());
        this.mScrollTimeDay = new JRadioButton(mLocalizer.msg("timeButtonScrollDay", "Scroll to occurence of time on shown day in list"), !this.mScrollTimeNext.isSelected());
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.mScrollTimeDay);
        bg.add(this.mScrollTimeNext);
        timeButtonBehaviour.setEnabled(this.mProvideTab.isSelected());
        this.mScrollTimeDay.setEnabled(this.mProvideTab.isSelected());
        this.mScrollTimeNext.setEnabled(this.mProvideTab.isSelected());
        this.mProvideTab.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                timeButtonBehaviour.setEnabled(e.getStateChange() == 1);
                FavoritesSettingTab.this.mScrollTimeDay.setEnabled(timeButtonBehaviour.isEnabled());
                FavoritesSettingTab.this.mScrollTimeNext.setEnabled(timeButtonBehaviour.isEnabled());
            }
        });
        timeButtonSettings.add((Component)timeButtonBehaviour, CC.xy(2, 2));
        timeButtonSettings.add((Component)this.mScrollTimeNext, CC.xy(2, 4));
        timeButtonSettings.add((Component)this.mScrollTimeDay, CC.xy(2, 6));
        builder.add((Component)timeButtonSettings, CC.xyw(2, ++y, 3));
        int filterStartType = FavoritesPlugin.getInstance().getFilterStartType();
        JPanel filterSettingsPanel = new JPanel(new FormLayout("10dlu,default:grow", "default,2dlu,default,1dlu,default,1dlu,default,1dlu,default,3dlu,default"));
        this.mFilterStartAll = new JRadioButton(mLocalizer.msg("filterStartAll", "Show all filter"), filterStartType == 0);
        this.mFilterStartDefault = new JRadioButton(mLocalizer.msg("filterStartDefault", "Default filter"), filterStartType == 1);
        this.mFilterStartCurrent = new JRadioButton(mLocalizer.msg("filterStartCurrent", "Current TV-Browser filter"), filterStartType == 2);
        this.mFilterStartLast = new JRadioButton(mLocalizer.msg("filterStartLast", "Last used filter"), filterStartType == -1);
        ButtonGroup filterStartGroup = new ButtonGroup();
        filterStartGroup.add(this.mFilterStartAll);
        filterStartGroup.add(this.mFilterStartDefault);
        filterStartGroup.add(this.mFilterStartCurrent);
        filterStartGroup.add(this.mFilterStartLast);
        this.mFilterReactOnChange = new JCheckBox(mLocalizer.msg("filterReactOnChange", "React on changes of selected filter of TV-Browser"), FavoritesPlugin.getInstance().reactOnFilterChange());
        JLabel filterStartLabel = new JLabel(mLocalizer.msg("filterStart", "Start with:"));
        filterSettingsPanel.add((Component)filterStartLabel, CC.xyw(1, 1, 2));
        filterSettingsPanel.add((Component)this.mFilterStartAll, CC.xy(2, 3));
        filterSettingsPanel.add((Component)this.mFilterStartDefault, CC.xy(2, 5));
        filterSettingsPanel.add((Component)this.mFilterStartCurrent, CC.xy(2, 7));
        filterSettingsPanel.add((Component)this.mFilterStartLast, CC.xy(2, 9));
        filterSettingsPanel.add((Component)this.mFilterReactOnChange, CC.xyw(1, 11, 2));
        builder.addSeparator(mLocalizer.msg("filter", "Program Filter"), CC.xyw(1, y += 2, 4));
        builder.add((Component)filterSettingsPanel, CC.xyw(2, y += 2, 3));
        builder.addSeparator(DefaultMarkingPrioritySelectionPanel.getTitle(), CC.xyw(1, y += 2, 4));
        this.mMarkingsPanel = DefaultMarkingPrioritySelectionPanel.createPanel(FavoritesPlugin.getInstance().getMarkPriority(), false, false);
        builder.add((Component)this.mMarkingsPanel, CC.xyw(2, y += 2, 3));
        return builder.getPanel();
    }

    private void handlePluginSelection() {
        ArrayList<ProgramReceiveIf> plugins = new ArrayList<ProgramReceiveIf>();
        if (this.mClientPluginTargets != null) {
            for (ProgramReceiveTarget element : this.mClientPluginTargets) {
                if (plugins.contains(element.getReceifeIfForIdOfTarget())) continue;
                plugins.add(element.getReceifeIfForIdOfTarget());
            }
            ProgramReceiveIf[] mClientPlugins = plugins.toArray(new ProgramReceiveIf[plugins.size()]);
            if (mClientPlugins.length > 0) {
                this.mPluginLabel.setText(mClientPlugins[0].toString());
                this.mPluginLabel.setEnabled(true);
            } else {
                this.mPluginLabel.setText(mLocalizer.msg("noPlugins", "No Plugins choosen"));
                this.mPluginLabel.setEnabled(false);
            }
            for (int i = 1; i < (mClientPlugins.length > 4 ? 3 : mClientPlugins.length); ++i) {
                this.mPluginLabel.setText(this.mPluginLabel.getText() + ", " + mClientPlugins[i]);
            }
            if (mClientPlugins.length > 4) {
                this.mPluginLabel.setText(this.mPluginLabel.getText() + " (" + (mClientPlugins.length - 3) + " " + mLocalizer.ellipsisMsg("otherPlugins", "others") + ")");
            }
        }
    }

    @Override
    public void saveSettings() {
        if (!Arrays.equals(this.mCurrentClientPluginTargets, this.mClientPluginTargets)) {
            Favorite[] favoriteArr;
            FavoritesPlugin.getInstance().setClientPluginTargets(this.mClientPluginTargets);
            for (Favorite favorite : favoriteArr = FavoriteTreeModel.getInstance().getFavoriteArr()) {
                favorite.handleNewGlobalReceiveTargets(this.mCurrentClientPluginTargets);
            }
        }
        FavoritesPlugin.getInstance().setIsUsingExpertMode(this.mExpertMode.isSelected());
        FavoritesPlugin.getInstance().setShowTypeSelection(this.mShowTypeSelection.isSelected());
        FavoritesPlugin.getInstance().setShowRepetitions(this.mShowRepetitions.isSelected());
        FavoritesPlugin.getInstance().setAutoSelectingReminder(this.mAutoSelectRemider.isSelected());
        FavoritesPlugin.getInstance().setMarkPriority(this.mMarkingsPanel.getSelectedPriority());
        FavoritesPlugin.getInstance().setShowDateSeparators(this.mShowDateSeparators.isSelected());
        FavoritesPlugin.getInstance().setProvideTab(this.mProvideTab.isSelected());
        FavoritesPlugin.getInstance().setTimeButtonsScrollToNextTimeInTab(this.mScrollTimeNext.isSelected());
        FavoritesPlugin.getInstance().setReactOnFilterChange(this.mFilterReactOnChange.isSelected());
        if (this.mFilterStartAll.isSelected()) {
            FavoritesPlugin.getInstance().setFilterStartType(0);
        } else if (this.mFilterStartDefault.isSelected()) {
            FavoritesPlugin.getInstance().setFilterStartType(1);
        } else if (this.mFilterStartCurrent.isSelected()) {
            FavoritesPlugin.getInstance().setFilterStartType(2);
        } else if (this.mFilterStartLast.isSelected()) {
            FavoritesPlugin.getInstance().setFilterStartType(-1);
        }
        if (this.mExclusionPanel.wasChanged()) {
            FavoritesPlugin.getInstance().setGlobalExclusions(this.mExclusionPanel.getExclusions(), this.mExclusionPanel.wasAdded() && !this.mExclusionPanel.wasEditedOrDeleted());
        }
        FavoritesPlugin.getInstance().saveFavorites();
    }

    @Override
    public Icon getIcon() {
        return FavoritesPlugin.getFavoritesIcon(16);
    }

    @Override
    public String getTitle() {
        return mLocalizer.msg("name", "Favorite programs");
    }

    static /* synthetic */ ProgramReceiveTarget[] access$102(FavoritesSettingTab x0, ProgramReceiveTarget[] x1) {
        x0.mClientPluginTargets = x1;
        return x1;
    }
}

