/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.extras.favoritesplugin.wizards;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.factories.CC;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import devplugin.Channel;
import devplugin.Plugin;
import devplugin.Program;
import devplugin.ProgramFieldType;
import devplugin.ProgramFilter;
import devplugin.ProgramInfoHelper;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.apache.commons.lang3.StringUtils;
import tvbrowser.core.ChannelList;
import tvbrowser.core.filters.FilterManagerImpl;
import tvbrowser.extras.common.DayListCellRenderer;
import tvbrowser.extras.favoritesplugin.core.Exclusion;
import tvbrowser.extras.favoritesplugin.core.Favorite;
import tvbrowser.extras.favoritesplugin.core.FavoriteFilter;
import tvbrowser.extras.favoritesplugin.wizards.AbstractWizardStep;
import tvbrowser.extras.favoritesplugin.wizards.WizardHandler;
import tvbrowser.extras.favoritesplugin.wizards.WizardStep;
import tvbrowser.ui.filter.dlgs.SelectFilterDlg;
import tvbrowser.ui.mainframe.MainFrame;
import util.ui.Localizer;
import util.ui.TimePeriodChooser;
import util.ui.UiUtilities;
import util.ui.WrapperFilter;

public class ExcludeWizardStep
extends AbstractWizardStep {
    private static final Localizer mLocalizer = Localizer.getLocalizerFor(ExcludeWizardStep.class);
    private static final int MODE_CREATE_DERIVED_FROM_PROGRAM = 0;
    private static final int MODE_CREATE_EXCLUSION = 1;
    private static final int MODE_EDIT_EXCLUSION = 2;
    private Favorite mFavorite;
    private Program mProgram;
    private Exclusion mExclusion;
    private JCheckBox mTitleCb;
    private JCheckBox mTopicCb;
    private JCheckBox mFilterCb;
    private JCheckBox mChannelCb;
    private JCheckBox mTimeCb;
    private JCheckBox mDayCb;
    private JCheckBox mEpisodeTitleCb;
    private JCheckBox mCategoryCb;
    private JTextField mTitleTf;
    private JTextField mTopicTf;
    private JTextField mEpisodeTitleTf;
    private JComboBox mFilterChooser;
    private JComboBox mChannelCB;
    private JComboBox mDayChooser;
    private JComboBox mCategoryChooser;
    private TimePeriodChooser mTimePeriodChooser;
    private String mMainQuestion;
    private String mChannelQuestion;
    private String mTopicQuestion;
    private String mCateogryQuestion;
    private String mFilterQuestion;
    private String mTimeQuestion;
    private String mTitleQuestion;
    private String mEpisodeTitleQuestion;
    private String mDayQuestion;
    private String mDoneBtnText;
    private int mMode;
    private JPanel mContentPanel;
    private JButton mEditFilter;

    public ExcludeWizardStep(Favorite favorite) {
        this.init(1, favorite, null, null);
    }

    public ExcludeWizardStep(Favorite favorite, Exclusion exclusion) {
        this.init(2, favorite, null, exclusion);
    }

    public ExcludeWizardStep(Favorite favorite, Program prog) {
        this.init(0, favorite, prog, null);
    }

    private void init(int mode, Favorite favorite, Program prog, Exclusion exclusion) {
        this.mMode = mode;
        this.mFavorite = favorite;
        this.mProgram = prog;
        this.mExclusion = exclusion;
        this.mDoneBtnText = mLocalizer.msg("doneButton.exclusion", "Create exclusion criteria now");
        if (mode == 1 || mode == 2) {
            this.mMainQuestion = mLocalizer.msg("mainQuestion.edit", "What programs do you want to exclude?");
            this.mChannelQuestion = mLocalizer.msg("channelQuestion.edit", "Programs aired on this channel:");
            this.mTopicQuestion = mLocalizer.msg("topicQuestion.edit", "Programs containing this term:");
            this.mTimeQuestion = mLocalizer.msg("timeQuestion.edit", "Programs that start during this period:");
            this.mTitleQuestion = mLocalizer.msg("titleQuestion.edit", "Programs with this title:");
            this.mEpisodeTitleQuestion = mLocalizer.msg("episodeTitleQuestion.edit", "Program with this episode title:");
            this.mDayQuestion = mLocalizer.msg("dayOfWeekQuestion.edit", "Programs on this day of week:");
            this.mFilterQuestion = mLocalizer.msg("filterQuestion.edit", "Programs of the filter:");
            this.mCateogryQuestion = mLocalizer.msg("categoryQuestion.edit", "Programs with category:");
        } else {
            this.mMainQuestion = this.mFavorite != null ? mLocalizer.msg("mainQuestion.create", "Warum gehoert diese Sendung nicht zur Lieblingssendung '{0}'?", this.mFavorite.getName()) : mLocalizer.msg("mainQuestion.createGlobal", "Why do you want exclude this program?");
            this.mChannelQuestion = mLocalizer.msg("channelQuestion.create", "Wrong channel:");
            this.mTopicQuestion = mLocalizer.msg("topicQuestion.create", "Wrong topic:");
            this.mTimeQuestion = mLocalizer.msg("timeQuestion.create", "Wrong start time:");
            this.mTitleQuestion = mLocalizer.msg("titleQuestion.create", "Wrong episode title:");
            this.mEpisodeTitleQuestion = mLocalizer.msg("episodeTitleQuestion.create", "Wrong episode number:");
            this.mDayQuestion = mLocalizer.msg("dayOfWeekQuestion.create", "Wrong day:");
            this.mCateogryQuestion = mLocalizer.msg("categoryQuestion.create", "Wrong category:");
        }
    }

    @Override
    public String getTitle() {
        return mLocalizer.msg("title", "Exclude Programs");
    }

    @Override
    public JPanel createContent(final WizardHandler handler) {
        this.mTitleCb = new JCheckBox(this.mTitleQuestion);
        this.mTitleTf = new JTextField();
        this.mFilterCb = new JCheckBox(this.mFilterQuestion);
        this.mEditFilter = new JButton(SelectFilterDlg.mLocalizer.msg("title", "Edit Filters"));
        ProgramFilter[] avilableFilter = FilterManagerImpl.getInstance().getAvailableFilters();
        ArrayList<WrapperFilter> useableFilter = new ArrayList<WrapperFilter>();
        for (ProgramFilter filter : avilableFilter) {
            if (filter instanceof FavoriteFilter) continue;
            useableFilter.add(new WrapperFilter(filter));
        }
        this.mFilterChooser = new JComboBox<WrapperFilter>(useableFilter.toArray(new WrapperFilter[useableFilter.size()]));
        this.mDayChooser = new JComboBox<Object>(new Object[]{-3, -2, 2, 3, 4, 5, 6, 7, 1});
        this.mDayChooser.setRenderer(new DayListCellRenderer());
        FormLayout layout = new FormLayout("5dlu, pref, default:grow, 3dlu, default", "pref, 5dlu, pref, 5dlu, pref, 5dlu, pref, 5dlu, pref, 5dlu, pref, 5dlu, pref, 5dlu, pref");
        PanelBuilder panelBuilder = new PanelBuilder(layout);
        this.mCategoryChooser = new JComboBox<String>(ProgramInfoHelper.getInfoIconMessages());
        this.mChannelCB = new JComboBox<Channel>(ChannelList.getSubscribedChannels());
        int rowInx = 3;
        panelBuilder.add((Component)new JLabel(this.mMainQuestion), CC.xyw(1, 1, 5));
        panelBuilder.add((Component)this.mTitleCb, CC.xy(2, rowInx));
        panelBuilder.add((Component)this.mTitleTf, CC.xyw(3, rowInx, 3));
        this.mTopicCb = new JCheckBox(this.mTopicQuestion);
        panelBuilder.add((Component)this.mTopicCb, CC.xy(2, rowInx += 2));
        this.mTopicTf = new JTextField();
        panelBuilder.add((Component)this.mTopicTf, CC.xyw(3, rowInx, 3));
        this.mEpisodeTitleCb = new JCheckBox(this.mEpisodeTitleQuestion);
        panelBuilder.add((Component)this.mEpisodeTitleCb, CC.xy(2, rowInx += 2));
        this.mEpisodeTitleTf = new JTextField();
        panelBuilder.add((Component)this.mEpisodeTitleTf, CC.xyw(3, rowInx, 3));
        int filterIndex = rowInx += 2;
        this.mCategoryCb = new JCheckBox(this.mCateogryQuestion);
        panelBuilder.add((Component)this.mCategoryCb, CC.xy(2, rowInx));
        panelBuilder.add((Component)this.mCategoryChooser, CC.xyw(3, rowInx, 3));
        this.mChannelCb = new JCheckBox(this.mChannelQuestion);
        panelBuilder.add((Component)this.mChannelCb, CC.xy(2, rowInx += 2));
        panelBuilder.add((Component)this.mChannelCB, CC.xyw(3, rowInx, 3));
        this.mDayCb = new JCheckBox(this.mDayQuestion);
        panelBuilder.add((Component)this.mDayCb, CC.xy(2, rowInx += 2));
        panelBuilder.add((Component)this.mDayChooser, CC.xyw(3, rowInx, 3));
        this.mTimeCb = new JCheckBox(this.mTimeQuestion);
        panelBuilder.add((Component)this.mTimeCb, CC.xy(2, rowInx += 2));
        this.mTimePeriodChooser = new TimePeriodChooser(0);
        panelBuilder.add((Component)this.mTimePeriodChooser, CC.xyw(3, rowInx, 3));
        if (this.mMode == 2 || this.mMode == 1) {
            layout.insertRow(filterIndex, RowSpec.decode("pref"));
            layout.insertRow(filterIndex + 1, RowSpec.decode("5dlu"));
            panelBuilder.add((Component)this.mFilterCb, CC.xy(2, filterIndex));
            panelBuilder.add((Component)this.mFilterChooser, CC.xy(3, filterIndex));
            this.mEditFilter.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SelectFilterDlg filterDlg = SelectFilterDlg.create(UiUtilities.getLastModalChildOf(MainFrame.getInstance()));
                    filterDlg.setVisible(true);
                    Object selected = ExcludeWizardStep.this.mFilterChooser.getSelectedItem();
                    ((DefaultComboBoxModel)ExcludeWizardStep.this.mFilterChooser.getModel()).removeAllElements();
                    for (ProgramFilter filter : Plugin.getPluginManager().getFilterManager().getAvailableFilters()) {
                        ((DefaultComboBoxModel)ExcludeWizardStep.this.mFilterChooser.getModel()).addElement(filter);
                    }
                    ExcludeWizardStep.this.mFilterChooser.setSelectedItem(selected);
                }
            });
            panelBuilder.add((Component)this.mEditFilter, CC.xy(5, filterIndex));
        }
        if (this.mMode == 0 && this.mProgram != null) {
            this.mTitleCb.setSelected(false);
            this.mDoneBtnText = mLocalizer.msg("doneButton.toBlacklist", "Remove this program now");
            this.mTitleTf.setText(this.mProgram.getTitle());
            String episode = this.mProgram.getTextField(ProgramFieldType.EPISODE_TYPE);
            if (episode != null && episode.trim().length() > 0) {
                this.mEpisodeTitleTf.setText(episode);
            }
            this.mChannelCB.setSelectedItem(this.mProgram.getChannel());
            int timeFrom = (this.mProgram.getHours() - 1) * 60;
            int timeTo = (this.mProgram.getHours() + 1) * 60;
            if (timeFrom < 0) {
                timeFrom = 0;
            }
            if (timeTo > 1439) {
                timeTo = 1439;
            }
            this.mTimePeriodChooser.setFromTime(timeFrom);
            this.mTimePeriodChooser.setToTime(timeTo);
            this.mDayChooser.setSelectedItem(this.mProgram.getDate().getCalendar().get(7));
        } else if (this.mMode == 2) {
            String title = this.mExclusion.getTitle();
            String topic = this.mExclusion.getTopic();
            String episode = this.mExclusion.getEpisodeTitle();
            ProgramFilter filter = this.mExclusion.getFilter();
            Channel channel = this.mExclusion.getChannel();
            int timeFrom = this.mExclusion.getTimeLowerBound();
            int timeTo = this.mExclusion.getTimeUpperBound();
            int dayOfWeek = this.mExclusion.getDayOfWeek();
            int bitIndex = ProgramInfoHelper.getIndexForBit(this.mExclusion.getCategory());
            if (title != null) {
                this.mTitleCb.setSelected(true);
                this.mTitleTf.setText(title);
            }
            if (episode != null) {
                this.mEpisodeTitleCb.setSelected(true);
                this.mEpisodeTitleTf.setText(episode);
            }
            if (topic != null) {
                this.mTopicCb.setSelected(true);
                this.mTopicTf.setText(topic);
            }
            if (filter != null) {
                this.mFilterCb.setSelected(true);
                this.mFilterChooser.setSelectedItem(filter);
            }
            if (channel != null) {
                this.mChannelCb.setSelected(true);
                this.mChannelCB.setSelectedItem(channel);
            }
            if (timeFrom >= 0 && timeTo >= 0) {
                this.mTimeCb.setSelected(true);
                this.mTimePeriodChooser.setFromTime(timeFrom);
                this.mTimePeriodChooser.setToTime(timeTo);
                this.mDayChooser.setSelectedItem(this.mExclusion.getDayOfWeek());
            }
            if (dayOfWeek != -1) {
                this.mDayCb.setSelected(true);
                this.mDayChooser.setSelectedItem(dayOfWeek);
            }
            if (bitIndex != -1) {
                this.mCategoryCb.setSelected(true);
                this.mCategoryChooser.setSelectedIndex(bitIndex);
            }
        }
        this.updateButtons(handler);
        ItemListener buttonUpdate = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                ExcludeWizardStep.this.updateButtons(handler);
            }
        };
        this.mChannelCb.addItemListener(buttonUpdate);
        this.mTitleCb.addItemListener(buttonUpdate);
        this.mTopicCb.addItemListener(buttonUpdate);
        this.mEpisodeTitleCb.addItemListener(buttonUpdate);
        this.mCategoryCb.addItemListener(buttonUpdate);
        this.mFilterCb.addItemListener(buttonUpdate);
        this.mTimeCb.addItemListener(buttonUpdate);
        this.mDayCb.addItemListener(buttonUpdate);
        this.mContentPanel = panelBuilder.getPanel();
        return this.mContentPanel;
    }

    private void updateButtons(WizardHandler handler) {
        boolean allowNext = false;
        if (this.mChannelCb.isSelected()) {
            allowNext = true;
        }
        if (this.mTopicCb.isSelected()) {
            allowNext = true;
        }
        if (this.mFilterCb.isSelected()) {
            allowNext = true;
        }
        if (this.mTimeCb.isSelected()) {
            allowNext = true;
        }
        if (this.mTitleCb.isSelected()) {
            allowNext = true;
        }
        this.mTitleTf.setEnabled(this.mTitleCb.isSelected());
        if (this.mDayCb.isSelected()) {
            allowNext = true;
        }
        if (this.mEpisodeTitleCb.isSelected()) {
            allowNext = true;
        }
        if (this.mCategoryCb.isSelected()) {
            allowNext = true;
        }
        this.mChannelCB.setEnabled(this.mChannelCb.isSelected());
        this.mTopicTf.setEnabled(this.mTopicCb.isSelected());
        this.mEpisodeTitleTf.setEnabled(this.mEpisodeTitleCb.isSelected());
        this.mFilterChooser.setEnabled(this.mFilterCb.isSelected());
        this.mEditFilter.setEnabled(this.mFilterCb.isSelected());
        this.mTimePeriodChooser.setEnabled(this.mTimeCb.isSelected());
        this.mDayChooser.setEnabled(this.mDayCb.isSelected());
        this.mCategoryChooser.setEnabled(this.mCategoryCb.isSelected());
        if (this.mMode == 0 && this.mProgram != null) {
            this.mDoneBtnText = allowNext || this.mFavorite == null ? mLocalizer.msg("doneButton.exclusion", "Create exclusion criteria now") : mLocalizer.msg("doneButton.toBlacklist", "Only remove this program now");
            handler.changeDoneBtnText();
            handler.allowFinish(allowNext || this.mFavorite != null);
        } else {
            handler.allowFinish(allowNext);
        }
    }

    @Override
    public Object createDataObject(Object obj) {
        String title = null;
        String topic = null;
        String episodeTitle = null;
        String filterName = null;
        Channel channel = null;
        int timeFrom = -1;
        int timeTo = -1;
        int weekOfDay = -1;
        int category = 0;
        if (this.mTitleCb.isSelected()) {
            title = this.mTitleTf.getText();
        }
        if (this.mTopicCb.isSelected()) {
            topic = this.mTopicTf.getText();
        }
        if (this.mEpisodeTitleCb.isSelected()) {
            episodeTitle = this.mEpisodeTitleTf.getText();
        }
        if (this.mFilterCb.isSelected()) {
            filterName = ((WrapperFilter)this.mFilterChooser.getSelectedItem()).getName();
        }
        if (this.mChannelCb.isSelected()) {
            channel = (Channel)this.mChannelCB.getSelectedItem();
        }
        if (this.mTimeCb.isSelected()) {
            timeFrom = this.mTimePeriodChooser.getFromTime();
            timeTo = this.mTimePeriodChooser.getToTime();
        }
        if (this.mDayCb.isSelected()) {
            weekOfDay = (Integer)this.mDayChooser.getSelectedItem();
        }
        if (this.mCategoryCb.isSelected()) {
            category = ProgramInfoHelper.getBitForIndex(this.mCategoryChooser.getSelectedIndex());
        }
        if (this.mDoneBtnText.compareTo(mLocalizer.msg("doneButton.toBlacklist", "Remove this program now")) == 0) {
            return "blacklist";
        }
        return new Exclusion(title, topic, channel, timeFrom, timeTo, weekOfDay, filterName, episodeTitle, category);
    }

    @Override
    public int[] getButtons() {
        return new int[]{2, 4};
    }

    @Override
    public WizardStep next() {
        return null;
    }

    @Override
    public WizardStep back() {
        return null;
    }

    @Override
    public boolean isValid() {
        if (this.mTitleCb.isSelected() && StringUtils.isBlank(this.mTitleTf.getText())) {
            JOptionPane.showMessageDialog(this.mContentPanel, mLocalizer.msg("invalidInput.noTitle", "Please enter a title."), mLocalizer.msg("invalidInput.noTitleTitle", "Enter Topic"), 2);
            return false;
        }
        if (this.mTopicCb.isSelected() && StringUtils.isBlank(this.mTopicTf.getText())) {
            JOptionPane.showMessageDialog(this.mContentPanel, mLocalizer.msg("invalidInput.noTopic", "Please enter a topic."), mLocalizer.msg("invalidInput.noTopicTitle", "Enter Topic"), 2);
            return false;
        }
        return true;
    }

    @Override
    public boolean isSingleStep() {
        return true;
    }

    @Override
    public String getDoneBtnText() {
        return this.mDoneBtnText;
    }
}

