/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.extras.favoritesplugin.wizards;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import devplugin.Program;
import java.awt.Component;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import tvbrowser.extras.favoritesplugin.FavoritesPlugin;
import tvbrowser.extras.favoritesplugin.core.Favorite;
import tvbrowser.extras.favoritesplugin.wizards.AbstractWizardStep;
import tvbrowser.extras.favoritesplugin.wizards.LimitationsWizardStep;
import tvbrowser.extras.favoritesplugin.wizards.WizardHandler;
import tvbrowser.extras.favoritesplugin.wizards.WizardStep;
import util.ui.Localizer;

public class NotificationWizardStep
extends AbstractWizardStep {
    private static final Localizer mLocalizer = Localizer.getLocalizerFor(NotificationWizardStep.class);
    private JCheckBox mReminderCb;
    private JCheckBox mCheckOnUpdateCb;
    private Program mProgram;
    private WizardStep mCaller;

    public NotificationWizardStep(WizardStep caller, Program prog) {
        this.mProgram = prog;
        this.mCaller = caller;
    }

    @Override
    public String getTitle() {
        return mLocalizer.msg("title", "Notification");
    }

    @Override
    public JPanel createContent(WizardHandler handler) {
        CellConstraints cc = new CellConstraints();
        PanelBuilder panelBuilder = new PanelBuilder(new FormLayout("pref", "pref, 5dlu, pref, 5dlu, pref, 5dlu, pref"));
        panelBuilder.border(Borders.DLU4);
        panelBuilder.add((Component)new JLabel(mLocalizer.msg("mainQuestion", "Wollen Sie automatisch auf diese Sendung hingewiesen werden?")), cc.xy(1, 1));
        this.mReminderCb = new JCheckBox(mLocalizer.msg("option.remind", "Automatisch an diese Sendung erinnern."));
        panelBuilder.add((Component)this.mReminderCb, cc.xy(1, 3));
        this.mCheckOnUpdateCb = new JCheckBox(mLocalizer.msg("option.checkAfterUpdate", "Sofort alarmieren, wenn die Sendung nach einer Aktualisierung gefunden wird."));
        panelBuilder.add((Component)this.mCheckOnUpdateCb, cc.xy(1, 5));
        this.mReminderCb.setSelected(FavoritesPlugin.getInstance().isAutoSelectingReminder());
        JPanel result = panelBuilder.getPanel();
        result.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent e) {
                NotificationWizardStep.this.mReminderCb.requestFocusInWindow();
            }
        });
        return result;
    }

    @Override
    public Object createDataObject(Object obj) {
        Favorite fav = (Favorite)obj;
        fav.setRemindAfterDownload(this.mCheckOnUpdateCb.isSelected());
        if (this.mReminderCb.isSelected()) {
            fav.getReminderConfiguration().setReminderServices(new String[]{"window"});
        } else {
            fav.getReminderConfiguration().setReminderServices(new String[0]);
        }
        return fav;
    }

    @Override
    public WizardStep next() {
        return new LimitationsWizardStep(this, this.mProgram);
    }

    @Override
    public WizardStep back() {
        return this.mCaller;
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    public int[] getButtons() {
        return new int[]{2, 4, 3, 1};
    }
}

