/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.extras.programinfo;

import devplugin.ActionMenu;
import devplugin.AfterDataUpdateInfoPanel;
import devplugin.ContextMenuIf;
import devplugin.PluginCenterPanelWrapper;
import devplugin.Program;
import devplugin.SettingsTab;
import javax.swing.Icon;
import tvbrowser.core.icontheme.IconLoader;
import tvbrowser.extras.common.AbstractInternalPluginProxy;
import tvbrowser.extras.programinfo.ProgramInfo;
import tvbrowser.extras.programinfo.ProgramInfoSettingsTab;

public class ProgramInfoProxy
extends AbstractInternalPluginProxy
implements ContextMenuIf {
    private static ProgramInfoProxy mInstance;

    private ProgramInfoProxy() {
        mInstance = this;
    }

    public static synchronized ProgramInfoProxy getInstance() {
        if (mInstance == null) {
            new ProgramInfoProxy();
        }
        return mInstance;
    }

    @Override
    public ActionMenu getContextMenuActions(Program program) {
        return ProgramInfo.getInstance().getContextMenuActions(program);
    }

    @Override
    public String getId() {
        return ProgramInfo.getProgramInfoPluginId();
    }

    public String toString() {
        return ProgramInfo.getName();
    }

    @Override
    public String getButtonActionDescription() {
        return ProgramInfo.mLocalizer.msg("description", "Shows details about a program.");
    }

    @Override
    public Icon getIcon() {
        return IconLoader.getInstance().getIconFromTheme("actions", "edit-find", 16);
    }

    @Override
    public String getName() {
        return this.toString();
    }

    @Override
    public String getSettingsId() {
        return "#programinfo";
    }

    @Override
    public SettingsTab getSettingsTab() {
        return new ProgramInfoSettingsTab();
    }

    @Override
    public void handleTvDataUpdateFinished() {
    }

    @Override
    public String getPluginCategory() {
        return "misc";
    }

    @Override
    public PluginCenterPanelWrapper getPluginCenterPanelWrapper() {
        return null;
    }

    @Override
    public AfterDataUpdateInfoPanel getAfterDataUpdateInfoPanel() {
        return null;
    }

    @Override
    public void handleTvBrowserStartFinished() {
        ProgramInfo.getInstance().handleTvBrowserStartFinished();
    }
}

