/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.extras.programinfo;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.l2fprod.common.swing.plaf.LookAndFeelAddons;
import devplugin.Plugin;
import devplugin.PluginAccess;
import devplugin.ProgramReceiveTarget;
import devplugin.SettingsTab;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Enumeration;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.SpinnerNumberModel;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import tvbrowser.core.icontheme.IconLoader;
import tvbrowser.core.plugin.PluginManagerImpl;
import tvbrowser.extras.programinfo.ProgramInfo;
import tvbrowser.extras.programinfo.ProgramInfoDialog;
import tvbrowser.extras.programinfo.ProgramInfoSettings;
import tvbrowser.ui.settings.util.ColorButton;
import tvbrowser.ui.settings.util.ColorLabel;
import util.program.ProgramTextCreator;
import util.ui.EnhancedPanelBuilder;
import util.ui.FontChooserPanel;
import util.ui.Localizer;
import util.ui.OrderChooser;
import util.ui.PluginsPictureSettingsPanel;
import util.ui.ScrollableJPanel;

public class ProgramInfoSettingsTab
implements SettingsTab {
    private OrderChooser mList;
    private Object[] mOldOrder;
    private boolean mOldSetupState;
    private PluginsPictureSettingsPanel mPictureSettings;
    private JCheckBox mZoomEnabled;
    private JSpinner mZoomValue;
    private JCheckBox mUserFont;
    private JCheckBox mAntiAliasing;
    private FontChooserPanel mTitleFont;
    private FontChooserPanel mBodyFont;
    private String mOldTitleFont;
    private String mOldBodyFont;
    private int mOldTitleFontSize;
    private int mOldBodyFontSize;
    private boolean mOldUserFontSelected;
    private boolean mOldAntiAliasingSelected;
    private boolean mOldShowFunctions;
    private String mOldLook;
    private JComboBox mLook;
    private static int mCurrentTab = 0;
    private JTabbedPane mTabbedPane;
    private String[] mLf = new String[]{"com.l2fprod.common.swing.plaf.aqua.AquaLookAndFeelAddons", "com.l2fprod.common.swing.plaf.metal.MetalLookAndFeelAddons", "com.l2fprod.common.swing.plaf.motif.MotifLookAndFeelAddons", "com.l2fprod.common.swing.plaf.windows.WindowsLookAndFeelAddons", "com.l2fprod.common.swing.plaf.windows.WindowsClassicLookAndFeelAddons"};
    private JCheckBox mShowFunctions;
    private JCheckBox mShowTextSearchButton;
    private ButtonGroup mAvailableTargetGroup;
    private JCheckBox mPersonSearchCB;
    private JCheckBox mHighlight;
    private ColorLabel mHighlightColorLb;
    private ColorButton mHighlightButton;
    private int mOldTitleStyle;
    private int mOldBodyStyle;

    @Override
    public JPanel createSettingsPanel() {
        ProgramReceiveTarget[] targets;
        ProgramInfoSettings settings = ProgramInfo.getInstance().getSettings();
        this.mOldAntiAliasingSelected = settings.getAntialiasing();
        this.mOldUserFontSelected = settings.getUserFont();
        this.mOldTitleFontSize = settings.getTitleFontSize();
        this.mOldBodyFontSize = settings.getBodyFontSize();
        this.mOldTitleFont = settings.getTitleFontName();
        this.mOldBodyFont = settings.getBodyFontName();
        this.mOldTitleStyle = settings.getTitleFontStyle();
        this.mOldBodyStyle = settings.getBodyFontStyle();
        this.mAntiAliasing = new JCheckBox(ProgramInfo.mLocalizer.msg("antialiasing", "Antialiasing"));
        this.mAntiAliasing.setSelected(this.mOldAntiAliasingSelected);
        this.mUserFont = new JCheckBox(ProgramInfo.mLocalizer.msg("userfont", "Use user fonts"));
        this.mUserFont.setSelected(this.mOldUserFontSelected);
        this.mTitleFont = new FontChooserPanel(null, new Font(this.mOldTitleFont, this.mOldTitleStyle, this.mOldTitleFontSize), true);
        this.mTitleFont.setBorder(BorderFactory.createEmptyBorder());
        this.mTitleFont.setAlignmentX(0.0f);
        this.mBodyFont = new FontChooserPanel(null, new Font(this.mOldBodyFont, this.mOldBodyStyle, this.mOldBodyFontSize), true);
        this.mBodyFont.setBorder(BorderFactory.createEmptyBorder());
        this.mBodyFont.setAlignmentX(0.0f);
        this.mTitleFont.setEnabled(this.mUserFont.isSelected());
        this.mBodyFont.setEnabled(this.mUserFont.isSelected());
        this.mOldLook = settings.getLook();
        String[] lf = new String[]{"Aqua", "Metal", "Motif", "Windows XP", "Windows Classic"};
        this.mLook = new JComboBox<String>(lf);
        String look = this.mOldLook.length() > 0 ? this.mOldLook : LookAndFeelAddons.getBestMatchAddonClassName();
        for (int i = 0; i < this.mLf.length; ++i) {
            if (look.toLowerCase().indexOf(this.mLf[i].toLowerCase()) == -1) continue;
            this.mLook.setSelectedIndex(i);
            break;
        }
        this.mOldShowFunctions = settings.getShowFunctions();
        this.mShowFunctions = new JCheckBox(ProgramInfo.mLocalizer.msg("showFunctions", "Show Functions"), settings.getShowFunctions());
        this.mShowTextSearchButton = new JCheckBox(ProgramInfo.mLocalizer.msg("showTextSearchButton", "Show \"Search in program\""), ProgramInfo.getInstance().getSettings().getShowSearchButton());
        this.mShowTextSearchButton.setEnabled(this.mShowFunctions.isSelected());
        this.mShowFunctions.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProgramInfoSettingsTab.this.mShowTextSearchButton.setEnabled(ProgramInfoSettingsTab.this.mShowFunctions.isSelected());
            }
        });
        this.mHighlight = new JCheckBox(ProgramInfoDialog.mLocalizer.msg("highlight", "Highlight favorite matches"), settings.getHighlightFavorite());
        this.mHighlight.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProgramInfoSettingsTab.this.mHighlightColorLb.setEnabled(ProgramInfoSettingsTab.this.mHighlight.isSelected());
                ProgramInfoSettingsTab.this.mHighlightButton.setEnabled(ProgramInfoSettingsTab.this.mHighlight.isSelected());
            }
        });
        CellConstraints cc = new CellConstraints();
        EnhancedPanelBuilder formatPanel = new EnhancedPanelBuilder(new FormLayout("5dlu,10dlu,pref,pref,5dlu,default:grow,pref,5dlu"));
        formatPanel.border(Borders.DIALOG);
        formatPanel.addParagraph(ProgramInfo.mLocalizer.msg("font", "Font settings"));
        formatPanel.addRow();
        formatPanel.add((Component)this.mAntiAliasing, cc.xyw(2, formatPanel.getRowCount(), formatPanel.getColumnCount() - 2));
        formatPanel.addRow();
        formatPanel.add((Component)this.mUserFont, cc.xyw(2, formatPanel.getRowCount(), formatPanel.getColumnCount() - 2));
        formatPanel.addRow();
        final JLabel titleLabel = new JLabel(ProgramInfo.mLocalizer.msg("title", "Title font"));
        formatPanel.add((Component)titleLabel, cc.xy(3, formatPanel.getRowCount()));
        formatPanel.add((Component)this.mTitleFont, cc.xyw(6, formatPanel.getRowCount(), 2));
        formatPanel.addRow();
        final JLabel bodyLabel = new JLabel(ProgramInfo.mLocalizer.msg("body", "Description font"));
        formatPanel.add((Component)bodyLabel, cc.xy(3, formatPanel.getRowCount()));
        formatPanel.add((Component)this.mBodyFont, cc.xyw(6, formatPanel.getRowCount(), 2));
        this.mUserFont.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                ProgramInfoSettingsTab.this.mTitleFont.setEnabled(ProgramInfoSettingsTab.this.mUserFont.isSelected());
                ProgramInfoSettingsTab.this.mBodyFont.setEnabled(ProgramInfoSettingsTab.this.mUserFont.isSelected());
                titleLabel.setEnabled(ProgramInfoSettingsTab.this.mUserFont.isSelected());
                bodyLabel.setEnabled(ProgramInfoSettingsTab.this.mUserFont.isSelected());
            }
        });
        this.mTitleFont.setEnabled(this.mUserFont.isSelected());
        this.mBodyFont.setEnabled(this.mUserFont.isSelected());
        titleLabel.setEnabled(this.mUserFont.isSelected());
        bodyLabel.setEnabled(this.mUserFont.isSelected());
        formatPanel.addParagraph(ProgramInfo.mLocalizer.msg("design", "Design"));
        formatPanel.addRow();
        formatPanel.add((Component)this.mLook, cc.xyw(2, formatPanel.getRowCount(), 2));
        formatPanel.addParagraph(ProgramInfoDialog.mLocalizer.msg("functions", "Functions"));
        formatPanel.addRow();
        formatPanel.add((Component)this.mShowFunctions, cc.xyw(2, formatPanel.getRowCount(), formatPanel.getColumnCount() - 2));
        formatPanel.addRow();
        formatPanel.add((Component)this.mShowTextSearchButton, cc.xyw(3, formatPanel.getRowCount(), formatPanel.getColumnCount() - 3));
        formatPanel.addParagraph(ProgramInfo.mLocalizer.msg("favorites", "Favorites"));
        formatPanel.addRow();
        formatPanel.add((Component)this.mHighlight, cc.xyw(2, formatPanel.getRowCount(), 5));
        JPanel panel = new JPanel(new FlowLayout());
        this.mHighlightColorLb = new ColorLabel(settings.getHighlightColor());
        panel.add(this.mHighlightColorLb);
        this.mHighlightColorLb.setStandardColor(settings.getHighlightColor());
        this.mHighlightButton = new ColorButton(this.mHighlightColorLb);
        panel.add(this.mHighlightButton);
        this.mHighlight.getActionListeners()[0].actionPerformed(null);
        formatPanel.add((Component)panel, cc.xy(7, formatPanel.getRowCount()));
        this.mOldOrder = settings.getFieldOrder();
        this.mOldSetupState = ProgramInfo.getInstance().getSettings().getSetupwasdone();
        this.mList = new OrderChooser(this.mOldOrder, ProgramTextCreator.getDefaultOrderWithActivatedPluginInfo(), true);
        JButton previewBtn = new JButton(ProgramInfo.mLocalizer.msg("preview", "Preview"));
        previewBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProgramInfoSettingsTab.this.saveSettings();
                ProgramInfo.getInstance().showProgramInformation(Plugin.getPluginManager().getExampleProgram(), false);
                ProgramInfoSettingsTab.this.restoreSettings();
            }
        });
        JButton defaultBtn = new JButton(ProgramInfo.mLocalizer.msg("default", "Default"));
        defaultBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ProgramInfoSettingsTab.this.resetSettings();
            }
        });
        EnhancedPanelBuilder orderPanel = new EnhancedPanelBuilder("default:grow");
        orderPanel.border(Borders.DIALOG);
        orderPanel.addRow("fill:default:grow");
        orderPanel.add((Component)this.mList, cc.xy(1, orderPanel.getRowCount()));
        EnhancedPanelBuilder picturePanel = new EnhancedPanelBuilder("default:grow");
        picturePanel.border(Borders.DIALOG);
        picturePanel.addRow("default");
        this.mPictureSettings = new PluginsPictureSettingsPanel(ProgramInfo.getInstance().getPictureSettings(), false);
        picturePanel.add((Component)this.mPictureSettings, cc.xy(1, picturePanel.getRowCount()));
        PanelBuilder pb = new PanelBuilder(new FormLayout("default,2dlu,default,5dlu,default", "default"));
        this.mZoomEnabled = new JCheckBox(ProgramInfo.mLocalizer.msg("scaleImage", "Scale picture:"), ProgramInfo.getInstance().getSettings().getZoomEnabled());
        pb.add((Component)this.mZoomEnabled, cc.xy(1, 1));
        this.mZoomValue = new JSpinner(new SpinnerNumberModel(ProgramInfo.getInstance().getSettings().getZoomValue(), 50, 300, 1));
        pb.add((Component)this.mZoomValue, cc.xy(3, 1));
        final JLabel label = pb.addLabel("%", cc.xy(5, 1));
        this.mZoomEnabled.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                ProgramInfoSettingsTab.this.mZoomValue.setEnabled(ProgramInfoSettingsTab.this.mZoomEnabled.isSelected());
                label.setEnabled(ProgramInfoSettingsTab.this.mZoomEnabled.isSelected());
            }
        });
        this.mZoomValue.setEnabled(this.mZoomEnabled.isSelected());
        label.setEnabled(this.mZoomEnabled.isSelected());
        picturePanel.addRow("5dlu");
        picturePanel.addRow("default");
        picturePanel.add((Component)pb.getPanel(), cc.xy(1, picturePanel.getRowCount()));
        PluginAccess webPlugin = PluginManagerImpl.getInstance().getActivatedPluginForId("java.webplugin.WebPlugin");
        this.mAvailableTargetGroup = new ButtonGroup();
        final ArrayList<InternalRadioButton<Object>> availableDefaultTargets = new ArrayList<InternalRadioButton<Object>>();
        availableDefaultTargets.add(new InternalRadioButton<String>(ProgramInfoDialog.mLocalizer.msg("searchTvBrowser", "Search in TV-Browser")));
        this.mAvailableTargetGroup.add((AbstractButton)availableDefaultTargets.get(0));
        availableDefaultTargets.add(new InternalRadioButton<String>(ProgramInfoDialog.mLocalizer.msg("searchWikipedia", "Search in Wikipedia")));
        this.mAvailableTargetGroup.add((AbstractButton)availableDefaultTargets.get(1));
        String currentValue = settings.getActorSearch();
        int selectedIndex = -1;
        if (webPlugin != null && webPlugin.canReceiveProgramsWithTarget() && (targets = webPlugin.getProgramReceiveTargets()) != null) {
            for (ProgramReceiveTarget target : targets) {
                availableDefaultTargets.add(new InternalRadioButton<ProgramReceiveTarget>(target));
                this.mAvailableTargetGroup.add((AbstractButton)availableDefaultTargets.get(availableDefaultTargets.size() - 1));
                if (!currentValue.equals(target.getReceiveIfId() + "#_#_#" + target.getTargetId())) continue;
                selectedIndex = availableDefaultTargets.size() - 1;
            }
        }
        if (selectedIndex == -1) {
            selectedIndex = currentValue.equals("internalSearch") ? 0 : 1;
        }
        ((InternalRadioButton)availableDefaultTargets.get(selectedIndex)).setSelected(true);
        ScrollableJPanel buttonPanel = new ScrollableJPanel();
        buttonPanel.setLayout(new BoxLayout(buttonPanel, 1));
        buttonPanel.setOpaque(false);
        for (InternalRadioButton internalRadioButton : availableDefaultTargets) {
            buttonPanel.add(internalRadioButton);
        }
        final JScrollPane scrollPane = new JScrollPane(buttonPanel);
        scrollPane.setBackground(UIManager.getDefaults().getColor("List.background"));
        scrollPane.getViewport().setBackground(UIManager.getDefaults().getColor("List.background"));
        PanelBuilder panelBuilder = new PanelBuilder(new FormLayout("default:grow", "pref,3dlu,default,1dlu,fill:default:grow"));
        panelBuilder.border(Borders.DIALOG);
        this.mPersonSearchCB = new JCheckBox(ProgramInfo.mLocalizer.msg("enableSearch", "Show person names as links to person search"));
        panelBuilder.add((Component)this.mPersonSearchCB, cc.xy(1, 1));
        final JLabel searchLabel = new JLabel(ProgramInfo.mLocalizer.msg("defaultActorSearchMethod", "Default search method:"));
        panelBuilder.add((Component)searchLabel, cc.xy(1, 3));
        panelBuilder.add((Component)scrollPane, cc.xy(1, 5));
        this.mPersonSearchCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                scrollPane.setEnabled(ProgramInfoSettingsTab.this.mPersonSearchCB.isSelected());
                searchLabel.setEnabled(ProgramInfoSettingsTab.this.mPersonSearchCB.isSelected());
                for (InternalRadioButton button : availableDefaultTargets) {
                    button.setEnabled(ProgramInfoSettingsTab.this.mPersonSearchCB.isSelected());
                }
            }
        });
        this.mPersonSearchCB.setSelected(settings.getEnableSearch());
        this.mPersonSearchCB.getActionListeners()[0].actionPerformed(null);
        this.mTabbedPane = new JTabbedPane();
        this.mTabbedPane.add(ProgramInfo.mLocalizer.msg("look", "Look"), formatPanel.getPanel());
        this.mTabbedPane.add(ProgramInfo.mLocalizer.msg("fields", "Fields"), orderPanel.getPanel());
        this.mTabbedPane.add(Localizer.getLocalization("i18n_pictures"), picturePanel.getPanel());
        this.mTabbedPane.add(ProgramInfo.mLocalizer.msg("actorSearch", "Actor search"), panelBuilder.getPanel());
        this.mTabbedPane.setSelectedIndex(mCurrentTab);
        FormLayout layout = new FormLayout("default,default:grow,default", "pref");
        layout.setColumnGroups(new int[][]{{1, 3}});
        JPanel buttonPn = new JPanel(layout);
        buttonPn.add((Component)previewBtn, cc.xy(3, 1));
        buttonPn.add((Component)defaultBtn, cc.xy(1, 1));
        JPanel base = new JPanel(new FormLayout("default:grow", "fill:default:grow,10dlu,default"));
        base.setBorder(Borders.DIALOG);
        base.add((Component)this.mTabbedPane, cc.xy(1, 1));
        base.add((Component)buttonPn, cc.xy(1, 3));
        return base;
    }

    private void resetSettings() {
        this.mList.setOrder(ProgramTextCreator.getDefaultOrderWithActivatedPluginInfo(), ProgramTextCreator.getDefaultOrderWithActivatedPluginInfo());
        this.mAntiAliasing.setSelected(false);
        this.mUserFont.setSelected(false);
        this.mZoomEnabled.setSelected(false);
        this.mZoomValue.setValue(100);
        String look = LookAndFeelAddons.getBestMatchAddonClassName();
        for (int i = 0; i < this.mLf.length; ++i) {
            if (look.toLowerCase().indexOf(this.mLf[i].toLowerCase()) == -1) continue;
            this.mLook.setSelectedIndex(i);
            break;
        }
    }

    @Override
    public void saveSettings() {
        mCurrentTab = this.mTabbedPane.getSelectedIndex();
        try {
            ProgramInfoSettings settings = ProgramInfo.getInstance().getSettings();
            settings.setZoomEnabled(this.mZoomEnabled.isSelected());
            settings.setZoomValue((Integer)this.mZoomValue.getValue());
            settings.setFieldOrder(this.mList.getOrder());
            settings.setSetupwasdone(true);
            settings.setPictureSettings(this.mPictureSettings.getSettings().getType());
            ProgramInfo.getInstance().setOrder();
            settings.setAntialiasing(this.mAntiAliasing.isSelected());
            settings.setUserFont(this.mUserFont.isSelected());
            Font f = this.mTitleFont.getChosenFont();
            settings.setTitleFontName(f.getFamily());
            settings.setTitleFontSize(f.getSize());
            settings.setTitleFontStyle(f.getStyle());
            f = this.mBodyFont.getChosenFont();
            settings.setBodyFontName(f.getFamily());
            settings.setBodyFontSize(f.getSize());
            settings.setBodyFontStyle(f.getStyle());
            settings.setLook(this.mLf[this.mLook.getSelectedIndex()]);
            ProgramInfo.getInstance().setLook();
            if (this.mShowFunctions != null) {
                settings.setShowFunctions(this.mShowFunctions.isSelected());
                if (this.mShowFunctions.isSelected() != this.mOldShowFunctions) {
                    ProgramInfoDialog.recreateInstance();
                }
            }
            if (this.mShowTextSearchButton != null) {
                settings.setShowSearchButton(this.mShowTextSearchButton.isSelected());
            }
            settings.setHighlightFavorite(this.mHighlight.isSelected());
            settings.setHighlightColor(this.mHighlightColorLb.getColor());
            Enumeration<AbstractButton> actorSearchDefault = this.mAvailableTargetGroup.getElements();
            while (actorSearchDefault.hasMoreElements()) {
                AbstractButton button = actorSearchDefault.nextElement();
                if (!button.isSelected()) continue;
                settings.setActorSearch(((InternalRadioButton)button).getValue());
                break;
            }
            settings.setEnableSearch(this.mPersonSearchCB.isSelected());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void restoreSettings() {
        ProgramInfoSettings settings = ProgramInfo.getInstance().getSettings();
        settings.setSetupwasdone(this.mOldSetupState);
        settings.setFieldOrder(this.mOldOrder);
        ProgramInfo.getInstance().setOrder();
        settings.setAntialiasing(this.mOldAntiAliasingSelected);
        settings.setUserFont(this.mOldUserFontSelected);
        settings.setTitleFontName(this.mOldTitleFont);
        settings.setTitleFontSize(this.mOldTitleFontSize);
        settings.setBodyFontName(this.mOldBodyFont);
        settings.setBodyFontSize(this.mOldBodyFontSize);
        settings.setTitleFontStyle(this.mOldTitleStyle);
        settings.setBodyFontStyle(this.mOldBodyStyle);
        settings.setLook(this.mOldLook);
        ProgramInfo.getInstance().setLook();
        settings.setShowFunctions(this.mOldShowFunctions);
        ProgramInfoDialog.recreateInstance();
    }

    @Override
    public Icon getIcon() {
        return IconLoader.getInstance().getIconFromTheme("actions", "edit-find", 16);
    }

    @Override
    public String getTitle() {
        return ProgramInfo.getInstance().toString();
    }

    private static class InternalRadioButton<T>
    extends JRadioButton {
        private T mValue;

        protected InternalRadioButton(T value) {
            super(value.toString());
            this.mValue = value;
            this.setOpaque(false);
        }

        protected String getValue() {
            if (this.mValue instanceof String) {
                if (this.mValue.equals(ProgramInfoDialog.mLocalizer.msg("searchTvBrowser", "Search in TV-Browser"))) {
                    return "internalSearch";
                }
                return "internalWikipedia";
            }
            if (this.mValue instanceof ProgramReceiveTarget) {
                ProgramReceiveTarget target = (ProgramReceiveTarget)this.mValue;
                return target.getReceiveIfId() + "#_#_#" + target.getTargetId();
            }
            return "internalWikipedia";
        }
    }
}

