/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.extras.reminderplugin;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.table.DefaultTableCellRenderer;
import tvbrowser.core.plugin.PluginManagerImpl;
import tvbrowser.extras.reminderplugin.ReminderFrame;
import tvbrowser.extras.reminderplugin.ReminderListItem;
import util.ui.Localizer;
import util.ui.TVBrowserIcons;

public class MinutesCellRenderer
extends DefaultTableCellRenderer {
    private static final Localizer mLocalizer = Localizer.getLocalizerFor(MinutesCellRenderer.class);
    private JPanel mPanel = new JPanel(new FormLayout("pref,pref:grow,pref,2dlu", "pref:grow,pref,2dlu,pref,pref:grow"));
    private JLabel mTextLabel;
    private JLabel mIconLabel;
    private JLabel mNoteLabel;

    public MinutesCellRenderer() {
        CellConstraints cc = new CellConstraints();
        this.mTextLabel = new JLabel();
        this.mIconLabel = new JLabel(TVBrowserIcons.edit(16));
        this.mNoteLabel = new JLabel("");
        this.mPanel.add((Component)this.mTextLabel, cc.xy(1, 2));
        this.mPanel.add((Component)this.mIconLabel, cc.xy(3, 2));
        this.mPanel.add((Component)this.mNoteLabel, cc.xy(1, 4));
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        Component def = super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        if (value instanceof ReminderListItem) {
            ReminderListItem listItem = (ReminderListItem)value;
            if (listItem.getProgram().equals(PluginManagerImpl.getInstance().getExampleProgram())) {
                JPanel separator = new JPanel(new FormLayout("0dlu:grow,default,0dlu:grow", "5dlu,default,5dlu"));
                separator.setBorder(BorderFactory.createMatteBorder(2, 0, 2, 0, UIManager.getColor("Label.foreground")));
                return separator;
            }
            Integer minutes = listItem.getMinutes();
            this.mTextLabel.setText(ReminderFrame.getStringForMinutes(minutes));
            this.mTextLabel.setOpaque(def.isOpaque());
            this.mTextLabel.setForeground(def.getForeground());
            this.mTextLabel.setBackground(def.getBackground());
            this.mPanel.setOpaque(def.isOpaque());
            this.mPanel.setBackground(def.getBackground());
            String comment = listItem.getComment();
            if (comment != null && !comment.isEmpty()) {
                this.mNoteLabel.setVisible(true);
                this.mNoteLabel.setText(mLocalizer.msg("note", "Note: {0}", comment));
                this.mNoteLabel.setOpaque(def.isOpaque());
                this.mNoteLabel.setForeground(def.getForeground());
                this.mNoteLabel.setBackground(def.getBackground());
            } else {
                this.mNoteLabel.setVisible(false);
            }
            return this.mPanel;
        }
        return def;
    }
}

