/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.extras.reminderplugin;

import com.jgoodies.forms.builder.PanelBuilder;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.RowSpec;
import devplugin.Date;
import devplugin.Program;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import tvbrowser.core.Settings;
import tvbrowser.extras.favoritesplugin.core.Favorite;
import tvbrowser.extras.favoritesplugin.dlgs.FavoriteTreeModel;
import tvbrowser.extras.reminderplugin.RemindValue;
import tvbrowser.extras.reminderplugin.ReminderContent;
import tvbrowser.extras.reminderplugin.ReminderList;
import tvbrowser.extras.reminderplugin.ReminderListDialog;
import tvbrowser.extras.reminderplugin.ReminderListItem;
import tvbrowser.extras.reminderplugin.ReminderPlugin;
import tvbrowser.extras.reminderplugin.ReminderPluginProxy;
import tvbrowser.extras.reminderplugin.ReminderPropertyDefaults;
import tvbrowser.ui.mainframe.MainFrame;
import util.io.IOUtilities;
import util.settings.PluginPictureSettings;
import util.settings.ProgramPanelSettings;
import util.ui.Localizer;
import util.ui.ProgramPanel;
import util.ui.UiUtilities;
import util.ui.WindowClosingIf;

public class ReminderFrame
implements WindowClosingIf,
ChangeListener {
    private static final Localizer mLocalizer = Localizer.getLocalizerFor(ReminderFrame.class);
    public static final int DONT_REMIND_AGAIN = -31;
    public static final int NO_REMINDER = -42;
    static final RemindValue DONT_REMIND_AGAIN_VALUE = new RemindValue(-31);
    static final RemindValue[] REMIND_AFTER_VALUE_ARR = new RemindValue[]{new RemindValue(-30), new RemindValue(-20), new RemindValue(-10), new RemindValue(-5), new RemindValue(-1)};
    static final RemindValue[] REMIND_BEFORE_VALUE_ARR = new RemindValue[]{new RemindValue(0), new RemindValue(1), new RemindValue(2), new RemindValue(3), new RemindValue(5), new RemindValue(10), new RemindValue(15), new RemindValue(30), new RemindValue(60), new RemindValue(90), new RemindValue(120), new RemindValue(240), new RemindValue(480), new RemindValue(720), new RemindValue(1440), new RemindValue(10080)};
    private JDialog mDialog;
    private ReminderList mGlobalReminderList;
    private JComboBox mReminderCB;
    private JButton mCloseBt;
    private String mCloseBtText;
    private Timer mAutoCloseTimer;
    private int mRemainingSecs;
    private long mAutoCloseAtMillis;
    private JLabel mHeader;
    private AbstractList<ReminderListItem> mReminderItems;
    private Hashtable<ReminderListItem, Integer[]> mPanelRange = new Hashtable();
    private FormLayout mLayout;
    private Hashtable<ReminderListItem, List<JComponent>> mComponents = new Hashtable();

    public ReminderFrame(ReminderList list, AbstractList<ReminderListItem> reminders, int autoCloseSecs) {
        int i;
        this.mGlobalReminderList = list;
        this.mReminderItems = reminders;
        Window parent = UiUtilities.getLastModalChildOf(MainFrame.getInstance());
        String title = mLocalizer.msg("title", "Reminder");
        if (reminders.size() == 1) {
            boolean found = false;
            for (Favorite favorite : FavoriteTreeModel.getInstance().getFavoriteArr()) {
                for (Program program : favorite.getPrograms()) {
                    if (!program.equals(reminders.get(0).getProgram())) continue;
                    title = favorite.getName();
                    found = true;
                    break;
                }
                if (found) break;
            }
        }
        this.mDialog = new JDialog(parent, title);
        UiUtilities.registerForClosing(this);
        JPanel jcontentPane = new JPanel(new BorderLayout(0, 10));
        jcontentPane.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.mDialog.setContentPane(jcontentPane);
        this.mLayout = new FormLayout("pref:grow,3dlu,pref", "pref,3dlu");
        PanelBuilder programsPanel = new PanelBuilder(this.mLayout);
        CellConstraints cc = new CellConstraints();
        Date today = Date.getCurrentDate();
        this.mHeader = new JLabel("");
        programsPanel.add((Component)this.mHeader, cc.xyw(1, 1, 3));
        programsPanel.setRow(3);
        int remainingMinutesMax = 0;
        int runningMinutes = 0;
        int maxLength = 0;
        ArrayList<ProgramPanel> panels = new ArrayList<ProgramPanel>(reminders.size());
        for (ReminderListItem reminder : reminders) {
            String msg;
            Program program = reminder.getProgram();
            maxLength = Math.max(maxLength, program.getLength());
            this.mGlobalReminderList.blockProgram(program);
            int progMinutesAfterMidnight = program.getStartTime();
            int minutesAfterMidnight = IOUtilities.getMinutesAfterMidnight() + 1440 * program.getDate().getNumberOfDaysSince(Date.getCurrentDate());
            int remainingMinutes = 0;
            if (program.isOnAir()) {
                runningMinutes = Math.max(runningMinutes, minutesAfterMidnight - progMinutesAfterMidnight);
            } else if (program.isExpired()) {
                runningMinutes = -1;
            }
            if (today.compareTo(program.getDate()) >= 0 && minutesAfterMidnight > progMinutesAfterMidnight) {
                msg = this.updateRunningTime();
            } else {
                msg = mLocalizer.msg("soonStarts", "Soon starts");
                remainingMinutes = ReminderPlugin.getTimeToProgramStart(program);
            }
            this.mHeader.setText(msg);
            remainingMinutesMax = Math.max(remainingMinutesMax, remainingMinutes);
            ArrayList<JComponent> componentList = new ArrayList<JComponent>();
            this.mComponents.put(reminder, componentList);
            ProgramPanel panel = new ProgramPanel(program, new ProgramPanelSettings(new PluginPictureSettings(0), false, 0, false, true, false));
            componentList.add(panel);
            panels.add(panel);
            panel.setMinimumSize(new Dimension(300, 50));
            panel.setWidth(300);
            panel.setToolTipText("");
            panel.addPluginContextMenuMouseListener(ReminderPluginProxy.getInstance());
            JPanel channelPanel = new JPanel(new BorderLayout());
            componentList.add(channelPanel);
            if (program.getLength() > 0) {
                JLabel endTime = new JLabel(mLocalizer.msg("endTime", "until {0}", program.getEndTimeString()));
                channelPanel.add((Component)endTime, "First");
            }
            String sortNumber = "";
            if (Settings.propShowSortNumberInProgramLists.getBoolean() && program.getChannel().getSortNumber().trim().length() > 0) {
                sortNumber = program.getChannel().getSortNumber() + ". ";
            }
            String channelName = sortNumber + program.getChannel().getName();
            JLabel channelLabel = new JLabel();
            channelLabel.setToolTipText(channelName);
            channelLabel.setIcon(UiUtilities.createChannelIcon(program.getChannel().getIcon()));
            channelLabel.setHorizontalTextPosition(4);
            channelPanel.add((Component)channelLabel, "Center");
            channelLabel = new JLabel(channelName);
            channelPanel.add((Component)channelLabel, "Last");
            int layoutStartRow = programsPanel.getRowCount();
            this.mLayout.appendRow(RowSpec.decode("pref"));
            programsPanel.add((Component)panel, cc.xy(1, programsPanel.getRow(), CellConstraints.FILL, CellConstraints.FILL));
            programsPanel.add((Component)channelPanel, cc.xy(3, programsPanel.getRow(), CellConstraints.LEFT, CellConstraints.TOP));
            programsPanel.nextRow();
            String comment = reminder.getComment();
            if (comment != null && comment.length() > 0) {
                this.mLayout.appendRow(RowSpec.decode("2dlu"));
                this.mLayout.appendRow(RowSpec.decode("pref"));
                this.mLayout.appendRow(RowSpec.decode("2dlu"));
                JLabel commentLabel = new JLabel(comment);
                componentList.add(commentLabel);
                programsPanel.add((Component)commentLabel, cc.xyw(1, programsPanel.getRow() + 1, 3));
                programsPanel.nextRow(3);
            }
            int layoutEndRow = programsPanel.getRowCount();
            this.mPanelRange.put(reminder, new Integer[]{layoutStartRow, layoutEndRow});
        }
        this.mRemainingSecs = autoCloseSecs;
        this.mAutoCloseAtMillis = System.currentTimeMillis() + (long)(1000 * autoCloseSecs);
        JPanel btnPanel = new JPanel(new BorderLayout(10, 0));
        this.mCloseBtText = Localizer.getLocalization("i18n_close");
        int seconds = this.mRemainingSecs;
        if (ReminderPlugin.getInstance().getSettings().getProperty("showTimeCounter", "false").compareTo("true") == 0) {
            seconds = 10;
        }
        this.mCloseBt = new JButton(this.getCloseButtonText(seconds));
        this.mDialog.getRootPane().setDefaultButton(this.mCloseBt);
        for (ReminderListItem reminder : reminders) {
            if (reminder.getMinutes() >= remainingMinutesMax) continue;
            remainingMinutesMax = reminder.getMinutes();
        }
        this.mReminderCB = new JComboBox();
        for (i = 0; i < REMIND_AFTER_VALUE_ARR.length && runningMinutes - Math.abs(REMIND_AFTER_VALUE_ARR[i].getMinutes()) < 0; ++i) {
            if (runningMinutes < 0 || Math.abs(REMIND_AFTER_VALUE_ARR[i].getMinutes()) >= maxLength) continue;
            this.mReminderCB.addItem(REMIND_AFTER_VALUE_ARR[i]);
        }
        this.mReminderCB.addItem(DONT_REMIND_AGAIN_VALUE);
        this.mReminderCB.setSelectedItem(DONT_REMIND_AGAIN_VALUE);
        i = 0;
        while (i < REMIND_BEFORE_VALUE_ARR.length && REMIND_BEFORE_VALUE_ARR[i].getMinutes() < remainingMinutesMax) {
            this.mReminderCB.addItem(REMIND_BEFORE_VALUE_ARR[i++]);
        }
        this.mReminderCB.setVisible(this.mReminderCB.getItemCount() > 1);
        btnPanel.add((Component)this.mReminderCB, "West");
        btnPanel.add((Component)this.mCloseBt, "East");
        JScrollPane scrollPane = new JScrollPane(programsPanel.getPanel());
        scrollPane.setBorder(BorderFactory.createEmptyBorder());
        jcontentPane.add((Component)scrollPane, "Center");
        jcontentPane.add((Component)btnPanel, "South");
        this.mCloseBt.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                ReminderFrame.this.close();
            }
        });
        if (this.mRemainingSecs > 0) {
            this.updateCloseBtText();
            this.mAutoCloseTimer = new Timer(1000, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    ReminderFrame.this.handleTimerEvent();
                }
            });
            this.mAutoCloseTimer.start();
        }
        for (ProgramPanel programPanel : panels) {
            programPanel.setMinimumSize(new Dimension(300, 50));
        }
        this.mDialog.pack();
        int height = Math.min(this.mDialog.getHeight(), Toolkit.getDefaultToolkit().getScreenSize().height - 60);
        this.mDialog.setSize(this.mDialog.getWidth() + scrollPane.getVerticalScrollBar().getPreferredSize().width, height + scrollPane.getHorizontalScrollBar().getPreferredSize().height);
        this.mCloseBt.setText(this.mCloseBtText);
        this.mDialog.setAlwaysOnTop(ReminderPlugin.getInstance().getSettings().getProperty("alwaysOnTop", "true").equalsIgnoreCase("true"));
        int windowLocation = Integer.parseInt(ReminderPropertyDefaults.getPropertyDefaults().getValueFromProperties("reminderWindowPosition", ReminderPlugin.getInstance().getSettings()));
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        switch (windowLocation) {
            case 0: {
                this.mDialog.setLocation(0, 0);
                break;
            }
            case 1: {
                this.mDialog.setLocation(screenSize.width / 2 - this.mDialog.getWidth() / 2, 0);
                break;
            }
            case 2: {
                this.mDialog.setLocation(screenSize.width - this.mDialog.getWidth(), 0);
                break;
            }
            case 3: {
                this.mDialog.setLocation(screenSize.width / 4 - this.mDialog.getWidth() / 2, screenSize.height / 4 - this.mDialog.getHeight() / 2);
                break;
            }
            case 4: {
                this.mDialog.setLocation(screenSize.width / 4 * 3 - this.mDialog.getWidth() / 2, screenSize.height / 4 - this.mDialog.getHeight() / 2);
                break;
            }
            case 5: {
                this.mDialog.setLocation(0, screenSize.height / 2 - this.mDialog.getHeight() / 2);
                break;
            }
            case 6: {
                this.mDialog.setLocation(screenSize.width / 2 - this.mDialog.getWidth() / 2, screenSize.height / 2 - this.mDialog.getHeight() / 2);
                break;
            }
            case 7: {
                this.mDialog.setLocation(screenSize.width - this.mDialog.getWidth(), screenSize.height / 2 - this.mDialog.getHeight() / 2);
                break;
            }
            case 8: {
                this.mDialog.setLocation(screenSize.width / 4 - this.mDialog.getWidth() / 2, screenSize.height / 4 * 3 - this.mDialog.getHeight() / 2);
                break;
            }
            case 9: {
                this.mDialog.setLocation(screenSize.width / 4 * 3 - this.mDialog.getWidth() / 2, screenSize.height / 4 * 3 - this.mDialog.getHeight() / 2);
                break;
            }
            case 10: {
                this.mDialog.setLocation(0, screenSize.height - this.mDialog.getHeight());
                break;
            }
            case 11: {
                this.mDialog.setLocation(screenSize.width / 2 - this.mDialog.getWidth() / 2, screenSize.height - this.mDialog.getHeight());
                break;
            }
            case 12: {
                this.mDialog.setLocation(screenSize.width - this.mDialog.getWidth(), screenSize.height - this.mDialog.getHeight());
            }
        }
        this.mDialog.setVisible(true);
        this.mDialog.toFront();
        if (this.mDialog.isAlwaysOnTop()) {
            this.mDialog.addWindowFocusListener(new WindowFocusListener(){

                @Override
                public void windowGainedFocus(WindowEvent e) {
                }

                @Override
                public void windowLostFocus(WindowEvent e) {
                    ReminderFrame.this.mDialog.setAlwaysOnTop(false);
                    UiUtilities.getLastModalChildOf(MainFrame.getInstance()).toFront();
                }
            });
        }
        this.mDialog.setDefaultCloseOperation(0);
        this.mDialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                ReminderFrame.this.close();
            }
        });
        for (ReminderListItem reminder : reminders) {
            reminder.getProgram().addChangeListener(this);
        }
    }

    private String updateRunningTime() {
        String msg = null;
        ReminderListItem reminder = this.mReminderItems.get(0);
        for (ReminderListItem r : this.mReminderItems) {
            if (r.getProgram().isOnAir()) {
                reminder = r;
                continue;
            }
            if (!r.getProgram().isExpired()) continue;
            Integer[] range = this.mPanelRange.get(r);
            for (int i = range[0].intValue(); i < range[1]; ++i) {
                this.mLayout.setRowSpec(i, RowSpec.decode("0"));
            }
            List<JComponent> componentList = this.mComponents.get(r);
            if (componentList == null) continue;
            for (JComponent component : componentList) {
                component.setVisible(false);
            }
        }
        Program program = reminder.getProgram();
        if (program.isOnAir()) {
            int progMinutesAfterMidnight = program.getHours() * 60 + program.getMinutes();
            int minutesRunning = IOUtilities.getMinutesAfterMidnight() - progMinutesAfterMidnight;
            if (minutesRunning < 0) {
                minutesRunning += 1440;
            }
            msg = minutesRunning == 0 ? mLocalizer.msg("alreadyRunning", "Just started") : (minutesRunning == 1 ? mLocalizer.msg("alreadyRunningMinute", "Already running {0} minute", minutesRunning) : mLocalizer.msg("alreadyRunningMinutes", "Already running {0} minutes", minutesRunning));
        } else {
            msg = program.isExpired() ? mLocalizer.msg("ended", "Program elapsed") : mLocalizer.msg("soonStarts", "Soon starts");
        }
        if (this.mHeader != null) {
            this.mHeader.setText(msg);
        }
        return msg;
    }

    private void handleTimerEvent() {
        this.mRemainingSecs = Math.max(0, (int)(this.mAutoCloseAtMillis - System.currentTimeMillis()) / 1000);
        if (this.mRemainingSecs <= 0) {
            this.close();
        } else {
            this.updateCloseBtText();
            this.updateRunningTime();
        }
    }

    private void updateCloseBtText() {
        if (this.mRemainingSecs <= 10 || ReminderPlugin.getInstance().getSettings().getProperty("showTimeCounter", "false").compareTo("true") == 0) {
            this.mCloseBt.setText(this.getCloseButtonText(this.mRemainingSecs));
        }
    }

    private String getCloseButtonText(int seconds) {
        StringBuilder builder = new StringBuilder(this.mCloseBtText);
        builder.append(" (");
        if (seconds <= 60) {
            builder.append(seconds);
        } else {
            int minutes;
            if (seconds >= 3600) {
                int hours = seconds / 3600;
                builder.append(hours).append(":");
                seconds -= 3600 * hours;
            }
            if ((minutes = seconds / 60) < 10 && minutes > -10) {
                builder.append("0");
            }
            builder.append(minutes).append(":");
            if ((seconds -= 60 * minutes) < 10 && seconds > -10) {
                builder.append("0");
            }
            builder.append(seconds);
        }
        return builder.append(")").toString();
    }

    @Override
    public void close() {
        int minutes = ((RemindValue)this.mReminderCB.getSelectedItem()).getMinutes();
        for (ReminderListItem reminder : this.mReminderItems) {
            this.mGlobalReminderList.removeWithoutChecking(reminder.getProgramItem());
            if (minutes == -31) continue;
            Program program = reminder.getProgram();
            this.mGlobalReminderList.add(program, new ReminderContent(minutes, reminder.getComment()));
            this.mGlobalReminderList.unblockProgram(program);
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ReminderPlugin.getInstance().updateRootNode(true);
            }
        });
        if (this.mAutoCloseTimer != null) {
            this.mAutoCloseTimer.stop();
        }
        this.mDialog.dispose();
        ReminderListDialog.updateReminderList();
    }

    @Override
    public JRootPane getRootPane() {
        return this.mDialog.getRootPane();
    }

    public static String getStringForMinutes(int minutes) {
        int i;
        if (minutes == -31) {
            return DONT_REMIND_AGAIN_VALUE.toString();
        }
        for (i = 0; i < REMIND_BEFORE_VALUE_ARR.length; ++i) {
            if (REMIND_BEFORE_VALUE_ARR[i].getMinutes() != minutes) continue;
            return REMIND_BEFORE_VALUE_ARR[i].toString();
        }
        for (i = 0; i < REMIND_AFTER_VALUE_ARR.length; ++i) {
            if (REMIND_AFTER_VALUE_ARR[i].getMinutes() != minutes) continue;
            return REMIND_AFTER_VALUE_ARR[i].toString();
        }
        return null;
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.updateRunningTime();
    }
}

