/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.extras.reminderplugin;

import devplugin.Date;
import devplugin.Plugin;
import devplugin.Program;
import devplugin.ProgramItem;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.DataOutput;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Collections;
import javax.swing.Timer;
import tvbrowser.core.ChannelList;
import tvbrowser.extras.reminderplugin.ReminderContent;
import tvbrowser.extras.reminderplugin.ReminderListItem;
import tvbrowser.extras.reminderplugin.ReminderPlugin;
import tvbrowser.extras.reminderplugin.ReminderPluginProxy;
import tvbrowser.extras.reminderplugin.ReminderTimerListener;
import util.io.IOUtilities;

public class ReminderList
implements ActionListener {
    private static final int MINUTES_PER_DAY = 1440;
    private ReminderTimerListener mListener = null;
    private Timer mTimer;
    private ArrayList<ReminderListItem> mList;
    private ArrayList<Program> mBlockedPrograms = new ArrayList();
    private boolean needsSort = false;

    public ReminderList() {
        this.mList = new ArrayList();
    }

    public void read(ObjectInputStream in) throws IOException, ClassNotFoundException {
        int version = in.readInt();
        if (version == 1 || version >= 3) {
            int size = in.readInt();
            for (int i = 0; i < size; ++i) {
                in.readInt();
                int reminderMinutes = in.readInt();
                String comment = null;
                if (version >= 5) {
                    comment = in.readUTF();
                }
                Date programDate = Date.readData(in);
                String programId = (String)in.readObject();
                Program program = Plugin.getPluginManager().getProgram(programDate, programId);
                int referenceCount = 1;
                if (version >= 4) {
                    referenceCount = in.readInt();
                }
                if (program == null) continue;
                this.add(program, new ReminderContent(reminderMinutes, comment), referenceCount);
            }
        }
    }

    public void writeData(ObjectOutputStream out) throws IOException {
        out.writeInt(5);
        ReminderListItem[] items = this.getReminderItems();
        out.writeInt(items.length);
        for (ReminderListItem item : items) {
            out.writeInt(3);
            out.writeInt(item.getMinutes());
            out.writeUTF(item.getComment());
            Date date = item.getProgram().getDate();
            date.writeData((DataOutput)out);
            out.writeObject(item.getProgram().getID());
            out.writeInt(item.getReferenceCount());
        }
    }

    public void add(Program program, ReminderContent reminderContent) {
        this.add(program, reminderContent, 1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void add(Program program, int minutes, int referenceCount) {
        if (!program.isExpired() && minutes != -42) {
            ReminderListItem item = this.getReminderItem(program);
            if (item != null) {
                item.incReferenceCount();
            } else {
                item = new ReminderListItem(program, minutes);
                item.setReferenceCount(referenceCount);
                ArrayList<ReminderListItem> arrayList = this.mList;
                synchronized (arrayList) {
                    this.mList.add(item);
                }
                this.needsSort = true;
                program.mark(ReminderPluginProxy.getInstance());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void add(Program program, ReminderContent reminderContent, int referenceCount) {
        if (!program.isExpired() && reminderContent.getReminderMinutes() != -42) {
            ReminderListItem item = this.getReminderItem(program);
            if (item != null) {
                item.incReferenceCount();
            } else {
                item = new ReminderListItem(program, reminderContent);
                item.setReferenceCount(referenceCount);
                ArrayList<ReminderListItem> arrayList = this.mList;
                synchronized (arrayList) {
                    this.mList.add(item);
                }
                this.needsSort = true;
                program.mark(ReminderPluginProxy.getInstance());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAndCheckBlocked(Program[] programs, int minutes) {
        for (Program program : programs) {
            if (!(this.contains(program) || this.mBlockedPrograms.contains(program) || program.isExpired())) {
                ReminderListItem item = new ReminderListItem(program, minutes);
                ArrayList<ReminderListItem> arrayList = this.mList;
                synchronized (arrayList) {
                    this.mList.add(item);
                }
                this.needsSort = true;
                program.mark(ReminderPluginProxy.getInstance());
                continue;
            }
            if (!this.contains(program)) continue;
            this.getReminderItem(program).incReferenceCount();
        }
    }

    public void setReminderTimerListener(ReminderTimerListener listener) {
        this.mListener = listener;
        if (ReminderPlugin.getInstance().isAllowedToStartTimer()) {
            this.startTimer();
        }
    }

    protected void startTimer() {
        if (this.mListener != null && this.mTimer == null) {
            this.mTimer = new Timer(10000, this);
            this.mTimer.start();
        } else if (!this.mTimer.isRunning()) {
            this.mTimer.start();
        }
    }

    public void removeExpiredItems() {
        ArrayList localItems = (ArrayList)this.mList.clone();
        for (ReminderListItem item : localItems) {
            Program program = item.getProgram();
            if (program != null && !program.isExpired() && ChannelList.isSubscribedChannel(program.getChannel())) continue;
            this.remove(item);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void remove(ReminderListItem item) {
        item.decReferenceCount();
        if (item.getReferenceCount() < 1) {
            ArrayList<ReminderListItem> arrayList = this.mList;
            synchronized (arrayList) {
                this.mList.remove(item);
            }
            this.needsSort = true;
            item.getProgram().unmark(ReminderPluginProxy.getInstance());
        }
    }

    public void remove(ProgramItem item) {
        this.remove(item.getProgram());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(Program program) {
        ArrayList<ReminderListItem> arrayList = this.mList;
        synchronized (arrayList) {
            for (ReminderListItem item : this.mList) {
                if (!item.getProgram().equals(program)) continue;
                return true;
            }
        }
        return false;
    }

    public void remove(Program program) {
        this.remove(new Program[]{program});
    }

    public void remove(Program[] programs) {
        ArrayList localItems = (ArrayList)this.mList.clone();
        block0: for (Program program : programs) {
            for (ReminderListItem item : localItems) {
                if (program == null || item == null || item.getProgram() != null && !item.getProgram().equals(program)) continue;
                this.remove(item);
                continue block0;
            }
        }
    }

    public void removeWithoutChecking(ProgramItem item) {
        this.removeWithoutChecking(item.getProgram());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ReminderListItem removeWithoutChecking(Program program) {
        ArrayList<ReminderListItem> arrayList = this.mList;
        synchronized (arrayList) {
            for (ReminderListItem item : this.mList) {
                if (!item.getProgram().equals(program)) continue;
                this.mList.remove(item);
                this.needsSort = true;
                item.getProgram().unmark(ReminderPluginProxy.getInstance());
                return item;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addWithoutChecking(ReminderListItem item) {
        ArrayList<ReminderListItem> arrayList = this.mList;
        synchronized (arrayList) {
            this.mList.add(item);
        }
        this.needsSort = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ReminderListItem getReminderItem(Program program) {
        ArrayList<ReminderListItem> arrayList = this.mList;
        synchronized (arrayList) {
            for (ReminderListItem item : this.mList) {
                if (!item.getProgram().equals(program)) continue;
                return item;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ReminderListItem[] getReminderItems() {
        ArrayList<ReminderListItem> arrayList = this.mList;
        synchronized (arrayList) {
            if (this.needsSort) {
                Collections.sort(this.mList);
                this.needsSort = false;
            }
            ReminderListItem[] items = this.mList.toArray(new ReminderListItem[this.mList.size()]);
            return items;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Program[] updatePrograms() {
        ArrayList localItems;
        ArrayList<ReminderListItem> arrayList = this.mList;
        synchronized (arrayList) {
            localItems = (ArrayList)this.mList.clone();
            this.mList.clear();
        }
        ArrayList<Program> removedPrograms = new ArrayList<Program>();
        for (ReminderListItem item : localItems) {
            if (item.getProgram().getProgramState() == 2) {
                removedPrograms.add(item.getProgram());
                continue;
            }
            if (item.getProgram().getProgramState() == 1) {
                Program p = item.getProgram();
                this.add(Plugin.getPluginManager().getProgram(p.getDate(), p.getID()), item.getMinutes(), item.getReferenceCount());
                continue;
            }
            ArrayList<ReminderListItem> arrayList2 = this.mList;
            synchronized (arrayList2) {
                this.mList.add(item);
            }
            this.needsSort = true;
        }
        return removedPrograms.toArray(new Program[removedPrograms.size()]);
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        if (this.mListener == null) {
            this.mTimer.stop();
            return;
        }
        Date today = Date.getCurrentDate();
        ArrayList<ReminderListItem> reminders = new ArrayList<ReminderListItem>();
        for (ReminderListItem item : this.getReminderItems()) {
            if (!this.isRemindEventRequired(item.getProgram(), item.getMinutes(), today)) continue;
            reminders.add(item);
        }
        if (reminders.size() > 0) {
            this.mListener.timeEvent(reminders);
        }
    }

    private boolean isRemindEventRequired(Program prog, int remindMinutes, Date today) {
        int diff;
        if (remindMinutes < -30) {
            return false;
        }
        Date remindDate = prog.getDate();
        int remindTime = prog.getStartTime() - remindMinutes;
        if (remindTime < 0) {
            remindTime = -remindTime;
            int days = remindTime / 1440 + 1;
            remindTime = 1440 - remindTime % 1440;
            remindDate = remindDate.addDays(-days);
        }
        return ((diff = today.compareTo(remindDate)) > 0 || diff == 0 && IOUtilities.getMinutesAfterMidnight() >= remindTime) && !this.isBlocked(prog);
    }

    public void blockProgram(Program prg) {
        this.mBlockedPrograms.add(prg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unblockProgram(Program prg) {
        ArrayList<Program> arrayList = this.mBlockedPrograms;
        synchronized (arrayList) {
            this.mBlockedPrograms.remove(prg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isBlocked(Program prg) {
        ArrayList<Program> arrayList = this.mBlockedPrograms;
        synchronized (arrayList) {
            return this.mBlockedPrograms.contains(prg);
        }
    }

    void toggleTimer() {
        if (this.mTimer != null) {
            if (this.mTimer.isRunning()) {
                this.mTimer.stop();
            } else {
                this.startTimer();
            }
        }
    }

    boolean hasTimer() {
        return this.mTimer != null;
    }

    boolean isActive() {
        return this.mTimer != null && this.mTimer.isRunning();
    }
}

