/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.extras.reminderplugin;

import com.jgoodies.forms.factories.Borders;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import tvbrowser.core.Settings;
import tvbrowser.extras.reminderplugin.ReminderList;
import tvbrowser.extras.reminderplugin.ReminderListPanel;
import util.ui.Localizer;
import util.ui.UiUtilities;
import util.ui.WindowClosingIf;

public class ReminderListDialog
extends JDialog
implements WindowClosingIf {
    static final Localizer mLocalizer = Localizer.getLocalizerFor(ReminderListDialog.class);
    private ReminderListPanel mReminderListPanel;
    private static ReminderListDialog mInstance;

    public ReminderListDialog(Window parent, ReminderList list) {
        super(parent);
        this.setModal(true);
        UiUtilities.registerForClosing(this);
        this.setTitle(mLocalizer.msg("title", "Reminder"));
        this.createGui(list);
    }

    private void createGui(ReminderList list) {
        mInstance = this;
        this.setLayout(new BorderLayout());
        JButton ok = new JButton(Localizer.getLocalization("i18n_close"));
        ok.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ReminderListDialog.this.mReminderListPanel.stopCellEditing();
                ReminderListDialog.this.dispose();
            }
        });
        this.mReminderListPanel = new ReminderListPanel(list, ok);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                mInstance = null;
            }
        });
        this.add((Component)this.mReminderListPanel, "Center");
        ((JPanel)this.getContentPane()).setBorder(Borders.DIALOG);
        this.getRootPane().setDefaultButton(ok);
        Settings.layoutWindow("extras.reminderListDlg", this, new Dimension(550, 350));
    }

    public static ReminderListDialog getInstance() {
        return mInstance;
    }

    @Override
    public void close() {
        mInstance = null;
        this.dispose();
    }

    public static void updateReminderList() {
        ReminderListDialog dlg = mInstance;
        if (dlg != null) {
            dlg.mReminderListPanel.updateTableEntries();
        }
    }
}

