/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.extras.reminderplugin;

import devplugin.AfterDataUpdateInfoPanel;
import devplugin.Program;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import tvbrowser.core.plugin.PluginManagerImpl;
import tvbrowser.extras.reminderplugin.ReminderPlugin;
import util.settings.ProgramPanelSettings;
import util.ui.Localizer;
import util.ui.ProgramList;

public class RemovedProgramsPanel
extends AfterDataUpdateInfoPanel {
    private static final Localizer mLocalizer = Localizer.getLocalizerFor(RemovedProgramsPanel.class);
    private JCheckBox mDisable;
    private ProgramList mProgramList;

    public RemovedProgramsPanel(Program[] programs) {
        this.init(programs);
    }

    private void init(Program[] programs) {
        this.setLayout(new BorderLayout(6, 6));
        JLabel lb = new JLabel(mLocalizer.msg("header", "<html>Die folgenden Sendungen, an die sie erinnert werden wollten, sind in der aktualisierten Programmvorschau nicht mehr enthalten:</html>"));
        this.mDisable = new JCheckBox(mLocalizer.msg("dontShowAnymore", "Don't show anymore"));
        this.mDisable.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                ReminderPlugin.getInstance().getSettings().setProperty("showRemovedDialog", String.valueOf(e.getStateChange() == 2));
            }
        });
        this.add((Component)lb, "North");
        this.mProgramList = new ProgramList(programs, ProgramPanelSettings.getShowOnlyDateAndTitleSettings());
        this.mProgramList.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    RemovedProgramsPanel.this.showPopup(e);
                }
            }

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    RemovedProgramsPanel.this.showPopup(e);
                }
            }
        });
        this.add((Component)new JScrollPane(this.mProgramList), "Center");
        this.add((Component)this.mDisable, "South");
        this.setPreferredSize(new Dimension(300, 200));
    }

    private void showPopup(MouseEvent e) {
        int row = this.mProgramList.locationToIndex(e.getPoint());
        this.mProgramList.setSelectedIndex(row);
        Program p = (Program)this.mProgramList.getSelectedValue();
        JPopupMenu menu = PluginManagerImpl.getInstance().createRemovedProgramContextMenu(p);
        menu.show(this.mProgramList, e.getX(), e.getY());
    }

    @Override
    public void closed() {
    }
}

