/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.extras.searchplugin;

import devplugin.ActionMenu;
import devplugin.ButtonAction;
import devplugin.Channel;
import devplugin.ContextMenuAction;
import devplugin.Program;
import devplugin.SettingsTab;
import devplugin.ThemeIcon;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import javax.swing.KeyStroke;
import tvbrowser.extras.common.ConfigurationHandler;
import tvbrowser.extras.common.DataDeserializer;
import tvbrowser.extras.common.DataSerializer;
import tvbrowser.extras.searchplugin.RepetitionDialog;
import tvbrowser.extras.searchplugin.SearchDialog;
import tvbrowser.extras.searchplugin.SearchSettingsTab;
import tvbrowser.ui.mainframe.MainFrame;
import util.exc.ErrorHandler;
import util.ui.Localizer;
import util.ui.SearchFormSettings;
import util.ui.TVBrowserIcons;
import util.ui.UiUtilities;

public class SearchPlugin {
    protected static final Localizer mLocalizer = Localizer.getLocalizerFor(SearchPlugin.class);
    private static final String DATAFILE_PREFIX = "searchplugin.SearchPlugin";
    private static SearchPlugin mInstance;
    private ConfigurationHandler mConfigurationHandler;
    private static SearchFormSettings[] mSearchHistory;
    private int mRepetitionTimeSelect = 3;
    private static boolean mAlwaysSearchExpert;

    private SearchPlugin() {
        mAlwaysSearchExpert = false;
        this.mConfigurationHandler = new ConfigurationHandler(DATAFILE_PREFIX);
        this.load();
    }

    private void load() {
        try {
            this.mConfigurationHandler.loadData(new DataDeserializer(){

                @Override
                public void read(ObjectInputStream in) throws IOException, ClassNotFoundException {
                    SearchPlugin.this.readData(in);
                }
            });
        }
        catch (IOException e) {
            ErrorHandler.handle(mLocalizer.msg("loadError", "Could not load search history"), e);
        }
    }

    public void store() {
        try {
            this.mConfigurationHandler.storeData(new DataSerializer(){

                @Override
                public void write(ObjectOutputStream out) throws IOException {
                    SearchPlugin.this.writeData(out);
                }
            });
        }
        catch (IOException e) {
            ErrorHandler.handle(mLocalizer.msg("storeError", "Could not store search history"), e);
        }
    }

    private void readData(ObjectInputStream in) throws IOException, ClassNotFoundException {
        int version = in.readInt();
        int historySize = in.readInt();
        mSearchHistory = new SearchFormSettings[historySize];
        for (int i = 0; i < historySize; ++i) {
            SearchFormSettings settings;
            if (version > 1) {
                settings = new SearchFormSettings(in);
            } else {
                String searchText = (String)in.readObject();
                in.readBoolean();
                boolean searchInInfoText = in.readBoolean();
                boolean caseSensitive = in.readBoolean();
                int option = in.readInt();
                settings = new SearchFormSettings(searchText);
                if (searchInInfoText) {
                    settings.setSearchIn(2);
                } else {
                    settings.setSearchIn(1);
                }
                settings.setCaseSensitive(caseSensitive);
                switch (option) {
                    case 1: {
                        settings.setSearcherType(2);
                        break;
                    }
                    case 2: {
                        settings.setSearcherType(3);
                        break;
                    }
                    default: {
                        settings.setSearcherType(1);
                    }
                }
            }
            SearchPlugin.mSearchHistory[i] = settings;
        }
        if (version >= 3 && version <= 4) {
            in.readInt();
            in.readInt();
            in.readInt();
            in.readInt();
            in.readBoolean();
            int n = in.readInt();
            for (int i = 0; i < n; ++i) {
                in.readUTF();
            }
        }
        if (version >= 4) {
            this.mRepetitionTimeSelect = in.readInt();
        }
        if (version >= 6) {
            mAlwaysSearchExpert = in.readBoolean();
        }
    }

    private void writeData(ObjectOutputStream out) throws IOException {
        out.writeInt(6);
        if (mSearchHistory == null) {
            out.writeInt(0);
        } else {
            out.writeInt(mSearchHistory.length);
            for (SearchFormSettings element : mSearchHistory) {
                element.writeData(out);
            }
        }
        out.writeInt(this.mRepetitionTimeSelect);
        out.writeBoolean(mAlwaysSearchExpert);
    }

    protected static ActionMenu getButtonAction() {
        ButtonAction action = new ButtonAction();
        action.setActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SearchPlugin.getInstance().openSearchDialog("");
            }
        });
        action.setBigIcon(TVBrowserIcons.search(22));
        action.setSmallIcon(TVBrowserIcons.search(16));
        action.setShortDescription(mLocalizer.msg("description", "Allows searching programs containing a certain text."));
        action.setText(mLocalizer.ellipsisMsg("searchPrograms", "Search programs"));
        action.putValue("####KEYBOARD_ACCELERATOR####", KeyStroke.getKeyStroke(70, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        return new ActionMenu(action);
    }

    protected static ActionMenu getContextMenuActions(final Program program) {
        ContextMenuAction action = new ContextMenuAction();
        action.setText(mLocalizer.msg("searchRepetion", "Search repetition"));
        action.setSmallIcon(TVBrowserIcons.search(16));
        action.setActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                SearchPlugin.searchRepetitions(program);
            }
        });
        return new ActionMenu(action);
    }

    public ThemeIcon getMarkIconFromTheme() {
        return new ThemeIcon("actions", "system-search", 16);
    }

    public static synchronized SearchPlugin getInstance() {
        if (mInstance == null) {
            mInstance = new SearchPlugin();
        }
        return mInstance;
    }

    protected static SearchFormSettings[] getSearchHistory() {
        return mSearchHistory;
    }

    protected static void setSearchHistory(SearchFormSettings[] history) {
        mSearchHistory = history;
    }

    public SettingsTab getSettingsTab() {
        return new SearchSettingsTab();
    }

    public static String getSearchPluginId() {
        return DATAFILE_PREFIX;
    }

    public String toString() {
        return SearchPlugin.getName();
    }

    static String getName() {
        return mLocalizer.msg("title", "Search");
    }

    public int getRepetitionTimeSelection() {
        return this.mRepetitionTimeSelect;
    }

    public void setRepetitionTimeSelection(int selectedIndex) {
        this.mRepetitionTimeSelect = selectedIndex;
    }

    protected void openSearchDialog(String text, SearchFormSettings settings) {
        Window parent = UiUtilities.getLastModalChildOf(MainFrame.getInstance());
        SearchDialog dlg = new SearchDialog(parent);
        dlg.setSearchText(text);
        if (settings != null) {
            dlg.setSearchSettings(settings);
        }
        UiUtilities.centerAndShow(dlg);
    }

    protected void openSearchDialog(String text) {
        this.openSearchDialog(text, null);
    }

    private static void searchRepetitions(Program program) {
        try {
            if (mAlwaysSearchExpert) {
                SearchPlugin.getInstance().openSearchDialog(program.getTitle());
            } else {
                Window parent = UiUtilities.getLastModalChildOf(MainFrame.getInstance());
                Channel channel = program.getChannel();
                RepetitionDialog dlg = new RepetitionDialog(parent, channel);
                dlg.setPatternText(program.getTitle());
                UiUtilities.centerAndShow(dlg);
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public static boolean getAlwaysSearchExpert() {
        return mAlwaysSearchExpert;
    }

    public static void setAlwaysSearchExpert(boolean value) {
        mAlwaysSearchExpert = value;
        SearchPlugin.getInstance().store();
    }
}

