/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.ui.configassistant;

import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.layout.Sizes;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.URI;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import tvbrowser.TVBrowser;
import tvbrowser.core.Settings;
import tvbrowser.ui.configassistant.AbstractCardPanel;
import tvbrowser.ui.configassistant.PrevNextButtons;
import tvbrowser.ui.configassistant.StatusPanel;
import util.io.NetworkUtilities;
import util.ui.Localizer;
import util.ui.UiUtilities;

class NetworkCardPanel
extends AbstractCardPanel {
    private static final Localizer mLocalizer = Localizer.getLocalizerFor(NetworkCardPanel.class);
    private JPanel mContent;
    private JLabel mHostLB;
    private JTextField mHostTF;
    private JLabel mPortLB;
    private JTextField mPortTF;
    private JCheckBox mProxyCB;
    private JLabel mProxyHeadline;
    private JPasswordField mPasswordTF;
    private JTextField mUserTF;
    private JLabel mPasswordLB;
    private JLabel mUserLB;
    private JCheckBox mAuthCB;

    public NetworkCardPanel(PrevNextButtons btns) {
        super(btns);
    }

    @Override
    public JPanel getPanel() {
        this.mContent = new JPanel(new BorderLayout());
        this.mContent.add((Component)new StatusPanel(0), "North");
        JPanel content = new JPanel(new FormLayout("fill:pref:grow, fill:300dlu:grow, fill:pref:grow", "fill:pref:grow, pref, 3dlu, pref, 3dlu, pref,3dlu, pref,3dlu, pref, fill:pref:grow"));
        content.setBorder(Borders.DLU4);
        CellConstraints cc = new CellConstraints();
        content.add((Component)UiUtilities.createHtmlHelpTextArea(mLocalizer.msg("preambel", "Preambel")), cc.xy(2, 2));
        this.mProxyCB = new JCheckBox(mLocalizer.msg("usingProxy", "Using Proxy"));
        this.mProxyCB.setSelected(Settings.propHttpProxyUseProxy.getBoolean());
        content.add((Component)this.mProxyCB, cc.xy(2, 6));
        JPanel proxyPanel = new JPanel(new FormLayout("fill:pref:grow", "pref, 3dlu, pref, 3dlu, pref, 3dlu, pref"));
        proxyPanel.setBorder(BorderFactory.createEmptyBorder(0, Sizes.dialogUnitXAsPixel(10, proxyPanel), 0, 0));
        this.mProxyHeadline = new JLabel(mLocalizer.msg("myProxy", "My Proxy"));
        proxyPanel.add((Component)this.mProxyHeadline, cc.xy(1, 1));
        JPanel hostPanel = new JPanel(new FormLayout("pref, 3dlu, pref, 3dlu, pref, 3dlu, pref", "pref"));
        this.mHostLB = new JLabel(mLocalizer.msg("host", "Host"));
        hostPanel.add((Component)this.mHostLB, cc.xy(1, 1));
        this.mHostTF = new JTextField(20);
        this.mHostTF.setText(Settings.propHttpProxyHost.getString());
        hostPanel.add((Component)this.mHostTF, cc.xy(3, 1));
        this.mPortLB = new JLabel(mLocalizer.msg("port", "Port"));
        hostPanel.add((Component)this.mPortLB, cc.xy(5, 1));
        this.mPortTF = new JTextField(4);
        hostPanel.add((Component)this.mPortTF, cc.xy(7, 1));
        this.mPortTF.setText(Settings.propHttpProxyPort.getString());
        proxyPanel.add((Component)hostPanel, cc.xy(1, 3));
        this.mAuthCB = new JCheckBox(mLocalizer.msg("auth", "authentification"));
        this.mAuthCB.setSelected(Settings.propHttpProxyAuthentifyAtProxy.getBoolean());
        proxyPanel.add((Component)this.mAuthCB, cc.xy(1, 5));
        JPanel userPanel = new JPanel(new FormLayout("10dlu, pref, 3dlu, pref, 3dlu, pref, 3dlu, pref", "pref"));
        this.mUserLB = new JLabel(mLocalizer.msg("user", "User"));
        userPanel.add((Component)this.mUserLB, cc.xy(2, 1));
        this.mUserTF = new JTextField(10);
        this.mUserTF.setText(Settings.propHttpProxyUser.getString());
        userPanel.add((Component)this.mUserTF, cc.xy(4, 1));
        this.mPasswordLB = new JLabel(mLocalizer.msg("password", "Password"));
        userPanel.add((Component)this.mPasswordLB, cc.xy(6, 1));
        this.mPasswordTF = new JPasswordField(10);
        this.mPasswordTF.setText(Settings.propHttpProxyPassword.getString());
        userPanel.add((Component)this.mPasswordTF, cc.xy(8, 1));
        proxyPanel.add((Component)userPanel, cc.xy(1, 7));
        content.add((Component)proxyPanel, cc.xy(2, 8));
        content.add((Component)UiUtilities.createHtmlHelpTextArea(mLocalizer.msg("closing", "Closing")), cc.xy(2, 10));
        this.mContent.add((Component)content, "Center");
        this.updateFieldState();
        this.mProxyCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NetworkCardPanel.this.updateFieldState();
            }
        });
        this.mAuthCB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NetworkCardPanel.this.updateFieldState();
            }
        });
        this.findProxySettings();
        return this.mContent;
    }

    private void findProxySettings() {
        try {
            System.getProperty("java.net.useSystemProxies", "true");
            List<Proxy> l = ProxySelector.getDefault().select(new URI("http://www.yahoo.com/"));
            for (Proxy proxy : l) {
                if (proxy.type() == Proxy.Type.DIRECT) {
                    return;
                }
                System.out.println("proxy hostname : " + (Object)((Object)proxy.type()));
                InetSocketAddress addr = (InetSocketAddress)proxy.address();
                if (addr == null) continue;
                System.out.println("proxy hostname : " + addr.getHostName());
                System.out.println("proxy port : " + addr.getPort());
                this.mHostTF.setText(addr.getHostName());
                this.mPortTF.setText(String.valueOf(addr.getPort()));
                this.mProxyCB.setSelected(true);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void updateFieldState() {
        boolean state = this.mProxyCB.isSelected();
        this.mProxyHeadline.setEnabled(state);
        this.mHostTF.setEnabled(state);
        this.mHostLB.setEnabled(state);
        this.mPortLB.setEnabled(state);
        this.mPortTF.setEnabled(state);
        this.mAuthCB.setEnabled(state);
        boolean auth = this.mAuthCB.isSelected();
        this.mUserLB.setEnabled(state && auth);
        this.mUserTF.setEnabled(state && auth);
        this.mPasswordLB.setEnabled(state && auth);
        this.mPasswordTF.setEnabled(state && auth);
    }

    @Override
    public boolean onNext() {
        Settings.propHttpProxyUseProxy.setBoolean(this.mProxyCB.isSelected());
        Settings.propHttpProxyHost.setString(this.mHostTF.getText());
        Settings.propHttpProxyPort.setString(this.mPortTF.getText());
        Settings.propHttpProxyAuthentifyAtProxy.setBoolean(this.mAuthCB.isSelected());
        Settings.propHttpProxyUser.setString(this.mUserTF.getText());
        Settings.propHttpProxyPassword.setString(new String(this.mPasswordTF.getPassword()));
        TVBrowser.updateProxySettings();
        if (!NetworkUtilities.checkConnection()) {
            JOptionPane.showMessageDialog(this.mContent, UiUtilities.createHtmlHelpTextArea(mLocalizer.msg("connectionError", "Connection Error")), Localizer.getLocalization("i18n_error"), 0);
            return false;
        }
        return true;
    }
}

