/*
 * Decompiled with CFR 0.152.
 */
package tvbrowser.ui.licensebox;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.Timer;
import javax.swing.UIManager;
import util.ui.Localizer;
import util.ui.UiUtilities;
import util.ui.WindowClosingIf;
import util.ui.html.HTMLTextHelper;

public class LicenseBox
extends JDialog
implements ActionListener,
WindowClosingIf {
    private int mRemainingSecs;
    private JButton mAgreeBt;
    private JButton mDisagreeBt;
    private JButton mCloseBt;
    private Timer mTimer;
    private boolean mAgreed = false;
    private boolean mMustAgree;
    private static final Localizer mLocalizer = Localizer.getLocalizerFor(LicenseBox.class);

    public LicenseBox(JFrame parent, String licenseTxt, boolean mustAgree) {
        super((Frame)parent, true);
        this.mMustAgree = mustAgree;
        this.setTitle(mLocalizer.msg("terms", "Terms of Use"));
        UiUtilities.registerForClosing(this);
        JPanel contentPane = (JPanel)this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        if (!licenseTxt.startsWith("<html")) {
            licenseTxt = HTMLTextHelper.convertTextToHtml(licenseTxt, true);
        }
        JEditorPane ta = UiUtilities.createHtmlHelpTextArea(licenseTxt, UIManager.getColor("EditorPane.background"));
        ta.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        ta.setOpaque(true);
        ta.setFocusable(true);
        JPanel btnPanel = new JPanel();
        this.mAgreeBt = new JButton(mLocalizer.msg("agree", "I agree"));
        this.mDisagreeBt = new JButton(mLocalizer.msg("disagree", "I do not agree"));
        this.mCloseBt = new JButton(Localizer.getLocalization("i18n_close"));
        this.mAgreeBt.addActionListener(this);
        this.mDisagreeBt.addActionListener(this);
        this.mAgreeBt.setEnabled(false);
        if (this.mMustAgree) {
            btnPanel.add(this.mDisagreeBt);
            btnPanel.add(this.mAgreeBt);
            this.mRemainingSecs = 5;
            this.mTimer = new Timer(1000, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    LicenseBox.this.mRemainingSecs--;
                    if (LicenseBox.this.mRemainingSecs == 0) {
                        LicenseBox.this.mAgreeBt.setText(mLocalizer.msg("agree", "I agree"));
                        LicenseBox.this.mAgreeBt.setEnabled(true);
                        LicenseBox.this.mTimer.stop();
                    } else {
                        LicenseBox.this.mAgreeBt.setText(mLocalizer.msg("agree", "I agree") + " (" + LicenseBox.this.mRemainingSecs + ") ");
                    }
                }
            });
            this.mTimer.start();
        } else {
            btnPanel.add(this.mCloseBt);
            this.mCloseBt.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    LicenseBox.this.setVisible(false);
                }
            });
        }
        JPanel panel1 = new JPanel(new BorderLayout());
        panel1.add((Component)new JScrollPane(ta), "Center");
        panel1.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        contentPane.add((Component)panel1, "Center");
        contentPane.add((Component)btnPanel, "South");
        this.setSize(460, 520);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.mDisagreeBt) {
            this.setVisible(false);
        } else if (e.getSource() == this.mAgreeBt) {
            this.mAgreed = true;
            this.setVisible(false);
        }
    }

    public boolean agreed() {
        return this.mAgreed;
    }

    @Override
    public void close() {
        if (!this.mMustAgree || this.agreed()) {
            this.dispose();
        }
    }
}

